/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.classwizard;

import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.ui.wizards.classwizard.IBaseClassInfo;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardMessages;
import org.eclipse.cdt.ui.browser.typeinfo.TypeInfoLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public final class BaseClassesLabelProvider
implements ITableLabelProvider {
    private static final String YES_VALUE = NewClassWizardMessages.getString("BaseClassesLabelProvider.boolean.yes.label");
    private static final String NO_VALUE = NewClassWizardMessages.getString("BaseClassesLabelProvider.boolean.no.label");
    private static final String ACCESS_PUBLIC = NewClassWizardMessages.getString("BaseClassesLabelProvider.access.public.label");
    private static final String ACCESS_PROTECTED = NewClassWizardMessages.getString("BaseClassesLabelProvider.access.protected.label");
    private static final String ACCESS_PRIVATE = NewClassWizardMessages.getString("BaseClassesLabelProvider.access.private.label");
    private static TypeInfoLabelProvider fTypeInfoLabelProvider = new TypeInfoLabelProvider(4);

    public static final String getYesNoText(boolean value) {
        return value ? YES_VALUE : NO_VALUE;
    }

    public static final String getAccessText(ASTAccessVisibility access) {
        if (access == ASTAccessVisibility.PRIVATE) {
            return ACCESS_PRIVATE;
        }
        if (access == ASTAccessVisibility.PROTECTED) {
            return ACCESS_PROTECTED;
        }
        return ACCESS_PUBLIC;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }
        IBaseClassInfo info = (IBaseClassInfo)element;
        return fTypeInfoLabelProvider.getImage(info.getType());
    }

    public String getColumnText(Object element, int columnIndex) {
        IBaseClassInfo info = (IBaseClassInfo)element;
        switch (columnIndex) {
            case 0: {
                return fTypeInfoLabelProvider.getText(info.getType());
            }
            case 1: {
                return BaseClassesLabelProvider.getAccessText(info.getAccess());
            }
            case 2: {
                return BaseClassesLabelProvider.getYesNoText(info.isVirtual());
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

