/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.classwizard;

import java.util.List;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.ui.wizards.classwizard.BaseClassesLabelProvider;
import org.eclipse.cdt.internal.ui.wizards.classwizard.IBaseClassInfo;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardMessages;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;

public class BaseClassesListDialogField
extends ListDialogField {
    private static final String CP_NAME = "name";
    private static final String CP_ACCESS = "access";
    private static final String CP_VIRTUAL = "virtual";
    static final Integer INDEX_YES = new Integer(0);
    static final Integer INDEX_NO = new Integer(1);
    static final Integer INDEX_PUBLIC = new Integer(0);
    static final Integer INDEX_PROTECTED = new Integer(1);
    static final Integer INDEX_PRIVATE = new Integer(2);

    public BaseClassesListDialogField(String title, IListAdapter listAdapter) {
        super(listAdapter, new String[]{NewClassWizardMessages.getString("BaseClassesListDialogField.buttons.add"), NewClassWizardMessages.getString("BaseClassesListDialogField.buttons.remove"), NewClassWizardMessages.getString("BaseClassesListDialogField.buttons.up"), NewClassWizardMessages.getString("BaseClassesListDialogField.buttons.down")}, (IBaseLabelProvider)new BaseClassesLabelProvider());
        this.setRemoveButtonIndex(1);
        this.setUpButtonIndex(2);
        this.setDownButtonIndex(3);
        this.setLabelText(title);
        String[] headers = new String[]{NewClassWizardMessages.getString("BaseClassesListDialogField.headings.name"), NewClassWizardMessages.getString("BaseClassesListDialogField.headings.access"), NewClassWizardMessages.getString("BaseClassesListDialogField.headings.virtual")};
        ColumnLayoutData[] columns = new ColumnLayoutData[]{new ColumnWeightData(70, 30), new ColumnWeightData(30, 30), new ColumnWeightData(25, 25)};
        this.setTableColumns(new ListDialogField.ColumnsDescription(columns, headers, true));
    }

    protected boolean managedButtonPressed(int index) {
        super.managedButtonPressed(index);
        return false;
    }

    protected TableViewer createTableViewer(Composite parent) {
        TableViewer viewer = super.createTableViewer(parent);
        Table table = viewer.getTable();
        ComboBoxCellEditor virtualCellEditor = new ComboBoxCellEditor((Composite)table, new String[]{BaseClassesLabelProvider.getYesNoText(true), BaseClassesLabelProvider.getYesNoText(false)}, 8);
        ComboBoxCellEditor accessCellEditor = new ComboBoxCellEditor((Composite)table, new String[]{BaseClassesLabelProvider.getAccessText(ASTAccessVisibility.PUBLIC), BaseClassesLabelProvider.getAccessText(ASTAccessVisibility.PROTECTED), BaseClassesLabelProvider.getAccessText(ASTAccessVisibility.PRIVATE)}, 8);
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[1] = accessCellEditor;
        cellEditorArray[2] = virtualCellEditor;
        viewer.setCellEditors(cellEditorArray);
        viewer.setColumnProperties(new String[]{CP_NAME, CP_ACCESS, CP_VIRTUAL});
        viewer.setCellModifier((ICellModifier)new CellHandler());
        return viewer;
    }

    public void addBaseClass(IBaseClassInfo baseClass) {
        this.addElement(baseClass);
    }

    public IBaseClassInfo[] getBaseClasses() {
        List baseClasses = this.getElements();
        return baseClasses.toArray(new IBaseClassInfo[baseClasses.size()]);
    }

    private final class CellHandler
    implements ICellModifier {
        private CellHandler() {
        }

        public boolean canModify(Object element, String property) {
            return element instanceof IBaseClassInfo && (property.equals(BaseClassesListDialogField.CP_ACCESS) || property.equals(BaseClassesListDialogField.CP_VIRTUAL));
        }

        public Object getValue(Object element, String property) {
            if (!(element instanceof IBaseClassInfo)) {
                return null;
            }
            IBaseClassInfo baseClass = (IBaseClassInfo)element;
            if (property.equals(BaseClassesListDialogField.CP_ACCESS)) {
                if (baseClass.getAccess() == ASTAccessVisibility.PRIVATE) {
                    return INDEX_PRIVATE;
                }
                if (baseClass.getAccess() == ASTAccessVisibility.PROTECTED) {
                    return INDEX_PROTECTED;
                }
                return INDEX_PUBLIC;
            }
            if (property.equals(BaseClassesListDialogField.CP_VIRTUAL)) {
                if (baseClass.isVirtual()) {
                    return INDEX_YES;
                }
                return INDEX_NO;
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            Object data;
            IBaseClassInfo baseClass = null;
            if (element instanceof IBaseClassInfo) {
                baseClass = (IBaseClassInfo)element;
            } else if (element instanceof Item && (data = ((Item)element).getData()) instanceof IBaseClassInfo) {
                baseClass = (IBaseClassInfo)data;
            }
            if (baseClass != null) {
                if (property.equals(BaseClassesListDialogField.CP_ACCESS) && value instanceof Integer) {
                    Integer access = (Integer)value;
                    if (access.equals(INDEX_PRIVATE)) {
                        baseClass.setAccess(ASTAccessVisibility.PRIVATE);
                    } else if (access.equals(INDEX_PROTECTED)) {
                        baseClass.setAccess(ASTAccessVisibility.PROTECTED);
                    } else {
                        baseClass.setAccess(ASTAccessVisibility.PUBLIC);
                    }
                    BaseClassesListDialogField.this.refresh();
                } else if (property.equals(BaseClassesListDialogField.CP_VIRTUAL) && value instanceof Integer) {
                    Integer yesno = (Integer)value;
                    baseClass.setVirtual(yesno.equals(INDEX_YES));
                    BaseClassesListDialogField.this.refresh();
                }
            }
        }
    }
}

