/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.dialogfields;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.internal.ui.SWTUtil;
import org.eclipse.cdt.debug.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IListAdapter;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class ListDialogField
extends DialogField {
    protected TableViewer fTable;
    protected ILabelProvider fLabelProvider;
    protected ListViewerAdapter fListViewerAdapter;
    protected List fElements;
    protected ViewerSorter fViewerSorter;
    protected String[] fButtonLabels;
    private Button[] fButtonControls;
    private boolean[] fButtonsEnabled;
    private int fRemoveButtonIndex;
    private int fUpButtonIndex;
    private int fDownButtonIndex;
    private Label fLastSeparator;
    protected Table fTableControl;
    private Composite fButtonsControl;
    private ISelection fSelectionWhenEnabled;
    private IListAdapter fListAdapter;
    private Object fParentElement;

    public ListDialogField(IListAdapter adapter, String[] buttonLabels, ILabelProvider lprovider) {
        this.fListAdapter = adapter;
        this.fLabelProvider = lprovider;
        this.fListViewerAdapter = new ListViewerAdapter();
        this.fParentElement = this;
        this.fElements = new ArrayList(10);
        this.fButtonLabels = buttonLabels;
        if (this.fButtonLabels != null) {
            int nButtons = this.fButtonLabels.length;
            this.fButtonsEnabled = new boolean[nButtons];
            int i = 0;
            while (i < nButtons) {
                this.fButtonsEnabled[i] = true;
                ++i;
            }
        }
        this.fTable = null;
        this.fTableControl = null;
        this.fButtonsControl = null;
        this.fRemoveButtonIndex = -1;
        this.fUpButtonIndex = -1;
        this.fDownButtonIndex = -1;
    }

    public void setRemoveButtonIndex(int removeButtonIndex) {
        Assert.isTrue((removeButtonIndex < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fRemoveButtonIndex = removeButtonIndex;
    }

    public void setUpButtonIndex(int upButtonIndex) {
        Assert.isTrue((upButtonIndex < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fUpButtonIndex = upButtonIndex;
    }

    public void setDownButtonIndex(int downButtonIndex) {
        Assert.isTrue((downButtonIndex < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fDownButtonIndex = downButtonIndex;
    }

    public void setViewerSorter(ViewerSorter viewerSorter) {
        this.fViewerSorter = viewerSorter;
    }

    private void buttonPressed(int index) {
        if (!this.managedButtonPressed(index)) {
            this.fListAdapter.customButtonPressed(this, index);
        }
    }

    protected boolean managedButtonPressed(int index) {
        if (index == this.fRemoveButtonIndex) {
            this.remove();
        } else if (index == this.fUpButtonIndex) {
            this.up();
        } else if (index == this.fDownButtonIndex) {
            this.down();
        } else {
            return false;
        }
        return true;
    }

    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        PixelConverter converter = new PixelConverter((Control)parent);
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        GridData gd = ListDialogField.gridDataForLabel(1);
        gd.verticalAlignment = 1;
        label.setLayoutData((Object)gd);
        Control list = this.getListControl(parent);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = nColumns - 2;
        gd.widthHint = converter.convertWidthInCharsToPixels(50);
        gd.heightHint = converter.convertHeightInCharsToPixels(6);
        list.setLayoutData((Object)gd);
        Composite buttons = this.getButtonBox(parent);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 1;
        buttons.setLayoutData((Object)gd);
        return new Control[]{label, list, buttons};
    }

    public int getNumberOfControls() {
        return 3;
    }

    public void setButtonsMinWidth(int minWidth) {
        if (this.fLastSeparator != null) {
            ((GridData)this.fLastSeparator.getLayoutData()).widthHint = minWidth;
        }
    }

    public Control getListControl(Composite parent) {
        if (this.fTableControl == null) {
            this.assertCompositeNotNull(parent);
            this.fTable = this.createTableViewer(parent);
            this.fTable.setContentProvider((IContentProvider)this.fListViewerAdapter);
            this.fTable.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
            this.fTable.addSelectionChangedListener((ISelectionChangedListener)this.fListViewerAdapter);
            this.fTableControl = (Table)this.fTable.getControl();
            this.fTable.setInput(this.fParentElement);
            if (this.fViewerSorter != null) {
                this.fTable.setSorter(this.fViewerSorter);
            }
            this.fTableControl.setEnabled(this.isEnabled());
            if (this.fSelectionWhenEnabled != null) {
                this.postSetSelection(this.fSelectionWhenEnabled);
            }
        }
        return this.fTableControl;
    }

    public TableViewer getTableViewer() {
        return this.fTable;
    }

    protected int getListStyle() {
        return 2818;
    }

    protected TableViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, this.getListStyle());
        return new TableViewer(table);
    }

    protected Button createButton(Composite parent, String label, SelectionListener listener) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.addSelectionListener(listener);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 1;
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
        return button;
    }

    private Label createSeparator(Composite parent) {
        Label separator = new Label(parent, 0);
        separator.setVisible(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        return separator;
    }

    public Composite getButtonBox(Composite parent) {
        if (this.fButtonsControl == null) {
            this.assertCompositeNotNull(parent);
            SelectionListener listener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ListDialogField.this.doButtonSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    ListDialogField.this.doButtonSelected(e);
                }
            };
            Composite contents = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            contents.setLayout((Layout)layout);
            if (this.fButtonLabels != null) {
                this.fButtonControls = new Button[this.fButtonLabels.length];
                int i = 0;
                while (i < this.fButtonLabels.length) {
                    String currLabel = this.fButtonLabels[i];
                    if (currLabel != null) {
                        this.fButtonControls[i] = this.createButton(contents, currLabel, listener);
                        this.fButtonControls[i].setEnabled(this.isEnabled() && this.fButtonsEnabled[i]);
                    } else {
                        this.fButtonControls[i] = null;
                        this.createSeparator(contents);
                    }
                    ++i;
                }
            }
            this.fLastSeparator = this.createSeparator(contents);
            this.updateButtonState();
            this.fButtonsControl = contents;
        }
        return this.fButtonsControl;
    }

    protected void doButtonSelected(SelectionEvent e) {
        if (this.fButtonControls != null) {
            int i = 0;
            while (i < this.fButtonControls.length) {
                if (e.widget == this.fButtonControls[i]) {
                    this.buttonPressed(i);
                    return;
                }
                ++i;
            }
        }
    }

    public void dialogFieldChanged() {
        super.dialogFieldChanged();
        this.updateButtonState();
    }

    protected void updateButtonState() {
        if (this.fButtonControls != null) {
            ISelection sel = this.fTable.getSelection();
            int i = 0;
            while (i < this.fButtonControls.length) {
                Button button = this.fButtonControls[i];
                if (this.isOkToUse((Control)button)) {
                    boolean extraState = this.getManagedButtonState(sel, i);
                    button.setEnabled(this.isEnabled() && extraState && this.fButtonsEnabled[i]);
                }
                ++i;
            }
        }
    }

    protected boolean getManagedButtonState(ISelection sel, int index) {
        if (index == this.fRemoveButtonIndex) {
            return !sel.isEmpty();
        }
        if (index == this.fUpButtonIndex) {
            return !sel.isEmpty() && this.canMoveUp();
        }
        if (index == this.fDownButtonIndex) {
            return !sel.isEmpty() && this.canMoveDown();
        }
        return true;
    }

    protected void updateEnableState() {
        super.updateEnableState();
        boolean enabled = this.isEnabled();
        if (this.isOkToUse((Control)this.fTableControl)) {
            if (!enabled) {
                this.fSelectionWhenEnabled = this.fTable.getSelection();
                this.selectElements(null);
            } else {
                this.selectElements(this.fSelectionWhenEnabled);
                this.fSelectionWhenEnabled = null;
            }
            this.fTableControl.setEnabled(enabled);
        }
        this.updateButtonState();
    }

    public void enableButton(int index, boolean enable) {
        if (this.fButtonsEnabled != null && index < this.fButtonsEnabled.length) {
            this.fButtonsEnabled[index] = enable;
            this.updateButtonState();
        }
    }

    public void setElements(List elements) {
        this.fElements = new ArrayList(elements);
        if (this.fTable != null) {
            this.fTable.refresh();
        }
        this.dialogFieldChanged();
    }

    public List getElements() {
        return new ArrayList(this.fElements);
    }

    public Object getElement(int index) {
        return this.fElements.get(index);
    }

    public void replaceElement(Object oldElement, Object newElement) throws IllegalArgumentException {
        int idx = this.fElements.indexOf(oldElement);
        if (idx != -1) {
            if (oldElement.equals(newElement) || this.fElements.contains(newElement)) {
                return;
            }
            this.fElements.set(idx, newElement);
            if (this.fTable != null) {
                List selected = this.getSelectedElements();
                if (selected.remove(oldElement)) {
                    selected.add(newElement);
                }
                this.fTable.refresh();
                this.selectElements((ISelection)new StructuredSelection(selected));
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.dialogFieldChanged();
    }

    public void addElement(Object element) {
        if (this.fElements.contains(element)) {
            return;
        }
        this.fElements.add(element);
        if (this.fTable != null) {
            this.fTable.add(element);
        }
        this.dialogFieldChanged();
    }

    public void addElements(List elements) {
        int nElements = elements.size();
        if (nElements > 0) {
            ArrayList elementsToAdd = new ArrayList(nElements);
            int i = 0;
            while (i < nElements) {
                Object elem = elements.get(i);
                if (!this.fElements.contains(elem)) {
                    elementsToAdd.add(elem);
                }
                ++i;
            }
            this.fElements.addAll(elementsToAdd);
            if (this.fTable != null) {
                this.fTable.add(elementsToAdd.toArray());
            }
            this.dialogFieldChanged();
        }
    }

    public void insertElementAt(Object element, int index) {
        if (this.fElements.contains(element)) {
            return;
        }
        this.fElements.add(index, element);
        if (this.fTable != null) {
            this.fTable.add(element);
        }
        this.dialogFieldChanged();
    }

    public void removeAllElements() {
        if (this.fElements.size() > 0) {
            this.fElements.clear();
            if (this.fTable != null) {
                this.fTable.refresh();
            }
            this.dialogFieldChanged();
        }
    }

    public void removeElement(Object element) throws IllegalArgumentException {
        if (this.fElements.remove(element)) {
            if (this.fTable != null) {
                this.fTable.remove(element);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.dialogFieldChanged();
    }

    public void removeElements(List elements) {
        if (elements.size() > 0) {
            this.fElements.removeAll(elements);
            if (this.fTable != null) {
                this.fTable.remove(elements.toArray());
            }
            this.dialogFieldChanged();
        }
    }

    public int getSize() {
        return this.fElements.size();
    }

    public void selectElements(ISelection selection) {
        this.fSelectionWhenEnabled = selection;
        if (this.fTable != null) {
            this.fTable.setSelection(selection, true);
        }
    }

    public void selectFirstElement() {
        Object element = null;
        if (this.fViewerSorter != null) {
            Object[] arr = this.fElements.toArray();
            this.fViewerSorter.sort((Viewer)this.fTable, arr);
            if (arr.length > 0) {
                element = arr[0];
            }
        } else if (this.fElements.size() > 0) {
            element = this.fElements.get(0);
        }
        if (element != null) {
            this.selectElements((ISelection)new StructuredSelection(element));
        }
    }

    public void postSetSelection(final ISelection selection) {
        if (this.isOkToUse((Control)this.fTableControl)) {
            Display d = this.fTableControl.getDisplay();
            d.asyncExec(new Runnable(){

                public void run() {
                    if (ListDialogField.this.isOkToUse((Control)ListDialogField.this.fTableControl)) {
                        ListDialogField.this.selectElements(selection);
                    }
                }
            });
        }
    }

    public void refresh() {
        this.fTable.refresh();
    }

    private List moveUp(List elements, List move) {
        int nElements = elements.size();
        ArrayList res = new ArrayList(nElements);
        Object floating = null;
        int i = 0;
        while (i < nElements) {
            Object curr = elements.get(i);
            if (move.contains(curr)) {
                res.add(curr);
            } else {
                if (floating != null) {
                    res.add(floating);
                }
                floating = curr;
            }
            ++i;
        }
        if (floating != null) {
            res.add(floating);
        }
        return res;
    }

    private void moveUp(List toMoveUp) {
        if (toMoveUp.size() > 0) {
            this.setElements(this.moveUp(this.fElements, toMoveUp));
            this.fTable.reveal(toMoveUp.get(0));
        }
    }

    private void moveDown(List toMoveDown) {
        if (toMoveDown.size() > 0) {
            this.setElements(this.reverse(this.moveUp(this.reverse(this.fElements), toMoveDown)));
            this.fTable.reveal(toMoveDown.get(toMoveDown.size() - 1));
        }
    }

    private List reverse(List p) {
        ArrayList reverse = new ArrayList(p.size());
        int i = p.size() - 1;
        while (i >= 0) {
            reverse.add(p.get(i));
            --i;
        }
        return reverse;
    }

    private void remove() {
        this.removeElements(this.getSelectedElements());
    }

    private void up() {
        this.moveUp(this.getSelectedElements());
    }

    private void down() {
        this.moveDown(this.getSelectedElements());
    }

    private boolean canMoveUp() {
        if (this.isOkToUse((Control)this.fTableControl)) {
            int[] indc = this.fTableControl.getSelectionIndices();
            int i = 0;
            while (i < indc.length) {
                if (indc[i] != i) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean canMoveDown() {
        if (this.isOkToUse((Control)this.fTableControl)) {
            int[] indc = this.fTableControl.getSelectionIndices();
            int k = this.fElements.size() - 1;
            int i = indc.length - 1;
            while (i >= 0) {
                if (indc[i] != k) {
                    return true;
                }
                --i;
                --k;
            }
        }
        return false;
    }

    public List getSelectedElements() {
        ISelection selection;
        ArrayList result = new ArrayList();
        if (this.fTable != null && (selection = this.fTable.getSelection()) instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                result.add(iter.next());
            }
        }
        return result;
    }

    protected void doListSelected(SelectionChangedEvent event) {
        this.updateButtonState();
        if (this.fListAdapter != null) {
            this.fListAdapter.selectionChanged(this);
        }
    }

    private class ListViewerAdapter
    implements IStructuredContentProvider,
    ISelectionChangedListener {
        private ListViewerAdapter() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public boolean isDeleted(Object element) {
            return false;
        }

        public void dispose() {
        }

        public Object[] getElements(Object obj) {
            return ListDialogField.this.fElements.toArray();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ListDialogField.this.doListSelected(event);
        }
    }
}

