/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class CoreModelUtil {
    public static boolean isExcludedPath(IPath resourcePath, IPath[] exclusionPatterns) {
        int length = exclusionPatterns.length;
        char[][] fullCharExclusionPatterns = new char[length][];
        int i = 0;
        while (i < length) {
            fullCharExclusionPatterns[i] = exclusionPatterns[i].toString().toCharArray();
            ++i;
        }
        return CoreModelUtil.isExcluded(resourcePath, (char[][])fullCharExclusionPatterns);
    }

    public static final boolean isExcluded(IResource resource, char[][] exclusionPatterns) {
        IPath path = resource.getFullPath();
        if (resource.getType() == 2) {
            path = path.append("*");
        }
        return CoreModelUtil.isExcluded(path, exclusionPatterns);
    }

    public static final boolean isExcluded(IPath resourcePath, char[][] exclusionPatterns) {
        if (exclusionPatterns == null) {
            return false;
        }
        char[] path = resourcePath.toString().toCharArray();
        int i = 0;
        int length = exclusionPatterns.length;
        while (i < length) {
            if (CoreModelUtil.prefixOfCharArray(exclusionPatterns[i], path)) {
                return true;
            }
            if (CoreModelUtil.pathMatch(exclusionPatterns[i], path, true, '/')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static boolean prefixOfCharArray(char[] a, char[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int len = a.length;
        if (len > b.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return i >= b.length || b[i] == '/';
    }

    public static final boolean match(char[] pattern, char[] name, boolean isCaseSensitive) {
        if (name == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        return CoreModelUtil.match(pattern, 0, pattern.length, name, 0, name.length, isCaseSensitive);
    }

    public static final boolean match(char[] pattern, int patternStart, int patternEnd, char[] name, int nameStart, int nameEnd, boolean isCaseSensitive) {
        if (name == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        int iPattern = patternStart;
        int iName = nameStart;
        if (patternEnd < 0) {
            patternEnd = pattern.length;
        }
        if (nameEnd < 0) {
            nameEnd = name.length;
        }
        char patternChar = '\u0000';
        while (iPattern < patternEnd && (patternChar = pattern[iPattern]) != '*') {
            if (iName == nameEnd) {
                return false;
            }
            if (patternChar != (isCaseSensitive ? name[iName] : Character.toLowerCase(name[iName])) && patternChar != '?') {
                return false;
            }
            ++iName;
            ++iPattern;
        }
        int segmentStart = patternChar == '*' ? ++iPattern : 0;
        int prefixStart = iName;
        while (iName < nameEnd) {
            if (iPattern == patternEnd) {
                iPattern = segmentStart;
                iName = ++prefixStart;
                continue;
            }
            patternChar = pattern[iPattern];
            if (patternChar == '*') {
                if ((segmentStart = ++iPattern) == patternEnd) {
                    return true;
                }
                prefixStart = iName;
                continue;
            }
            if ((isCaseSensitive ? name[iName] : Character.toLowerCase(name[iName])) != patternChar && patternChar != '?') {
                iPattern = segmentStart;
                iName = ++prefixStart;
                continue;
            }
            ++iName;
            ++iPattern;
        }
        return segmentStart == patternEnd || iName == nameEnd && iPattern == patternEnd || iPattern == patternEnd - 1 && pattern[iPattern] == '*';
    }

    public static final boolean pathMatch(char[] pattern, char[] filepath, boolean isCaseSensitive, char pathSeparator) {
        int pSegmentRestart;
        if (filepath == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        int pSegmentStart = pattern[0] == pathSeparator ? 1 : 0;
        int pLength = pattern.length;
        int pSegmentEnd = CoreModelUtil.indexOf(pathSeparator, pattern, pSegmentStart + 1);
        if (pSegmentEnd < 0) {
            pSegmentEnd = pLength;
        }
        boolean freeTrailingDoubleStar = pattern[pLength - 1] == pathSeparator;
        int fLength = filepath.length;
        int fSegmentStart = filepath[0] != pathSeparator ? 0 : 1;
        if (fSegmentStart != pSegmentStart) {
            return false;
        }
        int fSegmentEnd = CoreModelUtil.indexOf(pathSeparator, filepath, fSegmentStart + 1);
        if (fSegmentEnd < 0) {
            fSegmentEnd = fLength;
        }
        while (!(pSegmentStart >= pLength || pSegmentEnd == pLength && freeTrailingDoubleStar || pSegmentEnd == pSegmentStart + 2 && pattern[pSegmentStart] == '*' && pattern[pSegmentStart + 1] == '*')) {
            if (fSegmentStart >= fLength) {
                return false;
            }
            if (!CoreModelUtil.match(pattern, pSegmentStart, pSegmentEnd, filepath, fSegmentStart, fSegmentEnd, isCaseSensitive)) {
                return false;
            }
            pSegmentStart = pSegmentEnd + 1;
            if ((pSegmentEnd = CoreModelUtil.indexOf(pathSeparator, pattern, pSegmentStart)) < 0) {
                pSegmentEnd = pLength;
            }
            if ((fSegmentEnd = CoreModelUtil.indexOf(pathSeparator, filepath, fSegmentStart = fSegmentEnd + 1)) >= 0) continue;
            fSegmentEnd = fLength;
        }
        if (pSegmentStart >= pLength && freeTrailingDoubleStar || pSegmentEnd == pSegmentStart + 2 && pattern[pSegmentStart] == '*' && pattern[pSegmentStart + 1] == '*') {
            pSegmentStart = pSegmentEnd + 1;
            if ((pSegmentEnd = CoreModelUtil.indexOf(pathSeparator, pattern, pSegmentStart)) < 0) {
                pSegmentEnd = pLength;
            }
            pSegmentRestart = pSegmentStart;
        } else {
            if (pSegmentStart >= pLength) {
                return fSegmentStart >= fLength;
            }
            pSegmentRestart = 0;
        }
        int fSegmentRestart = fSegmentStart;
        while (fSegmentStart < fLength) {
            if (pSegmentStart >= pLength) {
                if (freeTrailingDoubleStar) {
                    return true;
                }
                pSegmentStart = pSegmentRestart;
                pSegmentEnd = CoreModelUtil.indexOf(pathSeparator, pattern, pSegmentStart);
                if (pSegmentEnd < 0) {
                    pSegmentEnd = pLength;
                }
                if ((fSegmentRestart = CoreModelUtil.indexOf(pathSeparator, filepath, fSegmentRestart + 1)) < 0) {
                    fSegmentRestart = fLength;
                }
                fSegmentStart = ++fSegmentRestart;
                fSegmentEnd = CoreModelUtil.indexOf(pathSeparator, filepath, fSegmentStart);
                if (fSegmentEnd >= 0) continue;
                fSegmentEnd = fLength;
                continue;
            }
            if (pSegmentEnd == pSegmentStart + 2 && pattern[pSegmentStart] == '*' && pattern[pSegmentStart + 1] == '*') {
                pSegmentStart = pSegmentEnd + 1;
                if ((pSegmentEnd = CoreModelUtil.indexOf(pathSeparator, pattern, pSegmentStart)) < 0) {
                    pSegmentEnd = pLength;
                }
                pSegmentRestart = pSegmentStart;
                fSegmentRestart = fSegmentStart;
                if (pSegmentStart < pLength) continue;
                return true;
            }
            if (!CoreModelUtil.match(pattern, pSegmentStart, pSegmentEnd, filepath, fSegmentStart, fSegmentEnd, isCaseSensitive)) {
                pSegmentStart = pSegmentRestart;
                pSegmentEnd = CoreModelUtil.indexOf(pathSeparator, pattern, pSegmentStart);
                if (pSegmentEnd < 0) {
                    pSegmentEnd = pLength;
                }
                if ((fSegmentRestart = CoreModelUtil.indexOf(pathSeparator, filepath, fSegmentRestart + 1)) < 0) {
                    fSegmentRestart = fLength;
                }
                fSegmentStart = ++fSegmentRestart;
                fSegmentEnd = CoreModelUtil.indexOf(pathSeparator, filepath, fSegmentStart);
                if (fSegmentEnd >= 0) continue;
                fSegmentEnd = fLength;
                continue;
            }
            pSegmentStart = pSegmentEnd + 1;
            if ((pSegmentEnd = CoreModelUtil.indexOf(pathSeparator, pattern, pSegmentStart)) < 0) {
                pSegmentEnd = pLength;
            }
            if ((fSegmentEnd = CoreModelUtil.indexOf(pathSeparator, filepath, fSegmentStart = fSegmentEnd + 1)) >= 0) continue;
            fSegmentEnd = fLength;
        }
        return pSegmentRestart >= pSegmentEnd || fSegmentStart >= fLength && pSegmentStart >= pLength || pSegmentStart == pLength - 2 && pattern[pSegmentStart] == '*' && pattern[pSegmentStart + 1] == '*' || pSegmentStart == pLength && freeTrailingDoubleStar;
    }

    public static final int indexOf(char toBeFound, char[] array) {
        int i = 0;
        while (i < array.length) {
            if (toBeFound == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(char toBeFound, char[] array, int start) {
        int i = start;
        while (i < array.length) {
            if (toBeFound == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

