/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.IPDOM;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMResolver;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.IPDOMWriter;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.core.pdom.PDOMCodeReaderFactory;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMLinkageFactory;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;

public class PDOM
extends PlatformObject
implements IPDOM,
IPDOMResolver,
IPDOMWriter {
    private Database db;
    public static final int VERSION = 11;
    public static final int LINKAGES = 4100;
    public static final int FILE_INDEX = 4104;
    private BTree fileIndex;
    private Map _linkageCache;
    private List listeners;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public PDOM(IPath dbPath) throws CoreException {
        this.db = new Database(dbPath.toOSString());
    }

    private Map getLinkageCache() throws CoreException {
        if (this._linkageCache == null) {
            this._linkageCache = new HashMap();
            if (!this.versionMismatch()) {
                PDOMLinkage linkage = this.getFirstLinkage();
                while (linkage != null) {
                    this._linkageCache.put(linkage.getLanguage().getId(), linkage);
                    linkage = linkage.getNextLinkage();
                }
            }
        }
        return this._linkageCache;
    }

    public boolean versionMismatch() throws CoreException {
        return this.db.getVersion() != 11;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.IPDOM");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.core.dom.IPDOMResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            return this;
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.cdt.core.dom.IPDOMWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz3) {
            return this;
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.cdt.internal.core.pdom.PDOM");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz4) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
        PDOMLinkage linkage = this.getFirstLinkage();
        while (linkage != null) {
            linkage.accept(visitor);
            linkage = linkage.getNextLinkage();
        }
    }

    public void addListener(IListener listener) {
        if (this.listeners == null) {
            this.listeners = new LinkedList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(IListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    private void fireChange() {
        if (this.listeners == null) {
            return;
        }
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((IListener)i.next()).handleChange(this);
        }
    }

    public Database getDB() throws CoreException {
        return this.db;
    }

    public BTree getFileIndex() throws CoreException {
        if (this.fileIndex == null) {
            this.fileIndex = new BTree(this.getDB(), 4104);
        }
        return this.fileIndex;
    }

    public PDOMFile getFile(String filename) throws CoreException {
        PDOMFile.Finder finder = new PDOMFile.Finder(this.db, filename);
        this.getFileIndex().accept(finder);
        int record = finder.getRecord();
        return record != 0 ? new PDOMFile(this, record) : null;
    }

    public PDOMFile getFile(IPath path) throws CoreException {
        return this.getFile(path.toOSString());
    }

    public PDOMFile addFile(String filename) throws CoreException {
        PDOMFile file = this.getFile(filename);
        if (file == null) {
            file = new PDOMFile(this, filename);
            this.getFileIndex().insert(file.getRecord(), new PDOMFile.Comparator(this.db));
        }
        return file;
    }

    public void clear() throws CoreException {
        this.db.clear(11);
        this.db.putInt(4104, 0);
        this.fileIndex = null;
        this.db.putInt(4100, 0);
        this.getLinkageCache().clear();
    }

    public boolean isEmpty() throws CoreException {
        return this.getFirstLinkage() == null;
    }

    public ICodeReaderFactory getCodeReaderFactory() {
        return new PDOMCodeReaderFactory(this);
    }

    public ICodeReaderFactory getCodeReaderFactory(IWorkingCopy root) {
        return new PDOMCodeReaderFactory(this, root);
    }

    public IASTName[] getDeclarations(IBinding binding) throws CoreException {
        if (binding instanceof PDOMBinding) {
            ArrayList<PDOMName> names = new ArrayList<PDOMName>();
            PDOMName name = ((PDOMBinding)binding).getFirstDeclaration();
            while (name != null) {
                names.add(name);
                name = name.getNextInBinding();
            }
            name = ((PDOMBinding)binding).getFirstDefinition();
            while (name != null) {
                names.add(name);
                name = name.getNextInBinding();
            }
            return names.toArray(new IASTName[names.size()]);
        }
        return new IASTName[0];
    }

    public IASTName[] getDefinitions(IBinding binding) throws CoreException {
        if (binding instanceof PDOMBinding) {
            ArrayList<PDOMName> names = new ArrayList<PDOMName>();
            PDOMName name = ((PDOMBinding)binding).getFirstDefinition();
            while (name != null) {
                names.add(name);
                name = name.getNextInBinding();
            }
            return names.toArray(new IASTName[names.size()]);
        }
        return new IASTName[0];
    }

    public IASTName[] getReferences(IBinding binding) throws CoreException {
        if (binding instanceof PDOMBinding) {
            ArrayList<PDOMName> names = new ArrayList<PDOMName>();
            PDOMName name = ((PDOMBinding)binding).getFirstReference();
            while (name != null) {
                names.add(name);
                name = name.getNextInBinding();
            }
            return names.toArray(new IASTName[names.size()]);
        }
        return new IASTName[0];
    }

    public IBinding resolveBinding(IASTName name) {
        try {
            ILanguage language = name.getTranslationUnit().getLanguage();
            return this.getLinkage(language).resolveBinding(name);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public IBinding[] findBindings(Pattern pattern, IProgressMonitor monitor) throws CoreException {
        return this.findBindings(new Pattern[]{pattern}, monitor);
    }

    public IBinding[] findBindings(Pattern[] pattern, IProgressMonitor monitor) throws CoreException {
        BindingFinder finder = new BindingFinder(pattern, monitor);
        PDOMLinkage linkage = this.getFirstLinkage();
        while (linkage != null) {
            try {
                linkage.accept(finder);
            }
            catch (CoreException e) {
                if (e.getStatus() != Status.OK_STATUS) {
                    throw e;
                }
                return new IBinding[0];
            }
            linkage = linkage.getNextLinkage();
        }
        return finder.getBindings();
    }

    public PDOMLinkage getLinkage(ILanguage language) throws CoreException {
        PDOMLinkage linkage = (PDOMLinkage)this.getLinkageCache().get(language.getId());
        if (linkage != null) {
            return linkage;
        }
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.cdt.internal.core.pdom.dom.IPDOMLinkageFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IPDOMLinkageFactory factory = (IPDOMLinkageFactory)language.getAdapter(clazz);
        String id = language.getId();
        int linkrec = this.db.getInt(4100);
        while (linkrec != 0) {
            if (PDOMLinkage.getId(this, linkrec).equals(id)) {
                return factory.getLinkage(this, linkrec);
            }
            linkrec = PDOMLinkage.getNextLinkageRecord(this, linkrec);
        }
        return factory.createLinkage(this);
    }

    public PDOMLinkage getLinkage(int record) throws CoreException {
        if (record == 0) {
            return null;
        }
        Iterator i = this.getLinkageCache().values().iterator();
        while (i.hasNext()) {
            PDOMLinkage linkage = (PDOMLinkage)i.next();
            if (linkage.getRecord() != record) continue;
            return linkage;
        }
        String id = PDOMLinkage.getId(this, record).getString();
        ILanguage language = LanguageManager.getInstance().getLanguage(id);
        return this.getLinkage(language);
    }

    public PDOMLinkage getFirstLinkage() throws CoreException {
        return this.getLinkage(this.db.getInt(4100));
    }

    public PDOMLinkage[] getLinkages() throws CoreException {
        Collection values = this.getLinkageCache().values();
        return values.toArray(new PDOMLinkage[values.size()]);
    }

    public void insertLinkage(PDOMLinkage linkage) throws CoreException {
        linkage.setNext(this.db.getInt(4100));
        this.db.putInt(4100, linkage.getRecord());
        this.getLinkageCache().put(linkage.getLanguage().getId(), linkage);
    }

    public PDOMBinding getBinding(int record) throws CoreException {
        if (record == 0) {
            return null;
        }
        PDOMNode node = PDOMLinkage.getLinkage(this, record).getNode(record);
        return node instanceof PDOMBinding ? (PDOMBinding)node : null;
    }

    public void acquireReadLock() throws InterruptedException {
        this.db.acquireLock();
    }

    public void releaseReadLock() {
        this.db.releaseLock();
    }

    public void acquireWriteLock() throws InterruptedException {
        this.db.acquireLock();
    }

    public void releaseWriteLock() {
        Database.saveAll();
        this.db.releaseLock();
        this.fireChange();
    }

    private static class BindingFinder
    implements IPDOMVisitor {
        private final Pattern[] pattern;
        private final IProgressMonitor monitor;
        private final IBinding[] match;
        private int level = 0;
        private List bindings = new ArrayList();

        public BindingFinder(Pattern[] pattern, IProgressMonitor monitor) {
            this.pattern = pattern;
            this.monitor = monitor;
            this.match = new IBinding[pattern.length];
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            IBinding binding;
            if (this.monitor.isCanceled()) {
                throw new CoreException(Status.OK_STATUS);
            }
            if (node instanceof IBinding && this.pattern[this.level].matcher((binding = (IBinding)((Object)node)).getName()).matches()) {
                if (this.level < this.pattern.length - 1) {
                    this.match[this.level++] = binding;
                } else {
                    this.bindings.add(binding);
                    return this.pattern.length == 1;
                }
            }
            return true;
        }

        public void leave(IPDOMNode node) throws CoreException {
            if (node instanceof IBinding && this.level > 0 && this.match[this.level - 1] == (IBinding)((Object)node)) {
                --this.level;
            }
        }

        public IBinding[] getBindings() {
            return this.bindings.toArray(new IBinding[this.bindings.size()]);
        }
    }

    public static interface IListener {
        public void handleChange(PDOM var1);
    }
}

