/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISpecializedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TemplateEngine;
import org.eclipse.cdt.internal.core.parser.pst.TemplateSymbol;

public class SpecializedSymbol
extends TemplateSymbol
implements ISpecializedSymbol {
    private List _argumentList = Collections.EMPTY_LIST;
    private ITemplateSymbol _primaryTemplate;

    protected SpecializedSymbol(ParserSymbolTable table, char[] name) {
        super(table, name);
    }

    public Object clone() {
        SpecializedSymbol copy = (SpecializedSymbol)super.clone();
        copy._argumentList = this._argumentList != Collections.EMPTY_LIST ? (List)((ArrayList)this._argumentList).clone() : this._argumentList;
        return copy;
    }

    public ITemplateSymbol getPrimaryTemplate() {
        return this._primaryTemplate;
    }

    public void setPrimaryTemplate(ITemplateSymbol templateSymbol) {
        this._primaryTemplate = templateSymbol;
    }

    public ISymbol instantiate(List arguments) throws ParserSymbolTableException {
        List specArgs = this.getArgumentList();
        if (specArgs.size() != arguments.size()) {
            return null;
        }
        ArrayList<ITypeInfo> actualArgs = new ArrayList<ITypeInfo>(specArgs.size());
        ObjectMap argMap = new ObjectMap(specArgs.size());
        ISymbol templatedSymbol = this.getTemplatedSymbol();
        while (templatedSymbol.isTemplateInstance()) {
            templatedSymbol = templatedSymbol.getInstantiatedSymbol();
        }
        int numSpecArgs = specArgs.size();
        int i = 0;
        while (i < numSpecArgs) {
            ITypeInfo info = (ITypeInfo)specArgs.get(i);
            ITypeInfo mappedInfo = (ITypeInfo)arguments.get(i);
            if (mappedInfo.isType(ITypeInfo.t_type) && mappedInfo.getTypeSymbol().isType(ITypeInfo.t_templateParameter)) {
                return this.deferredInstance(arguments);
            }
            actualArgs.add(mappedInfo);
            if (info.isType(ITypeInfo.t_type) && info.getTypeSymbol().isType(ITypeInfo.t_templateParameter)) {
                ISymbol param = info.getTypeSymbol();
                if (!argMap.containsKey(param = TemplateEngine.translateParameterForDefinition(templatedSymbol, param, this.getDefinitionParameterMap()))) {
                    argMap.put(param, mappedInfo);
                }
            }
            ++i;
        }
        if (this.getParameterList().size() != argMap.size()) {
            return null;
        }
        List params = this.getParameterList();
        int numParams = params.size();
        int i2 = 0;
        while (i2 < numParams) {
            if (!argMap.containsKey(params.get(i2))) {
                return null;
            }
            ++i2;
        }
        IContainerSymbol instance = this.findInstantiation(actualArgs);
        if (instance != null) {
            return instance;
        }
        ISymbol symbol = null;
        if (this.getContainedSymbols().size() == 1) {
            symbol = (IContainerSymbol)this.getContainedSymbols().getAt(0);
        }
        instance = (IContainerSymbol)symbol.instantiate(this, argMap);
        this.addInstantiation(instance, actualArgs);
        try {
            this.processDeferredInstantiations();
        }
        catch (ParserSymbolTableException e) {
            if (e.reason == 11) {
                this.removeInstantiation(instance);
            }
            throw e;
        }
        return instance;
    }

    public List getArgumentList() {
        return this._argumentList;
    }

    public void prepareArguments(int size) {
        if (this._argumentList == Collections.EMPTY_LIST) {
            this._argumentList = new ArrayList(size);
        } else {
            ((ArrayList)this._argumentList).ensureCapacity(size);
        }
    }

    public void addArgument(ITypeInfo arg) {
        if (this._argumentList == Collections.EMPTY_LIST) {
            this._argumentList = new ArrayList(4);
        }
        this._argumentList.add(arg);
    }
}

