/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import java.io.File;
import java.util.Iterator;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;

public class ScannerUtility {
    static final char DOT = '.';
    static final char SLASH = '/';
    static final char BSLASH = '\\';
    static final char QUOTE = '\"';

    public static String reconcilePath(String originalPath) {
        int len = originalPath.length();
        int len1 = len - 1;
        int j = 0;
        boolean noSepBefore = true;
        char[] ein = new char[len];
        char[] aus = new char[len + 1];
        originalPath.getChars(0, len, ein, 0);
        int i = 0;
        while (i < len) {
            char c = ein[i];
            switch (c) {
                case '\"': {
                    noSepBefore = true;
                    break;
                }
                case '/': 
                case '\\': {
                    if (!noSepBefore) break;
                    noSepBefore = false;
                    aus[j++] = File.separatorChar;
                    break;
                }
                case '.': {
                    if (noSepBefore && j > 0) {
                        aus[j++] = c;
                        break;
                    }
                    if (i >= len1) break;
                    c = ein[i + 1];
                    if (c == '/' || c == '\\') {
                        ++i;
                        noSepBefore = false;
                        break;
                    }
                    if (c != '.') {
                        ++i;
                        noSepBefore = true;
                        aus[j++] = 46;
                        aus[j++] = c;
                        break;
                    }
                    if (i == len1 || ein[i + 2] == '/' || ein[i + 2] == '\\') {
                        i += 2;
                        noSepBefore = false;
                        if (j <= 1) break;
                        int k = j - 2;
                        while (k >= 0) {
                            if (aus[k] == File.separatorChar) break;
                            --k;
                        }
                        j = k + 1;
                        break;
                    }
                    ++i;
                    noSepBefore = true;
                    aus[j++] = 46;
                    aus[j++] = 46;
                    break;
                }
                default: {
                    noSepBefore = true;
                    aus[j++] = c;
                }
            }
            ++i;
        }
        return new String(aus, 0, j);
    }

    public static String createReconciledPath(String path, String fileName) {
        boolean pathEmpty = path == null || path.length() == 0;
        return pathEmpty ? fileName : ScannerUtility.reconcilePath(String.valueOf(path) + File.separatorChar + fileName);
    }

    public static CodeReader createReaderDuple(String path, ISourceElementRequestor requestor, Iterator workingCopies) {
        return requestor.createReader(path, workingCopies);
    }

    public static class InclusionDirective {
        private final boolean useIncludePaths;
        private final String fileName;
        private final int startOffset;
        private final int endOffset;

        public InclusionDirective(String fileName, boolean useIncludePaths, int startOffset, int endOffset) {
            this.fileName = fileName;
            this.useIncludePaths = useIncludePaths;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        boolean useIncludePaths() {
            return this.useIncludePaths;
        }

        public String getFilename() {
            return this.fileName;
        }

        int getStartOffset() {
            return this.startOffset;
        }

        int getEndOffset() {
            return this.endOffset;
        }
    }

    public static class InclusionParseException
    extends Exception {
    }
}

