/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.token;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.parser.token.TokenFactory;

public class BasicTokenDuple
implements ITokenDuple {
    private int numSegments = -1;
    protected final IToken firstToken;
    protected final IToken lastToken;
    private static final char[] EMPTY_STRING = "".toCharArray();
    private char[] stringRepresentation = null;

    BasicTokenDuple(IToken first, IToken last) {
        this.firstToken = first;
        this.lastToken = last;
    }

    BasicTokenDuple(ITokenDuple firstDuple, ITokenDuple secondDuple) {
        this(firstDuple.getFirstToken(), secondDuple.getLastToken());
    }

    public IToken getFirstToken() {
        return this.firstToken;
    }

    public IToken getLastToken() {
        return this.lastToken;
    }

    public Iterator iterator() {
        return new TokenIterator();
    }

    public ITokenDuple getLastSegment() {
        IToken first = null;
        IToken last = null;
        IToken token = null;
        while (token != this.getLastToken()) {
            IToken iToken = token = token != null ? token.getNext() : this.getFirstToken();
            if (first == null) {
                first = token;
            }
            if (token.getType() == 42) {
                token = TokenFactory.consumeTemplateIdArguments(token, this.getLastToken());
            } else if (token.getType() == 3) {
                first = null;
                continue;
            }
            last = token;
        }
        List[] args = this.getTemplateIdArgLists();
        if (args != null && args[args.length - 1] != null) {
            ArrayList<List> newArgs = new ArrayList<List>(1);
            newArgs.add(args[args.length - 1]);
            return TokenFactory.createTokenDuple(first, last, newArgs);
        }
        return TokenFactory.createTokenDuple(first, last);
    }

    public ITokenDuple[] getSegments() {
        ITokenDuple d;
        ArrayList<ITokenDuple> r = new ArrayList<ITokenDuple>();
        IToken token = null;
        IToken prev = null;
        IToken last = this.getLastToken();
        IToken startOfSegment = this.getFirstToken();
        while (token != last) {
            if (startOfSegment == last.getNext() && startOfSegment.getType() != 141) {
                startOfSegment = null;
                break;
            }
            prev = token;
            IToken iToken = token = token != null ? token.getNext() : this.getFirstToken();
            if (token.getType() == 42) {
                token = TokenFactory.consumeTemplateIdArguments(token, last);
            }
            if (token.getType() != 3) continue;
            d = TokenFactory.createTokenDuple(startOfSegment, prev == null ? startOfSegment : prev);
            r.add(d);
            startOfSegment = token.getNext();
        }
        if (startOfSegment != null) {
            d = TokenFactory.createTokenDuple(startOfSegment, last);
            r.add(d);
        }
        return r.toArray(new ITokenDuple[r.size()]);
    }

    public ITokenDuple getLeadingSegments() {
        if (this.getFirstToken() == null) {
            return null;
        }
        int num = this.getSegmentCount();
        if (num <= 1) {
            return null;
        }
        IToken first = null;
        IToken last = null;
        IToken previous = null;
        IToken token = null;
        while (token != this.getLastToken()) {
            IToken iToken = token = token != null ? token.getNext() : this.getFirstToken();
            if (first == null) {
                first = token;
            }
            if (token.getType() == 42) {
                token = TokenFactory.consumeTemplateIdArguments(token, this.getLastToken());
            } else if (token.getType() == 3) {
                last = previous;
                continue;
            }
            previous = token;
        }
        if (last == null) {
            return null;
        }
        if (this.getTemplateIdArgLists() != null) {
            List[] args = this.getTemplateIdArgLists();
            ArrayList<List> newArgs = new ArrayList<List>(args.length - 1);
            boolean foundArgs = false;
            int i = 0;
            while (i < args.length - 1) {
                newArgs.add(args[i]);
                if (args[i] != null) {
                    foundArgs = true;
                }
                ++i;
            }
            return TokenFactory.createTokenDuple(first, last, foundArgs ? newArgs : null);
        }
        return TokenFactory.createTokenDuple(first, last);
    }

    public int getSegmentCount() {
        if (this.numSegments == -1) {
            this.numSegments = this.calculateSegmentCount();
        }
        return this.numSegments;
    }

    public static int getCharArrayLength(IToken f, IToken l) {
        if (f == l) {
            return f.getCharImage().length;
        }
        IToken prev = null;
        IToken iter = f;
        int length = 0;
        while (true) {
            if (iter == null) {
                return 0;
            }
            if (prev != null && prev.getType() != 3 && prev.getType() != 1 && prev.getType() != 42 && prev.getType() != 34 && iter.getType() != 46 && prev.getType() != 10 && iter.getType() != 11 && iter.getType() != 3) {
                ++length;
            }
            length += iter.getCharImage().length;
            if (iter == l) break;
            prev = iter;
            iter = iter.getNext();
        }
        return length;
    }

    public static char[] createCharArrayRepresentation(IToken f, IToken l) {
        if (f == l) {
            return f.getCharImage();
        }
        IToken prev = null;
        IToken iter = f;
        int length = BasicTokenDuple.getCharArrayLength(f, l);
        char[] buff = new char[length];
        int i = 0;
        while (i < length) {
            if (prev != null && prev.getType() != 3 && prev.getType() != 1 && prev.getType() != 42 && prev.getType() != 34 && iter.getType() != 46 && prev.getType() != 10 && iter.getType() != 11 && iter.getType() != 3) {
                buff[i++] = 32;
            }
            if (iter == null) {
                return EMPTY_STRING;
            }
            CharArrayUtils.overWrite(buff, i, iter.getCharImage());
            i += iter.getCharImage().length;
            if (iter == l) break;
            prev = iter;
            iter = iter.getNext();
        }
        return buff;
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = BasicTokenDuple.createCharArrayRepresentation(this.firstToken, this.lastToken);
        }
        return String.valueOf(this.stringRepresentation);
    }

    public boolean isIdentifier() {
        return this.firstToken == this.lastToken && this.firstToken.getType() == 1;
    }

    public int length() {
        int count = 1;
        IToken i = this.firstToken;
        while (i != this.lastToken) {
            ++count;
            i = i.getNext();
        }
        return count;
    }

    public ITokenDuple getSubrange(int startIndex, int endIndex) {
        return TokenFactory.createTokenDuple(this.getToken(startIndex), this.getToken(endIndex));
    }

    public IToken getToken(int index) {
        if (index < 0) {
            return null;
        }
        IToken iter = this.firstToken;
        int count = 0;
        while (iter != this.lastToken) {
            iter = iter.getNext();
            if (count == index) {
                return iter;
            }
            ++count;
        }
        return null;
    }

    public int findLastTokenType(int type) {
        int count = 0;
        int lastFound = -1;
        IToken i = this.firstToken;
        while (i != this.lastToken) {
            if (i.getType() == type) {
                lastFound = count;
            }
            ++count;
            i = i.getNext();
        }
        return lastFound;
    }

    public int getEndOffset() {
        return this.getLastToken().getEndOffset();
    }

    public int getLineNumber() {
        return this.getFirstToken().getLineNumber();
    }

    public int getStartOffset() {
        return this.getFirstToken().getOffset();
    }

    public List[] getTemplateIdArgLists() {
        return null;
    }

    public boolean syntaxOfName() {
        IToken iter = this.firstToken;
        while (iter != this.lastToken) {
            if (iter.getType() == 42) {
                if ((iter = TokenFactory.consumeTemplateIdArguments(iter, this.lastToken)).getType() != 46) continue;
                if (iter == this.lastToken) break;
                iter = iter.getNext();
                continue;
            }
            if (iter.isOperator()) {
                iter = iter.getNext();
                continue;
            }
            switch (iter.getType()) {
                case 1: 
                case 3: 
                case 34: 
                case 95: {
                    iter = iter.getNext();
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ITokenDuple)) {
            return false;
        }
        return ((ITokenDuple)other).getFirstToken().equals(this.getFirstToken()) && ((ITokenDuple)other).getLastToken().equals(this.getLastToken());
    }

    public char[] extractNameFromTemplateId() {
        ITokenDuple nameDuple = this.getLastSegment();
        List[] argLists = this.getTemplateIdArgLists();
        if (argLists == null || argLists[argLists.length - 1] == null) {
            return nameDuple.toCharArray();
        }
        IToken i = nameDuple.getFirstToken();
        IToken last = nameDuple.getLastToken();
        if (i == null) {
            return EMPTY_STRING;
        }
        if (i.getType() == 111) {
            i = i.getNext();
        }
        char[] tempArray = i.getCharImage();
        if (i == last) {
            return tempArray;
        }
        char[] nameBuffer = new char[BasicTokenDuple.getCharArrayLength(i, this.lastToken)];
        CharArrayUtils.overWrite(nameBuffer, 0, tempArray);
        int idx = tempArray.length;
        if (i.getType() == 34) {
            i = i.getNext();
            tempArray = i.getCharImage();
            CharArrayUtils.overWrite(nameBuffer, idx, tempArray);
            idx += tempArray.length;
        } else if (i.getType() == 95) {
            i = i.getNext();
            nameBuffer[idx++] = 32;
            IToken first = i;
            IToken temp = null;
            while (i != last) {
                temp = i.getNext();
                if (temp.getType() == 42) break;
                i = temp;
            }
            CharArrayUtils.overWrite(nameBuffer, idx, BasicTokenDuple.createCharArrayRepresentation(first, i));
            idx += BasicTokenDuple.getCharArrayLength(first, i);
        }
        return CharArrayUtils.extract(nameBuffer, 0, idx);
    }

    public boolean contains(ITokenDuple duple) {
        if (duple == null) {
            return false;
        }
        boolean foundFirst = false;
        boolean foundLast = false;
        IToken current = this.getFirstToken();
        while (current != null) {
            if (current == duple.getFirstToken()) {
                foundFirst = true;
            }
            if (current == duple.getLastToken()) {
                foundLast = true;
            }
            if (foundFirst && foundLast || current == this.getLastToken()) break;
            current = current.getNext();
        }
        return foundFirst && foundLast;
    }

    public String[] toQualifiedName() {
        return this.generateQualifiedName();
    }

    private String[] generateQualifiedName() {
        ArrayList<String> qn = new ArrayList<String>();
        IToken i = this.firstToken;
        while (i != this.lastToken) {
            boolean compl = false;
            if (i.getType() == 3) {
                i = i.getNext();
                continue;
            }
            if (i.getType() == 34) {
                compl = true;
                i = i.getNext();
            }
            if (i.getType() == 1) {
                if (compl) {
                    StringBuffer buff = new StringBuffer("~");
                    buff.append(i.getImage());
                    qn.add(buff.toString());
                } else {
                    qn.add(i.getImage());
                }
            }
            i = i.getNext();
        }
        if (i.getType() == 1) {
            qn.add(i.getImage());
        }
        String[] qualifiedName = new String[qn.size()];
        return qn.toArray(qualifiedName);
    }

    protected int calculateSegmentCount() {
        int n = 1;
        IToken token = null;
        IToken last = this.getLastToken();
        while (token != last) {
            IToken iToken = token = token != null ? token.getNext() : this.getFirstToken();
            if (token == null) break;
            if (token.getType() == 42) {
                token = TokenFactory.consumeTemplateIdArguments(token, last);
            }
            if (token.getType() != 3) continue;
            ++n;
        }
        return n;
    }

    public void freeReferences() {
    }

    public void acceptElement(ISourceElementRequestor requestor) {
    }

    public char[] toCharArray() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = BasicTokenDuple.createCharArrayRepresentation(this.firstToken, this.lastToken);
        }
        return this.stringRepresentation;
    }

    public char[] getFilename() {
        return this.firstToken.getFilename();
    }

    private class TokenIterator
    implements Iterator {
        private IToken iter;

        private TokenIterator() {
            this.iter = BasicTokenDuple.this.firstToken;
        }

        public boolean hasNext() {
            return this.iter != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            IToken temp = this.iter;
            this.iter = this.iter == BasicTokenDuple.this.lastToken ? null : this.iter.getNext();
            return temp;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

