/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.eclipse.cdt.internal.core.pdom.db.DBStatus;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class Chunk {
    private MappedByteBuffer buffer;
    private Database db;
    int index;

    Chunk(RandomAccessFile file, int offset) throws CoreException {
        try {
            this.index = offset / 16384;
            this.buffer = file.getChannel().map(FileChannel.MapMode.READ_WRITE, offset, 16384L);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new DBStatus(e));
        }
    }

    public void putByte(int offset, byte value) {
        this.buffer.put(offset % 16384, value);
    }

    public byte getByte(int offset) {
        return this.buffer.get(offset % 16384);
    }

    public byte[] getBytes(int offset, int length) {
        byte[] bytes = new byte[length];
        this.buffer.position(offset % 16384);
        this.buffer.get(bytes, 0, length);
        return bytes;
    }

    public void putBytes(int offset, byte[] bytes) {
        this.buffer.position(offset % 16384);
        this.buffer.put(bytes, 0, bytes.length);
    }

    public void putInt(int offset, int value) {
        this.buffer.putInt(offset % 16384, value);
    }

    public int getInt(int offset) {
        return this.buffer.getInt(offset % 16384);
    }

    public void putChar(int offset, char value) {
        this.buffer.putChar(offset % 16384, value);
    }

    public char getChar(int offset) {
        return this.buffer.getChar(offset % 16384);
    }

    void clear(int offset, int length) {
        this.buffer.position(offset % 16384);
        this.buffer.put(new byte[length]);
    }

    void free() {
        this.db.toc[this.index] = null;
    }
}

