/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer.full;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.indexer.full.PDOMFullIndexer;
import org.eclipse.core.runtime.CoreException;

public abstract class PDOMFullIndexerJob
implements IPDOMIndexerTask {
    protected final PDOMFullIndexer indexer;
    protected final PDOM pdom;
    protected int errorCount;
    protected final int MAX_ERRORS = 10;

    public PDOMFullIndexerJob(PDOMFullIndexer indexer) throws CoreException {
        this.indexer = indexer;
        this.pdom = (PDOM)CCorePlugin.getPDOMManager().getPDOM(indexer.getProject());
    }

    public IPDOMIndexer getIndexer() {
        return this.indexer;
    }

    protected IASTTranslationUnit parse(ITranslationUnit tu) throws CoreException {
        ILanguage language = tu.getLanguage();
        if (language == null) {
            return null;
        }
        return language.getASTTranslationUnit(tu, 8);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addTU(ITranslationUnit tu) throws InterruptedException, CoreException {
        IASTTranslationUnit ast = this.parse(tu);
        if (ast == null) {
            return;
        }
        this.pdom.acquireWriteLock();
        try {
            IASTPreprocessorIncludeStatement[] includes = ast.getIncludeDirectives();
            int i = 0;
            while (true) {
                block6: {
                    if (i < includes.length) break block6;
                    this.addSymbols(tu.getLanguage(), ast);
                    break;
                }
                String incname = includes[i].getPath();
                PDOMFile incfile = this.pdom.getFile(incname);
                if (incfile != null) {
                    incfile.clear();
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.pdom.releaseWriteLock();
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.pdom.releaseWriteLock();
            return;
        }
    }

    public void addSymbols(ILanguage language, IASTTranslationUnit ast) throws CoreException {
        PDOMFile sourceFile;
        final PDOMLinkage linkage = this.pdom.getLinkage(language);
        if (linkage == null) {
            return;
        }
        IASTPreprocessorIncludeStatement[] includes = ast.getIncludeDirectives();
        int i = 0;
        while (i < includes.length) {
            IASTPreprocessorIncludeStatement include = includes[i];
            IASTFileLocation sourceLoc = include.getFileLocation();
            String sourcePath = sourceLoc != null ? sourceLoc.getFileName() : ast.getFilePath();
            sourceFile = this.pdom.addFile(sourcePath);
            String destPath = include.getPath();
            PDOMFile destFile = this.pdom.addFile(destPath);
            sourceFile.addIncludeTo(destFile);
            ++i;
        }
        IASTPreprocessorMacroDefinition[] macros = ast.getMacroDefinitions();
        int i2 = 0;
        while (i2 < macros.length) {
            IASTPreprocessorMacroDefinition macro = macros[i2];
            IASTFileLocation sourceLoc = macro.getFileLocation();
            if (sourceLoc != null && (sourceFile = this.pdom.getFile(sourceLoc.getFileName())) != null) {
                sourceFile.addMacro(macro);
            }
            ++i2;
        }
        ast.accept(new ASTVisitor(){
            {
                this.shouldVisitNames = true;
                this.shouldVisitDeclarations = true;
            }

            public int visit(IASTName name) {
                try {
                    IASTFileLocation fileloc = name.getFileLocation();
                    if (fileloc != null) {
                        PDOMFile file = PDOMFullIndexerJob.this.pdom.addFile(fileloc.getFileName());
                        linkage.addName(name, file);
                    }
                    return 3;
                }
                catch (Throwable e) {
                    CCorePlugin.log(e);
                    return ++PDOMFullIndexerJob.this.errorCount > 10 ? 2 : 3;
                }
            }
        });
    }
}

