/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIAddressLocation;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDIFileLocation;
import org.eclipse.cdt.debug.core.cdi.ICDIFunctionLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILineLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILocator;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDICreatedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.model.ICDIAddressBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIFunctionBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDILineBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocationBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIWatchpoint;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICThread;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.internal.core.CBreakpointNotifier;
import org.eclipse.cdt.debug.internal.core.breakpoints.CBreakpoint;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;

public class CBreakpointManager
implements IBreakpointsListener,
IBreakpointManagerListener,
ICDIEventListener,
IAdaptable {
    private CDebugTarget fDebugTarget;
    private BreakpointMap fMap;
    private boolean fSkipBreakpoint = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public CBreakpointManager(CDebugTarget target) {
        this.fDebugTarget = target;
        this.fMap = new BreakpointMap();
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        if (!this.isTargetAvailable()) {
            return;
        }
        this.setBreakpointsOnTarget(breakpoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        if (!this.isTargetAvailable()) {
            return;
        }
        ArrayList<ICDIBreakpoint> list = new ArrayList<ICDIBreakpoint>(breakpoints.length);
        BreakpointMap breakpointMap = this.getBreakpointMap();
        synchronized (breakpointMap) {
            int i = 0;
            while (i < breakpoints.length) {
                if (breakpoints[i] instanceof ICBreakpoint) {
                    Object obj = this.getBreakpointMap().get((ICBreakpoint)breakpoints[i]);
                    ICDIBreakpoint b = null;
                    if (obj instanceof ICDIBreakpoint) {
                        b = (ICDIBreakpoint)obj;
                    } else if (obj instanceof BreakpointInProgess) {
                        b = ((BreakpointInProgess)obj).getCDIBreakpoint();
                    }
                    if (b != null) {
                        list.add(b);
                    }
                }
                ++i;
            }
        }
        if (list.isEmpty()) {
            return;
        }
        final ICDIBreakpoint[] cdiBreakpoints = list.toArray(new ICDIBreakpoint[list.size()]);
        final ICDITarget cdiTarget = this.getCDITarget();
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    cdiTarget.deleteBreakpoints(cdiBreakpoints);
                }
                catch (CDIException cDIException) {}
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        ArrayList<ICBreakpoint> removeList = new ArrayList<ICBreakpoint>(breakpoints.length);
        ArrayList<ICBreakpoint> installList = new ArrayList<ICBreakpoint>(breakpoints.length);
        BreakpointMap breakpointMap = this.getBreakpointMap();
        synchronized (breakpointMap) {
            int i = 0;
            while (i < breakpoints.length) {
                if (breakpoints[i] instanceof ICBreakpoint && this.isTargetAvailable()) {
                    ICBreakpoint b = (ICBreakpoint)breakpoints[i];
                    boolean install = false;
                    try {
                        ICDebugTarget[] tfs = b.getTargetFilters();
                        install = Arrays.asList(tfs).contains(this.getDebugTarget());
                    }
                    catch (CoreException coreException) {}
                    boolean registered = this.getBreakpointMap().isRegistered(b);
                    boolean inProgress = this.getBreakpointMap().isInProgress(b);
                    if (registered && !inProgress && !install) {
                        removeList.add(b);
                    }
                    if (!registered && install) {
                        installList.add(b);
                    }
                }
                ++i;
            }
        }
        this.breakpointsRemoved(removeList.toArray(new ICBreakpoint[removeList.size()]), new IMarkerDelta[0]);
        this.breakpointsAdded(installList.toArray(new ICBreakpoint[removeList.size()]));
        int i = 0;
        while (i < breakpoints.length) {
            if (breakpoints[i] instanceof ICBreakpoint && this.isTargetAvailable()) {
                this.changeBreakpointProperties((ICBreakpoint)breakpoints[i], deltas[i]);
            }
            ++i;
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        this.doSkipBreakpoints(!enabled);
    }

    public void handleDebugEvents(ICDIEvent[] events) {
        int i = 0;
        while (i < events.length) {
            ICDIEvent event = events[i];
            ICDIObject source = event.getSource();
            if (source != null && source.getTarget().equals(this.getDebugTarget().getCDITarget())) {
                if (event instanceof ICDICreatedEvent) {
                    if (source instanceof ICDIBreakpoint) {
                        this.handleBreakpointCreatedEvent((ICDIBreakpoint)source);
                    }
                } else if (event instanceof ICDIDestroyedEvent) {
                    if (source instanceof ICDIBreakpoint) {
                        this.handleBreakpointDestroyedEvent((ICDIBreakpoint)source);
                    }
                } else if (event instanceof ICDIChangedEvent && source instanceof ICDIBreakpoint) {
                    this.handleBreakpointChangedEvent((ICDIBreakpoint)source);
                }
            }
            ++i;
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.internal.core.CBreakpointManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.debug.internal.core.model.CDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(adapter)) {
            return this.getDebugTarget();
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.cdt.debug.core.model.ICDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.equals(adapter)) {
            return this.getDebugTarget();
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz4.equals(adapter)) {
            return this.getDebugTarget();
        }
        return null;
    }

    public CDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public void initialize() {
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointManagerListener((IBreakpointManagerListener)this);
        this.getDebugTarget().getCDISession().getEventManager().addEventListener(this);
    }

    public void dispose() {
        this.getDebugTarget().getCDISession().getEventManager().removeEventListener(this);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointManagerListener((IBreakpointManagerListener)this);
        this.removeAllBreakpoints();
        this.getBreakpointMap().dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAddress getBreakpointAddress(ICLineBreakpoint breakpoint) {
        BigInteger address = null;
        BreakpointMap breakpointMap = this.getBreakpointMap();
        synchronized (breakpointMap) {
            ICDILocator locator;
            ICDIBreakpoint cdiBreakpoint = this.getBreakpointMap().getCDIBreakpoint(breakpoint);
            if (cdiBreakpoint instanceof ICDILocationBreakpoint && (locator = ((ICDILocationBreakpoint)cdiBreakpoint).getLocator()) != null) {
                address = locator.getAddress();
            }
        }
        return address != null ? this.getDebugTarget().getAddressFactory().createAddress(address) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBreakpoint getBreakpoint(ICDIBreakpoint cdiBreakpoint) {
        ICBreakpoint b = null;
        BreakpointMap breakpointMap = this.getBreakpointMap();
        synchronized (breakpointMap) {
            b = this.getBreakpointMap().getCBreakpoint(cdiBreakpoint);
        }
        return b instanceof IBreakpoint ? (IBreakpoint)b : null;
    }

    private void handleBreakpointCreatedEvent(ICDIBreakpoint cdiBreakpoint) {
        if (cdiBreakpoint instanceof ICDIWatchpoint) {
            this.doHandleWatchpointCreatedEvent((ICDIWatchpoint)cdiBreakpoint);
        } else if (cdiBreakpoint instanceof ICDILocationBreakpoint) {
            this.doHandleLocationBreakpointCreatedEvent((ICDILocationBreakpoint)cdiBreakpoint);
        }
        if (!cdiBreakpoint.isTemporary() && !DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
            try {
                cdiBreakpoint.setEnabled(false);
            }
            catch (CDIException cDIException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandleLocationBreakpointCreatedEvent(ICDILocationBreakpoint cdiBreakpoint) {
        if (cdiBreakpoint.isTemporary()) {
            return;
        }
        ICBreakpoint breakpoint = null;
        BreakpointMap breakpointMap = this.getBreakpointMap();
        synchronized (breakpointMap) {
            breakpoint = this.getBreakpointMap().getCBreakpoint(cdiBreakpoint);
            if (breakpoint == null) {
                breakpoint = this.createLocationBreakpoint(cdiBreakpoint);
            }
            if (breakpoint != null) {
                this.getBreakpointMap().put(breakpoint, cdiBreakpoint);
            }
        }
        if (breakpoint != null) {
            try {
                breakpoint.setTargetFilter(this.getDebugTarget());
                ((CBreakpoint)breakpoint).register(true);
            }
            catch (CoreException coreException) {}
            this.getBreakpointNotifier().breakpointInstalled(this.getDebugTarget(), breakpoint);
            this.changeBreakpointProperties(breakpoint, cdiBreakpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandleWatchpointCreatedEvent(ICDIWatchpoint cdiWatchpoint) {
        ICBreakpoint breakpoint = null;
        BreakpointMap breakpointMap = this.getBreakpointMap();
        synchronized (breakpointMap) {
            breakpoint = this.getBreakpointMap().getCBreakpoint(cdiWatchpoint);
            if (breakpoint == null) {
                try {
                    breakpoint = this.createWatchpoint(cdiWatchpoint);
                }
                catch (CDIException cDIException) {
                }
                catch (CoreException coreException) {}
            }
            if (breakpoint != null) {
                this.getBreakpointMap().put(breakpoint, cdiWatchpoint);
            }
        }
        if (breakpoint != null) {
            try {
                breakpoint.setTargetFilter(this.getDebugTarget());
                ((CBreakpoint)breakpoint).register(true);
            }
            catch (CoreException coreException) {}
            this.getBreakpointNotifier().breakpointInstalled(this.getDebugTarget(), breakpoint);
            this.changeBreakpointProperties(breakpoint, cdiWatchpoint);
        }
    }

    private void handleBreakpointChangedEvent(ICDIBreakpoint cdiBreakpoint) {
        ICBreakpoint breakpoint = this.getBreakpointMap().getCBreakpoint(cdiBreakpoint);
        if (breakpoint != null) {
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            try {
                if (!this.fSkipBreakpoint && DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
                    map.put("org.eclipse.debug.core.enabled", cdiBreakpoint.isEnabled());
                } else {
                    map.put("org.eclipse.debug.core.enabled", breakpoint.isEnabled());
                }
            }
            catch (CDIException cDIException) {
            }
            catch (CoreException coreException) {}
            try {
                map.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(cdiBreakpoint.getCondition().getIgnoreCount()));
            }
            catch (CDIException cDIException) {}
            try {
                map.put("org.eclipse.cdt.debug.core.condition", cdiBreakpoint.getCondition().getExpression());
            }
            catch (CDIException cDIException) {}
            this.getBreakpointNotifier().breakpointChanged(this.getDebugTarget(), breakpoint, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBreakpointDestroyedEvent(ICDIBreakpoint cdiBreakpoint) {
        ICBreakpoint breakpoint = null;
        BreakpointMap breakpointMap = this.getBreakpointMap();
        synchronized (breakpointMap) {
            breakpoint = this.getBreakpointMap().getCBreakpoint(cdiBreakpoint);
            this.getBreakpointMap().removeCDIBreakpoint(cdiBreakpoint);
        }
        if (breakpoint != null) {
            if (this.isFilteredByTarget(breakpoint, this.getDebugTarget())) {
                try {
                    breakpoint.removeTargetFilter(this.getDebugTarget());
                }
                catch (CoreException coreException) {}
            }
            this.getBreakpointNotifier().breakpointsRemoved(this.getDebugTarget(), new IBreakpoint[]{breakpoint});
        }
    }

    private BreakpointMap getBreakpointMap() {
        return this.fMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllBreakpoints() {
        ArrayList<ICDIBreakpoint> list = new ArrayList<ICDIBreakpoint>();
        IBreakpoint[] breakpoints = new ICBreakpoint[]{};
        BreakpointMap breakpointMap = this.getBreakpointMap();
        synchronized (breakpointMap) {
            breakpoints = this.getBreakpointMap().getAllCBreakpoints();
            int i = 0;
            while (i < breakpoints.length) {
                if (!this.getBreakpointMap().isInProgress(breakpoints[i])) {
                    list.add(this.getBreakpointMap().getCDIBreakpoint(breakpoints[i]));
                }
                ++i;
            }
        }
        if (list.isEmpty()) {
            return;
        }
        final ICDIBreakpoint[] cdiBreakpoints = list.toArray(new ICDIBreakpoint[list.size()]);
        final ICDITarget cdiTarget = this.getCDITarget();
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    cdiTarget.deleteBreakpoints(cdiBreakpoints);
                }
                catch (CDIException cDIException) {}
            }
        });
        this.getBreakpointNotifier().breakpointsRemoved(this.getDebugTarget(), breakpoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICBreakpoint[] register(IBreakpoint[] breakpoints) {
        ArrayList<IBreakpoint> list = new ArrayList<IBreakpoint>(breakpoints.length);
        BreakpointMap breakpointMap = this.getBreakpointMap();
        synchronized (breakpointMap) {
            int i = 0;
            while (i < breakpoints.length) {
                if (breakpoints[i] instanceof ICBreakpoint && this.isTargetBreakpoint((ICBreakpoint)breakpoints[i]) && !this.getBreakpointMap().isRegistered((ICBreakpoint)breakpoints[i])) {
                    this.getBreakpointMap().register((ICBreakpoint)breakpoints[i]);
                    list.add(breakpoints[i]);
                }
                ++i;
            }
        }
        return list.toArray(new ICBreakpoint[list.size()]);
    }

    private void setBreakpointsOnTarget(IBreakpoint[] breakpoints) {
        final ICBreakpoint[] bkpts = this.register(breakpoints);
        if (bkpts.length > 0) {
            DebugPlugin.getDefault().asyncExec(new Runnable(){

                public void run() {
                    CBreakpointManager.this.setBreakpointsOnTarget0(bkpts);
                }
            });
        }
    }

    protected void setBreakpointsOnTarget0(ICBreakpoint[] breakpoints) {
        ICDITarget cdiTarget = this.getCDITarget();
        int i = 0;
        while (i < breakpoints.length) {
            try {
                Object obj;
                ICDICondition condition;
                ICDICondition condition2;
                ICDIFileLocation location;
                ICLineBreakpoint breakpoint;
                ICDIBreakpoint b = null;
                if (breakpoints[i] instanceof ICFunctionBreakpoint) {
                    breakpoint = (ICFunctionBreakpoint)breakpoints[i];
                    String function = breakpoint.getFunction();
                    String fileName = breakpoint.getFileName();
                    location = cdiTarget.createFunctionLocation(fileName, function);
                    condition2 = this.createCondition(breakpoint);
                    b = cdiTarget.setFunctionBreakpoint(0, (ICDIFunctionLocation)location, condition2, true);
                } else if (breakpoints[i] instanceof ICAddressBreakpoint) {
                    breakpoint = (ICAddressBreakpoint)breakpoints[i];
                    String address = breakpoint.getAddress();
                    ICDIAddressLocation location2 = cdiTarget.createAddressLocation(new BigInteger(address.startsWith("0x") ? address.substring(2) : address, 16));
                    condition = this.createCondition(breakpoint);
                    b = cdiTarget.setAddressBreakpoint(0, location2, condition, true);
                } else if (breakpoints[i] instanceof ICLineBreakpoint) {
                    breakpoint = (ICLineBreakpoint)breakpoints[i];
                    String handle = breakpoint.getSourceHandle();
                    IPath path = this.convertPath(handle);
                    location = cdiTarget.createLineLocation(path.lastSegment(), breakpoint.getLineNumber());
                    condition2 = this.createCondition(breakpoint);
                    b = cdiTarget.setLineBreakpoint(0, (ICDILineLocation)location, condition2, true);
                } else if (breakpoints[i] instanceof ICWatchpoint) {
                    ICWatchpoint watchpoint = (ICWatchpoint)breakpoints[i];
                    int accessType = 0;
                    accessType |= watchpoint.isWriteType() ? 1 : 0;
                    int n = watchpoint.isReadType() ? 2 : 0;
                    String expression = watchpoint.getExpression();
                    condition = this.createCondition(watchpoint);
                    b = cdiTarget.setWatchpoint(0, accessType |= n, expression, condition);
                }
                if (b != null && (obj = this.getBreakpointMap().get(breakpoints[i])) instanceof BreakpointInProgess) {
                    ((BreakpointInProgess)obj).setCDIBreakpoint(b);
                }
                if (b != null && b.isEnabled() != breakpoints[i].isEnabled()) {
                    b.setEnabled(breakpoints[i].isEnabled());
                }
            }
            catch (CoreException coreException) {
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (CDIException cDIException) {}
            ++i;
        }
    }

    protected ICDITarget getCDITarget() {
        return this.getDebugTarget().getCDITarget();
    }

    private ICDICondition createCondition(ICBreakpoint breakpoint) throws CoreException, CDIException {
        return this.getCDITarget().createCondition(breakpoint.getIgnoreCount(), breakpoint.getCondition(), this.getThreadNames(breakpoint));
    }

    private String[] getThreadNames(ICBreakpoint breakpoint) {
        try {
            ICThread[] threads = breakpoint.getThreadFilters(this.getDebugTarget());
            if (threads == null) {
                return new String[0];
            }
            String[] names = new String[threads.length];
            int i = 0;
            while (i < threads.length) {
                names[i] = threads[i].getName();
                ++i;
            }
            return names;
        }
        catch (DebugException debugException) {
        }
        catch (CoreException coreException) {}
        return new String[0];
    }

    private ICLineBreakpoint createLocationBreakpoint(ICDILocationBreakpoint cdiBreakpoint) {
        ICLineBreakpoint breakpoint = null;
        try {
            ICDILocator location = cdiBreakpoint.getLocator();
            String file = location.getFile();
            if (!this.isEmpty(file)) {
                Object sourceElement = this.getSourceElement(file);
                String sourceHandle = file;
                IProject resource = this.getProject();
                if (sourceElement instanceof IFile) {
                    sourceHandle = ((IFile)sourceElement).getLocation().toOSString();
                    resource = (IResource)sourceElement;
                } else if (sourceElement instanceof IStorage) {
                    sourceHandle = ((IStorage)sourceElement).getFullPath().toOSString();
                    resource = ResourcesPlugin.getWorkspace().getRoot();
                }
                breakpoint = this.createLineBreakpoint(sourceHandle, (IResource)resource, cdiBreakpoint);
            } else if (!this.isEmpty(location.getFunction())) {
                breakpoint = this.createFunctionBreakpoint(cdiBreakpoint);
            } else if (!location.getAddress().equals(BigInteger.ZERO)) {
                breakpoint = this.createAddressBreakpoint(cdiBreakpoint);
            }
        }
        catch (CDIException cDIException) {
        }
        catch (CoreException coreException) {}
        return breakpoint;
    }

    private ICLineBreakpoint createLineBreakpoint(String sourceHandle, IResource resource, ICDILocationBreakpoint cdiBreakpoint) throws CDIException, CoreException {
        ICLineBreakpoint breakpoint = CDIDebugModel.createLineBreakpoint(sourceHandle, resource, cdiBreakpoint.getLocator().getLineNumber(), cdiBreakpoint.isEnabled(), cdiBreakpoint.getCondition().getIgnoreCount(), cdiBreakpoint.getCondition().getExpression(), false);
        return breakpoint;
    }

    private ICFunctionBreakpoint createFunctionBreakpoint(ICDILocationBreakpoint cdiBreakpoint) throws CDIException, CoreException {
        IPath execFile = this.getExecFilePath();
        String sourceHandle = execFile.toOSString();
        ICFunctionBreakpoint breakpoint = CDIDebugModel.createFunctionBreakpoint(sourceHandle, (IResource)this.getProject(), cdiBreakpoint.getLocator().getFunction(), -1, -1, -1, cdiBreakpoint.isEnabled(), cdiBreakpoint.getCondition().getIgnoreCount(), cdiBreakpoint.getCondition().getExpression(), false);
        return breakpoint;
    }

    private ICAddressBreakpoint createAddressBreakpoint(ICDILocationBreakpoint cdiBreakpoint) throws CDIException, CoreException {
        IPath execFile = this.getExecFilePath();
        String sourceHandle = execFile.toOSString();
        IAddress address = this.getDebugTarget().getAddressFactory().createAddress(cdiBreakpoint.getLocator().getAddress());
        ICAddressBreakpoint breakpoint = CDIDebugModel.createAddressBreakpoint(sourceHandle, sourceHandle, (IResource)ResourcesPlugin.getWorkspace().getRoot(), address, cdiBreakpoint.isEnabled(), cdiBreakpoint.getCondition().getIgnoreCount(), cdiBreakpoint.getCondition().getExpression(), false);
        return breakpoint;
    }

    private ICWatchpoint createWatchpoint(ICDIWatchpoint cdiWatchpoint) throws CDIException, CoreException {
        IPath execFile = this.getExecFilePath();
        String sourceHandle = execFile.toOSString();
        ICWatchpoint watchpoint = CDIDebugModel.createWatchpoint(sourceHandle, (IResource)this.getProject(), cdiWatchpoint.isWriteType(), cdiWatchpoint.isReadType(), cdiWatchpoint.getWatchExpression(), cdiWatchpoint.isEnabled(), cdiWatchpoint.getCondition().getIgnoreCount(), cdiWatchpoint.getCondition().getExpression(), false);
        return watchpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeBreakpointProperties(ICBreakpoint breakpoint, IMarkerDelta delta) {
        ICDIBreakpoint cdiBreakpoint = null;
        BreakpointMap breakpointMap = this.getBreakpointMap();
        synchronized (breakpointMap) {
            if (!this.getBreakpointMap().isInProgress(breakpoint)) {
                cdiBreakpoint = this.getBreakpointMap().getCDIBreakpoint(breakpoint);
            }
        }
        if (cdiBreakpoint == null) {
            return;
        }
        ICDITarget cdiTarget = this.getCDITarget();
        try {
            ICDICondition cdiCondition;
            boolean enabled = breakpoint.isEnabled();
            boolean oldEnabled = delta != null ? delta.getAttribute("org.eclipse.debug.core.enabled", true) : enabled;
            int ignoreCount = breakpoint.getIgnoreCount();
            int oldIgnoreCount = delta != null ? delta.getAttribute("org.eclipse.cdt.debug.core.ignoreCount", 0) : ignoreCount;
            String condition = breakpoint.getCondition();
            String oldCondition = delta != null ? delta.getAttribute("org.eclipse.cdt.debug.core.condition", "") : condition;
            String[] newThreadIs = this.getThreadNames(breakpoint);
            Boolean enabled0 = null;
            ICDICondition condition0 = null;
            if (enabled != oldEnabled && enabled != cdiBreakpoint.isEnabled()) {
                enabled0 = enabled;
            }
            if ((ignoreCount != oldIgnoreCount || condition.compareTo(oldCondition) != 0 || this.areThreadFiltersChanged(newThreadIs, cdiBreakpoint)) && !(cdiCondition = cdiTarget.createCondition(ignoreCount, condition, newThreadIs)).equals(cdiBreakpoint.getCondition())) {
                condition0 = cdiCondition;
            }
            if (enabled0 != null || condition0 != null) {
                this.changeBreakpointPropertiesOnTarget(cdiBreakpoint, enabled0, condition0);
            }
        }
        catch (CoreException coreException) {
        }
        catch (CDIException cDIException) {}
    }

    private void changeBreakpointProperties(ICBreakpoint breakpoint, ICDIBreakpoint cdiBreakpoint) {
        Boolean enabled = null;
        try {
            if (cdiBreakpoint.isEnabled() != breakpoint.isEnabled()) {
                enabled = breakpoint.isEnabled();
            }
        }
        catch (CDIException cDIException) {
        }
        catch (CoreException coreException) {}
        ICDICondition condition = null;
        try {
            ICDICondition c = this.createCondition(breakpoint);
            if (!cdiBreakpoint.getCondition().equals(c)) {
                condition = c;
            }
        }
        catch (CDIException cDIException) {
        }
        catch (CoreException coreException) {}
        if (enabled != null || condition != null) {
            this.changeBreakpointPropertiesOnTarget(cdiBreakpoint, enabled, condition);
        }
    }

    private void changeBreakpointPropertiesOnTarget(final ICDIBreakpoint breakpoint, final Boolean enabled, final ICDICondition condition) {
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (enabled != null) {
                    try {
                        breakpoint.setEnabled(enabled);
                    }
                    catch (CDIException cDIException) {}
                }
                if (condition != null) {
                    try {
                        breakpoint.setCondition(condition);
                    }
                    catch (CDIException cDIException) {}
                }
            }
        });
    }

    public void setInitialBreakpoints() {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] bps = manager.getBreakpoints(CDIDebugModel.getPluginIdentifier());
        int i = 0;
        while (i < bps.length) {
            if (bps[i] instanceof ICBreakpoint && this.isTargetBreakpoint((ICBreakpoint)bps[i]) && !this.getBreakpointMap().isRegistered((ICBreakpoint)bps[i]) && bps[i] instanceof ICAddressBreakpoint) {
                try {
                    bps[i].setEnabled(false);
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        ICBreakpoint[] breakpoints = this.register(bps);
        this.setBreakpointsOnTarget0(breakpoints);
    }

    private boolean isTargetBreakpoint(ICBreakpoint breakpoint) {
        block10: {
            IResource resource = breakpoint.getMarker().getResource();
            if (breakpoint instanceof ICAddressBreakpoint) {
                return this.supportsAddressBreakpoint((ICAddressBreakpoint)breakpoint);
            }
            if (breakpoint instanceof ICLineBreakpoint) {
                try {
                    String handle = breakpoint.getSourceHandle();
                    ISourceLocator sl = this.getSourceLocator();
                    if (sl instanceof ICSourceLocator) {
                        return ((ICSourceLocator)sl).findSourceElement(handle) != null;
                    }
                    if (sl instanceof CSourceLookupDirector) {
                        return ((CSourceLookupDirector)sl).contains(breakpoint);
                    }
                    break block10;
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
            IProject project = resource.getProject();
            if (project != null && project.exists()) {
                ISourceLocator sl = this.getSourceLocator();
                if (sl instanceof ICSourceLocator) {
                    return ((ICSourceLocator)sl).contains((IResource)project);
                }
                if (sl instanceof CSourceLookupDirector) {
                    return ((CSourceLookupDirector)sl).contains(project);
                }
                if (project.equals((Object)this.getProject())) {
                    return true;
                }
                return CDebugUtils.isReferencedProject(this.getProject(), project);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsBreakpoint(ICBreakpoint breakpoint) {
        boolean s = false;
        BreakpointMap breakpointMap = this.getBreakpointMap();
        synchronized (breakpointMap) {
            s = this.getBreakpointMap().isRegistered(breakpoint);
        }
        return s;
    }

    public boolean supportsAddressBreakpoint(ICAddressBreakpoint breakpoint) {
        String module = null;
        try {
            module = breakpoint.getModule();
        }
        catch (CoreException coreException) {}
        if (module != null) {
            return this.getExecFilePath().toOSString().equals(module);
        }
        try {
            return this.getExecFilePath().toOSString().equals(breakpoint.getSourceHandle());
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public void skipBreakpoints(boolean enabled) {
        if (this.fSkipBreakpoint != enabled && (DebugPlugin.getDefault().getBreakpointManager().isEnabled() || !enabled)) {
            this.fSkipBreakpoint = enabled;
            this.doSkipBreakpoints(enabled);
        }
    }

    public void watchpointOutOfScope(ICDIWatchpoint cdiWatchpoint) {
        this.handleBreakpointDestroyedEvent(cdiWatchpoint);
    }

    private void doSkipBreakpoints(boolean enabled) {
        ICBreakpoint[] cBreakpoints = this.getBreakpointMap().getAllCBreakpoints();
        int i = 0;
        while (i < cBreakpoints.length) {
            try {
                ICDIBreakpoint cdiBreakpoint;
                if (cBreakpoints[i].isEnabled() && (cdiBreakpoint = this.getBreakpointMap().getCDIBreakpoint(cBreakpoints[i])) != null) {
                    cdiBreakpoint.setEnabled(!enabled);
                }
            }
            catch (CoreException coreException) {
            }
            catch (CDIException cDIException) {}
            ++i;
        }
    }

    private IPath convertPath(String sourceHandle) {
        IPath path = null;
        if (Path.EMPTY.isValidPath(sourceHandle)) {
            ISourceLocator sl = this.getSourceLocator();
            if (sl instanceof CSourceLookupDirector) {
                path = ((CSourceLookupDirector)sl).getCompilationPath(sourceHandle);
            }
            if (path == null) {
                path = new Path(sourceHandle);
            }
        }
        return path;
    }

    private IProject getProject() {
        return this.getDebugTarget().getProject();
    }

    private IPath getExecFilePath() {
        return this.getDebugTarget().getExecFile().getPath();
    }

    private ISourceLocator getSourceLocator() {
        return this.getDebugTarget().getLaunch().getSourceLocator();
    }

    protected Object getSourceElement(String file) {
        Object sourceElement = null;
        ISourceLocator locator = this.getSourceLocator();
        if (locator instanceof ICSourceLocator || locator instanceof CSourceLookupDirector) {
            sourceElement = locator instanceof ICSourceLocator ? ((ICSourceLocator)locator).findSourceElement(file) : ((CSourceLookupDirector)locator).getSourceElement(file);
        }
        return sourceElement;
    }

    protected boolean isEmpty(String str) {
        return str == null || str.trim().length() <= 0;
    }

    private boolean isTargetAvailable() {
        return this.getDebugTarget().getCDITarget().getConfiguration().supportsBreakpoints() && this.getDebugTarget().isAvailable();
    }

    private CBreakpointNotifier getBreakpointNotifier() {
        return CBreakpointNotifier.getInstance();
    }

    private boolean isFilteredByTarget(ICBreakpoint breakpoint, ICDebugTarget target) {
        boolean result = false;
        try {
            ICDebugTarget[] tfs = breakpoint.getTargetFilters();
            result = Arrays.asList(tfs).contains(target);
        }
        catch (CoreException coreException) {}
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean areThreadFiltersChanged(String[] newIds, ICDIBreakpoint cdiBreakpoint) {
        try {
            String[] oldIds = cdiBreakpoint.getCondition().getThreadIds();
            if (oldIds.length != newIds.length) {
                return true;
            }
            List<String> list = Arrays.asList(oldIds);
            int i = 0;
            while (true) {
                if (i >= newIds.length) {
                    return false;
                }
                if (!list.contains(newIds[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (CDIException cDIException) {}
        return false;
    }

    static class BreakpointInProgess {
        private ICDIBreakpoint fCDIBreakpoint;

        BreakpointInProgess() {
        }

        void setCDIBreakpoint(ICDIBreakpoint b) {
            this.fCDIBreakpoint = b;
        }

        ICDIBreakpoint getCDIBreakpoint() {
            return this.fCDIBreakpoint;
        }
    }

    class BreakpointMap {
        private HashMap fCBreakpoints = new HashMap(10);
        private HashMap fCDIBreakpoints = new HashMap(10);

        protected BreakpointMap() {
        }

        void register(ICBreakpoint breakpoint) {
            this.fCBreakpoints.put(breakpoint, new BreakpointInProgess());
        }

        void put(ICBreakpoint breakpoint, ICDIBreakpoint cdiBreakpoint) {
            this.fCBreakpoints.put(breakpoint, cdiBreakpoint);
            this.fCDIBreakpoints.put(cdiBreakpoint, breakpoint);
        }

        Object get(ICBreakpoint breakpoint) {
            return this.fCBreakpoints.get(breakpoint);
        }

        ICDIBreakpoint getCDIBreakpoint(ICBreakpoint breakpoint) {
            Object b = this.fCBreakpoints.get(breakpoint);
            return b instanceof ICDIBreakpoint ? (ICDIBreakpoint)b : null;
        }

        ICBreakpoint getCBreakpoint(ICDIBreakpoint cdiBreakpoint) {
            ICBreakpoint breakpoint = (ICBreakpoint)this.fCDIBreakpoints.get(cdiBreakpoint);
            if (breakpoint == null) {
                ICBreakpoint[] bip = this.getBreakpointsInProgress();
                int i = 0;
                while (i < bip.length) {
                    if (this.isSameBreakpoint(bip[i], cdiBreakpoint)) {
                        breakpoint = bip[i];
                        break;
                    }
                    ++i;
                }
            }
            return breakpoint;
        }

        void removeCDIBreakpoint(ICDIBreakpoint cdiBreakpoint) {
            ICBreakpoint breakpoint;
            if (cdiBreakpoint != null && (breakpoint = (ICBreakpoint)this.fCDIBreakpoints.remove(cdiBreakpoint)) != null) {
                this.fCBreakpoints.remove(breakpoint);
            }
        }

        boolean isRegistered(ICBreakpoint breakpoint) {
            return this.fCBreakpoints.get(breakpoint) != null;
        }

        boolean isInProgress(ICBreakpoint breakpoint) {
            return this.fCBreakpoints.get(breakpoint) instanceof BreakpointInProgess;
        }

        ICBreakpoint[] getAllCBreakpoints() {
            Set set = this.fCBreakpoints.keySet();
            return set.toArray(new ICBreakpoint[set.size()]);
        }

        void dispose() {
            this.fCBreakpoints.clear();
            this.fCDIBreakpoints.clear();
        }

        private ICBreakpoint[] getBreakpointsInProgress() {
            ArrayList list = new ArrayList();
            Set set = this.fCBreakpoints.entrySet();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!(entry.getValue() instanceof BreakpointInProgess)) continue;
                list.add(entry.getKey());
            }
            return list.toArray(new ICBreakpoint[list.size()]);
        }

        private boolean isSameBreakpoint(ICBreakpoint breakpoint, ICDIBreakpoint cdiBreakpoint) {
            try {
                if (breakpoint instanceof ICFunctionBreakpoint && cdiBreakpoint instanceof ICDIFunctionBreakpoint) {
                    return ((ICFunctionBreakpoint)breakpoint).getFunction().compareTo(((ICDIFunctionBreakpoint)cdiBreakpoint).getLocator().getFunction()) == 0;
                }
                if (breakpoint instanceof ICAddressBreakpoint && cdiBreakpoint instanceof ICDIAddressBreakpoint) {
                    IAddressFactory factory = CBreakpointManager.this.getDebugTarget().getAddressFactory();
                    return factory.createAddress(((ICAddressBreakpoint)breakpoint).getAddress()).equals((Object)factory.createAddress(((ICDIAddressBreakpoint)cdiBreakpoint).getLocator().getAddress()));
                }
                if (breakpoint instanceof ICLineBreakpoint && cdiBreakpoint instanceof ICDILineBreakpoint) {
                    String file;
                    ICDILocator location = ((ICDILineBreakpoint)cdiBreakpoint).getLocator();
                    String sourceHandle = file = location.getFile();
                    if (!CBreakpointManager.this.isEmpty(file)) {
                        Object sourceElement = CBreakpointManager.this.getSourceElement(file);
                        if (sourceElement instanceof IFile) {
                            sourceHandle = ((IFile)sourceElement).getLocation().toOSString();
                        } else if (sourceElement instanceof IStorage) {
                            sourceHandle = ((IStorage)sourceElement).getFullPath().toOSString();
                        }
                        String bpSourceHandle = ((ICLineBreakpoint)breakpoint).getSourceHandle();
                        if (sourceElement instanceof LocalFileStorage) {
                            try {
                                bpSourceHandle = new File(bpSourceHandle).getCanonicalPath();
                            }
                            catch (IOException iOException) {}
                        }
                        return sourceHandle.equals(bpSourceHandle) && location.getLineNumber() == ((ICLineBreakpoint)breakpoint).getLineNumber();
                    }
                }
                if (breakpoint instanceof ICWatchpoint && cdiBreakpoint instanceof ICDIWatchpoint) {
                    try {
                        ICWatchpoint watchpoint = (ICWatchpoint)breakpoint;
                        ICDIWatchpoint cdiWatchpoint = (ICDIWatchpoint)cdiBreakpoint;
                        return watchpoint.getExpression().compareTo(cdiWatchpoint.getWatchExpression()) == 0 && watchpoint.isReadType() == cdiWatchpoint.isReadType() && watchpoint.isWriteType() == cdiWatchpoint.isWriteType();
                    }
                    catch (CDIException cDIException) {}
                }
            }
            catch (CoreException coreException) {}
            return false;
        }
    }
}

