/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgumentDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocalVariableDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThreadStorageDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.RxThread;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Manager;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Argument;
import org.eclipse.cdt.debug.mi.core.cdi.model.ArgumentDescriptor;
import org.eclipse.cdt.debug.mi.core.cdi.model.GlobalVariable;
import org.eclipse.cdt.debug.mi.core.cdi.model.GlobalVariableDescriptor;
import org.eclipse.cdt.debug.mi.core.cdi.model.LocalVariable;
import org.eclipse.cdt.debug.mi.core.cdi.model.LocalVariableDescriptor;
import org.eclipse.cdt.debug.mi.core.cdi.model.Register;
import org.eclipse.cdt.debug.mi.core.cdi.model.RegisterDescriptor;
import org.eclipse.cdt.debug.mi.core.cdi.model.StackFrame;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.cdi.model.ThreadStorage;
import org.eclipse.cdt.debug.mi.core.cdi.model.ThreadStorageDescriptor;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.cdi.model.VariableDescriptor;
import org.eclipse.cdt.debug.mi.core.command.CLIPType;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIStackListArguments;
import org.eclipse.cdt.debug.mi.core.command.MIStackListLocals;
import org.eclipse.cdt.debug.mi.core.command.MIVarCreate;
import org.eclipse.cdt.debug.mi.core.command.MIVarDelete;
import org.eclipse.cdt.debug.mi.core.command.MIVarUpdate;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarDeletedEvent;
import org.eclipse.cdt.debug.mi.core.output.CLIPTypeInfo;
import org.eclipse.cdt.debug.mi.core.output.MIArg;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIStackListArgumentsInfo;
import org.eclipse.cdt.debug.mi.core.output.MIStackListLocalsInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVar;
import org.eclipse.cdt.debug.mi.core.output.MIVarChange;
import org.eclipse.cdt.debug.mi.core.output.MIVarUpdateInfo;

public class VariableManager
extends Manager {
    static final ICDIVariable[] EMPTY_VARIABLES = new ICDIVariable[0];
    int MAX_STACK_DEPTH = 200;
    Map variablesMap;
    MIVarChange[] noChanges = new MIVarChange[0];

    public VariableManager(Session session) {
        super(session, true);
        this.variablesMap = new Hashtable();
    }

    synchronized List getVariablesList(Target target) {
        List variablesList = (List)this.variablesMap.get(target);
        if (variablesList == null) {
            variablesList = Collections.synchronizedList(new ArrayList());
            this.variablesMap.put(target, variablesList);
        }
        return variablesList;
    }

    public Variable getVariable(MISession miSession, String varName) {
        Target target = ((Session)this.getSession()).getTarget(miSession);
        return this.getVariable(target, varName);
    }

    public Variable getVariable(Target target, String varName) {
        Variable[] vars = this.getVariables(target);
        int i = 0;
        while (i < vars.length) {
            try {
                if (vars[i].getMIVar().getVarName().equals(varName)) {
                    return vars[i];
                }
                Variable v = vars[i].getChild(varName);
                if (v != null) {
                    return v;
                }
            }
            catch (CDIException cDIException) {}
            ++i;
        }
        return null;
    }

    Variable findVariable(VariableDescriptor v) throws CDIException {
        Target target = (Target)v.getTarget();
        ICDIStackFrame vstack = v.getStackFrame();
        ICDIThread vthread = v.getThread();
        int position = v.getPosition();
        int depth = v.getStackDepth();
        Variable[] vars = this.getVariables(target);
        int i = 0;
        while (i < vars.length) {
            if (vars[i].getFullName().equals(v.getFullName()) && vars[i].getName().equals(v.getName()) && vars[i].getCastingArrayStart() == v.getCastingArrayStart() && vars[i].getCastingArrayEnd() == v.getCastingArrayEnd() && VariableDescriptor.equalsCasting(vars[i], v)) {
                ICDIThread thread = vars[i].getThread();
                if (vthread == null && thread == null || vthread != null && thread != null && thread.equals(vthread)) {
                    ICDIStackFrame frame = vars[i].getStackFrame();
                    if (vstack == null && frame == null) {
                        return vars[i];
                    }
                    if (frame != null && vstack != null && frame.equals(vstack) && vars[i].getPosition() == position && vars[i].getStackDepth() == depth) {
                        return vars[i];
                    }
                }
            }
            ++i;
        }
        return null;
    }

    Variable[] getVariables(Target target) {
        List variableList = (List)this.variablesMap.get(target);
        if (variableList != null) {
            return variableList.toArray(new Variable[variableList.size()]);
        }
        return new Variable[0];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkType(StackFrame frame, String type) throws CDIException {
        if (type == null) throw new CDIException(CdiResources.getString("cdi.VariableManager.Unknown_type"));
        if (type.length() <= 0) throw new CDIException(CdiResources.getString("cdi.VariableManager.Unknown_type"));
        Target target = (Target)frame.getTarget();
        Thread currentThread = (Thread)target.getCurrentThread();
        StackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.lockTarget();
        try {
            try {
                target.setCurrentThread(frame.getThread(), false);
                ((Thread)frame.getThread()).setCurrentStackFrame(frame, false);
                MISession miSession = target.getMISession();
                RxThread rxThread = miSession.getRxThread();
                rxThread.setEnableConsole(false);
                CommandFactory factory = miSession.getCommandFactory();
                CLIPType ptype = factory.createCLIPType(type);
                miSession.postCommand(ptype);
                CLIPTypeInfo info = ptype.getMIPtypeInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            MISession miSession = target.getMISession();
            RxThread rxThread = miSession.getRxThread();
            rxThread.setEnableConsole(true);
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            target.releaseTarget();
            throw throwable;
        }
        {
            Object var11_14 = null;
            MISession miSession = target.getMISession();
            RxThread rxThread = miSession.getRxThread();
            rxThread.setEnableConsole(true);
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            target.releaseTarget();
            return;
        }
    }

    void removeMIVar(MISession miSession, MIVar miVar) throws CDIException {
        CommandFactory factory = miSession.getCommandFactory();
        MIVarDelete var = factory.createMIVarDelete(miVar.getVarName());
        try {
            miSession.postCommand(var);
            var.getMIInfo();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variable removeVariableFromList(MISession miSession, String varName) {
        List varList;
        Target target = ((Session)this.getSession()).getTarget(miSession);
        List list = varList = this.getVariablesList(target);
        synchronized (list) {
            Iterator iterator = varList.iterator();
            while (iterator.hasNext()) {
                Variable variable = (Variable)iterator.next();
                try {
                    if (!variable.getMIVar().getVarName().equals(varName)) continue;
                    iterator.remove();
                    return variable;
                }
                catch (CDIException cDIException) {}
            }
        }
        return null;
    }

    public VariableDescriptor getVariableDescriptorAsArray(VariableDescriptor varDesc, int start, int length) throws CDIException {
        Target target = (Target)varDesc.getTarget();
        Thread thread = (Thread)varDesc.getThread();
        StackFrame frame = (StackFrame)varDesc.getStackFrame();
        String name = varDesc.getName();
        String fullName = varDesc.getFullName();
        int pos = varDesc.getPosition();
        int depth = varDesc.getStackDepth();
        VariableDescriptor vo = null;
        if (varDesc instanceof ArgumentDescriptor || varDesc instanceof Argument) {
            vo = new ArgumentDescriptor(target, thread, frame, name, fullName, pos, depth);
        } else if (varDesc instanceof LocalVariableDescriptor || varDesc instanceof LocalVariable) {
            vo = new LocalVariableDescriptor(target, thread, frame, name, fullName, pos, depth);
        } else if (varDesc instanceof GlobalVariableDescriptor || varDesc instanceof GlobalVariable) {
            vo = new GlobalVariableDescriptor(target, thread, frame, name, fullName, pos, depth);
        } else if (varDesc instanceof RegisterDescriptor || varDesc instanceof Register) {
            vo = new RegisterDescriptor(target, thread, frame, name, fullName, pos, depth);
        } else if (varDesc instanceof ThreadStorageDescriptor || varDesc instanceof ThreadStorage) {
            vo = new ThreadStorageDescriptor(target, thread, frame, name, fullName, pos, depth);
        } else {
            throw new CDIException(CdiResources.getString("cdi.VariableManager.Unknown_variable_object"));
        }
        vo.setCastingArrayStart(varDesc.getCastingArrayStart() + start);
        vo.setCastingArrayEnd(length);
        return vo;
    }

    public VariableDescriptor getVariableDescriptorAsType(VariableDescriptor varDesc, String type) throws CDIException {
        Target target = (Target)varDesc.getTarget();
        Thread thread = (Thread)varDesc.getThread();
        StackFrame frame = (StackFrame)varDesc.getStackFrame();
        String name = varDesc.getName();
        String fullName = varDesc.getFullName();
        int pos = varDesc.getPosition();
        int depth = varDesc.getStackDepth();
        StackFrame f = frame;
        if (f == null) {
            if (thread != null) {
                f = thread.getCurrentStackFrame();
            } else {
                Thread t = (Thread)target.getCurrentThread();
                f = t.getCurrentStackFrame();
            }
        }
        this.checkType(f, type);
        VariableDescriptor vo = null;
        if (varDesc instanceof ArgumentDescriptor || varDesc instanceof Argument) {
            vo = new ArgumentDescriptor(target, thread, frame, name, fullName, pos, depth);
        } else if (varDesc instanceof LocalVariableDescriptor || varDesc instanceof LocalVariable) {
            vo = new LocalVariableDescriptor(target, thread, frame, name, fullName, pos, depth);
        } else if (varDesc instanceof GlobalVariableDescriptor || varDesc instanceof GlobalVariable) {
            vo = new GlobalVariableDescriptor(target, thread, frame, name, fullName, pos, depth);
        } else if (varDesc instanceof ThreadStorageDescriptor || varDesc instanceof ThreadStorage) {
            vo = new ThreadStorageDescriptor(target, thread, frame, name, fullName, pos, depth);
        } else if (varDesc instanceof RegisterDescriptor || varDesc instanceof Register) {
            vo = new RegisterDescriptor(target, thread, frame, name, fullName, pos, depth);
        } else {
            throw new CDIException(CdiResources.getString("cdi.VariableManager.Unknown_variable_object"));
        }
        String[] castings = varDesc.getCastingTypes();
        if (castings == null) {
            castings = new String[]{type};
        } else {
            String[] temp = new String[castings.length + 1];
            System.arraycopy(castings, 0, temp, 0, castings.length);
            temp[castings.length] = type;
            castings = temp;
        }
        vo.setCastingTypes(castings);
        return vo;
    }

    public Variable createVariable(VariableDescriptor varDesc) throws CDIException {
        if (varDesc instanceof ArgumentDescriptor) {
            return this.createArgument((ArgumentDescriptor)varDesc);
        }
        if (varDesc instanceof LocalVariableDescriptor) {
            return this.createLocalVariable((LocalVariableDescriptor)varDesc);
        }
        if (varDesc instanceof GlobalVariableDescriptor) {
            return this.createGlobalVariable((GlobalVariableDescriptor)varDesc);
        }
        if (varDesc instanceof RegisterDescriptor) {
            RegisterManager regMgr = ((Session)this.getSession()).getRegisterManager();
            return regMgr.createRegister((RegisterDescriptor)varDesc);
        }
        if (varDesc instanceof ThreadStorageDescriptor) {
            return this.createThreadStorage((ThreadStorageDescriptor)varDesc);
        }
        throw new CDIException(CdiResources.getString("cdi.VariableManager.Unknown_variable_object"));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Argument createArgument(ArgumentDescriptor argDesc) throws CDIException {
        Variable variable = this.findVariable(argDesc);
        Argument argument = null;
        if (variable != null && variable instanceof Argument) {
            argument = (Argument)variable;
        }
        if (argument != null) return argument;
        String name = argDesc.getQualifiedName();
        StackFrame stack = (StackFrame)argDesc.getStackFrame();
        Target target = (Target)argDesc.getTarget();
        Thread currentThread = (Thread)target.getCurrentThread();
        StackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.lockTarget();
        try {
            try {
                target.setCurrentThread(stack.getThread(), false);
                ((Thread)stack.getThread()).setCurrentStackFrame(stack, false);
                MISession mi = target.getMISession();
                CommandFactory factory = mi.getCommandFactory();
                MIVarCreate var = factory.createMIVarCreate(name);
                mi.postCommand(var, -1L);
                argument = new Argument(argDesc, var);
                List variablesList = this.getVariablesList(target);
                variablesList.add(argument);
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            target.releaseTarget();
            throw throwable;
        }
        {
            Object var13_16 = null;
        }
        target.setCurrentThread(currentThread, false);
        currentThread.setCurrentStackFrame(currentFrame, false);
        target.releaseTarget();
        return argument;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDIArgumentDescriptor[] getArgumentDescriptors(StackFrame frame) throws CDIException {
        ArrayList<ArgumentDescriptor> argObjects = new ArrayList<ArgumentDescriptor>();
        Target target = (Target)frame.getTarget();
        Thread currentThread = (Thread)target.getCurrentThread();
        StackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.lockTarget();
        try {
            try {
                target.setCurrentThread(frame.getThread(), false);
                ((Thread)frame.getThread()).setCurrentStackFrame(frame, false);
                MISession mi = target.getMISession();
                CommandFactory factory = mi.getCommandFactory();
                int depth = frame.getThread().getStackFrameCount();
                int level = frame.getLevel();
                int miLevel = depth - level;
                MIStackListArguments listArgs = factory.createMIStackListArguments(false, miLevel, miLevel);
                MIArg[] args = null;
                mi.postCommand(listArgs);
                MIStackListArgumentsInfo info = listArgs.getMIStackListArgumentsInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                MIFrame[] miFrames = info.getMIFrames();
                if (miFrames != null && miFrames.length == 1) {
                    args = miFrames[0].getArgs();
                }
                if (args != null) {
                    int i = 0;
                    while (i < args.length) {
                        ArgumentDescriptor arg = new ArgumentDescriptor(target, null, frame, args[i].getName(), null, args.length - i, level);
                        argObjects.add(arg);
                        ++i;
                    }
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            target.releaseTarget();
            throw throwable;
        }
        {
            Object var17_20 = null;
        }
        target.setCurrentThread(currentThread, false);
        currentThread.setCurrentStackFrame(currentFrame, false);
        target.releaseTarget();
        return argObjects.toArray(new ICDIArgumentDescriptor[0]);
    }

    public GlobalVariableDescriptor getGlobalVariableDescriptor(Target target, String filename, String function, String name) throws CDIException {
        if (filename == null) {
            filename = new String();
        }
        if (function == null) {
            function = new String();
        }
        if (name == null) {
            name = new String();
        }
        StringBuffer buffer = new StringBuffer();
        if (filename.length() > 0) {
            buffer.append('\'').append(filename).append('\'').append("::");
        }
        if (function.length() > 0) {
            buffer.append(function).append("::");
        }
        buffer.append(name);
        return new GlobalVariableDescriptor(target, null, null, buffer.toString(), null, 0, 0);
    }

    public GlobalVariable createGlobalVariable(GlobalVariableDescriptor varDesc) throws CDIException {
        Variable variable = this.findVariable(varDesc);
        GlobalVariable global = null;
        if (variable instanceof GlobalVariable) {
            global = (GlobalVariable)variable;
        }
        if (global == null) {
            String name = varDesc.getQualifiedName();
            Target target = (Target)varDesc.getTarget();
            try {
                MISession mi = target.getMISession();
                CommandFactory factory = mi.getCommandFactory();
                MIVarCreate var = factory.createMIVarCreate(name);
                mi.postCommand(var, -1L);
                global = new GlobalVariable(varDesc, var);
                List variablesList = this.getVariablesList(target);
                variablesList.add(global);
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        return global;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDILocalVariableDescriptor[] getLocalVariableDescriptors(StackFrame frame) throws CDIException {
        ArrayList<LocalVariableDescriptor> varObjects = new ArrayList<LocalVariableDescriptor>();
        Target target = (Target)frame.getTarget();
        Thread currentThread = (Thread)target.getCurrentThread();
        StackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.lockTarget();
        try {
            try {
                target.setCurrentThread(frame.getThread(), false);
                ((Thread)frame.getThread()).setCurrentStackFrame(frame, false);
                MISession mi = target.getMISession();
                CommandFactory factory = mi.getCommandFactory();
                int level = frame.getLevel();
                MIArg[] args = null;
                MIStackListLocals locals = factory.createMIStackListLocals(false);
                mi.postCommand(locals);
                MIStackListLocalsInfo info = locals.getMIStackListLocalsInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                args = info.getLocals();
                if (args != null) {
                    int i = 0;
                    while (i < args.length) {
                        LocalVariableDescriptor varObj = new LocalVariableDescriptor(target, null, frame, args[i].getName(), null, args.length - i, level);
                        varObjects.add(varObj);
                        ++i;
                    }
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            target.releaseTarget();
            throw throwable;
        }
        {
            Object var14_17 = null;
        }
        target.setCurrentThread(currentThread, false);
        currentThread.setCurrentStackFrame(currentFrame, false);
        target.releaseTarget();
        return varObjects.toArray(new ICDILocalVariableDescriptor[0]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LocalVariable createLocalVariable(LocalVariableDescriptor varDesc) throws CDIException {
        Variable variable = this.findVariable(varDesc);
        LocalVariable local = null;
        if (variable instanceof LocalVariable) {
            local = (LocalVariable)variable;
        }
        if (local != null) return local;
        String name = varDesc.getQualifiedName();
        StackFrame stack = (StackFrame)varDesc.getStackFrame();
        Target target = (Target)varDesc.getTarget();
        Thread currentThread = (Thread)target.getCurrentThread();
        StackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.lockTarget();
        try {
            try {
                target.setCurrentThread(stack.getThread(), false);
                ((Thread)stack.getThread()).setCurrentStackFrame(stack, false);
                MISession mi = target.getMISession();
                CommandFactory factory = mi.getCommandFactory();
                MIVarCreate var = factory.createMIVarCreate(name);
                mi.postCommand(var, -1L);
                local = new LocalVariable(varDesc, var);
                List variablesList = this.getVariablesList(target);
                variablesList.add(local);
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            target.releaseTarget();
            throw throwable;
        }
        {
            Object var13_16 = null;
        }
        target.setCurrentThread(currentThread, false);
        currentThread.setCurrentStackFrame(currentFrame, false);
        target.releaseTarget();
        return local;
    }

    public ICDIThreadStorageDescriptor[] getThreadStorageDescriptors(Thread thread) throws CDIException {
        return new ICDIThreadStorageDescriptor[0];
    }

    public ThreadStorage createThreadStorage(ThreadStorageDescriptor desc) throws CDIException {
        throw new CDIException(CdiResources.getString("cdi.VariableManager.Unknown_variable_object"));
    }

    public void destroyVariable(Variable variable) throws CDIException {
        Target target = (Target)variable.getTarget();
        MISession mi = target.getMISession();
        List varList = this.getVariablesList(target);
        if (varList.contains(variable)) {
            this.removeMIVar(mi, variable.getMIVar());
        }
        MIVarDeletedEvent del = new MIVarDeletedEvent(mi, variable.getMIVar().getVarName());
        mi.fireEvent(del);
    }

    public void destroyAllVariables(Target target) throws CDIException {
        Variable[] variables = this.getVariables(target);
        MISession mi = target.getMISession();
        int i = 0;
        while (i < variables.length) {
            this.removeMIVar(mi, variables[i].getMIVar());
            MIVarDeletedEvent del = new MIVarDeletedEvent(mi, variables[i].getMIVar().getVarName());
            mi.fireEvent(del);
            ++i;
        }
    }

    public void update(Target target) throws CDIException {
        int highLevel = 0;
        int lowLevel = 0;
        ArrayList<MIEvent> eventList = new ArrayList<MIEvent>();
        MISession mi = target.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        Variable[] vars = this.getVariables(target);
        ICDIStackFrame[] frames = null;
        StackFrame currentStack = null;
        Thread currentThread = (Thread)target.getCurrentThread();
        if (currentThread != null) {
            currentStack = currentThread.getCurrentStackFrame();
            if (currentStack != null) {
                highLevel = currentStack.getLevel();
            }
            if (highLevel > this.MAX_STACK_DEPTH) {
                highLevel = this.MAX_STACK_DEPTH;
            }
            if ((lowLevel = highLevel - this.MAX_STACK_DEPTH) < 0) {
                lowLevel = 0;
            }
            frames = currentThread.getStackFrames(0, highLevel);
        }
        int i = 0;
        while (i < vars.length) {
            Variable variable = vars[i];
            if (this.isVariableNeedsToBeUpdate(variable, currentStack, frames, lowLevel)) {
                String varName = variable.getMIVar().getVarName();
                MIVarChange[] changes = this.noChanges;
                MIVarUpdate update = factory.createMIVarUpdate(varName);
                try {
                    mi.postCommand(update);
                    MIVarUpdateInfo info = update.getMIVarUpdateInfo();
                    if (info == null) {
                        throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                    }
                    changes = info.getMIVarChanges();
                }
                catch (MIException mIException) {
                    eventList.add(new MIVarDeletedEvent(mi, varName));
                }
                variable.setUpdated(true);
                int j = 0;
                while (j < changes.length) {
                    String n = changes[j].getVarName();
                    if (changes[j].isInScope()) {
                        eventList.add(new MIVarChangedEvent(mi, n));
                    } else {
                        this.destroyVariable(variable);
                        eventList.add(new MIVarDeletedEvent(mi, n));
                    }
                    ++j;
                }
            } else {
                variable.setUpdated(false);
            }
            ++i;
        }
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        mi.fireEvents(events);
    }

    public void update(Variable variable) throws CDIException {
        Target target = (Target)variable.getTarget();
        MISession mi = target.getMISession();
        ArrayList eventList = new ArrayList();
        this.update(target, variable, eventList);
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        mi.fireEvents(events);
    }

    public void update(Target target, Variable variable, List eventList) throws CDIException {
        MISession mi = target.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        String varName = variable.getMIVar().getVarName();
        MIVarChange[] changes = this.noChanges;
        MIVarUpdate update = factory.createMIVarUpdate(varName);
        try {
            mi.postCommand(update);
            MIVarUpdateInfo info = update.getMIVarUpdateInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            changes = info.getMIVarChanges();
        }
        catch (MIException mIException) {
            eventList.add(new MIVarDeletedEvent(mi, varName));
        }
        variable.setUpdated(true);
        int j = 0;
        while (j < changes.length) {
            String n = changes[j].getVarName();
            if (changes[j].isInScope()) {
                eventList.add(new MIVarChangedEvent(mi, n));
            } else {
                this.destroyVariable(variable);
                eventList.add(new MIVarDeletedEvent(mi, n));
            }
            ++j;
        }
    }

    boolean isVariableNeedsToBeUpdate(Variable variable, ICDIStackFrame current, ICDIStackFrame[] frames, int lowLevel) throws CDIException {
        ICDIStackFrame varStack = variable.getStackFrame();
        boolean inScope = false;
        if (current == null || frames == null) {
            return false;
        }
        if (varStack == null) {
            return true;
        }
        if (varStack.equals(current)) {
            return true;
        }
        if (varStack.getLevel() >= lowLevel) {
            int i = 0;
            while (i < frames.length) {
                if (varStack.equals(frames[i])) {
                    inScope = true;
                }
                ++i;
            }
        } else {
            inScope = true;
        }
        return !inScope;
    }
}

