/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.importexecutable;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.cdt.debug.ui.importexecutable.AbstractImportExecutableWizard;
import org.eclipse.cdt.debug.ui.importexecutable.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImportExecutablePageOne
extends WizardPage {
    private static String previouslyBrowsedDirectory = "";
    private Text multipleExecutablePathField;
    private CheckboxTreeViewer executablesViewer;
    private File[] executables = new File[0];
    private String previouslySearchedDirectory;
    private Text singleExecutablePathField;
    private boolean selectSingleFile = true;
    private Button selectSingleButton;
    private Button selectSingleBrowseButton;
    private Button selectMultipleButton;
    private Button selectMultipleBrowseButton;
    private Button selectAll;
    private Button deselectAll;
    private Label selectMultipleTitle;
    private AbstractImportExecutableWizard wizard;

    public ImportExecutablePageOne(AbstractImportExecutableWizard wizard) {
        super("ImportApplicationPageOne");
        this.wizard = wizard;
        this.setPageComplete(false);
        this.setTitle(wizard.getPageOneTitle());
        this.setDescription(wizard.getPageOneDescription());
    }

    private void checkControlState() {
        this.selectSingleFile = this.selectSingleButton.getSelection();
        this.singleExecutablePathField.setEnabled(this.selectSingleFile);
        this.selectSingleBrowseButton.setEnabled(this.selectSingleFile);
        this.multipleExecutablePathField.setEnabled(!this.selectSingleFile);
        this.selectMultipleBrowseButton.setEnabled(!this.selectSingleFile);
        this.selectAll.setEnabled(!this.selectSingleFile);
        this.deselectAll.setEnabled(!this.selectSingleFile);
        this.selectMultipleTitle.setEnabled(!this.selectSingleFile);
    }

    private boolean collectExecutableFiles(Collection files, File directory, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(directory.getPath());
        File[] contents = directory.listFiles();
        int i = 0;
        while (i < contents.length) {
            File file = contents[i];
            if (file.isFile() && this.wizard.isExecutableFile(file)) {
                files.add(file);
            }
            ++i;
        }
        i = 0;
        while (i < contents.length) {
            if (contents[i].isDirectory()) {
                this.collectExecutableFiles(files, contents[i], monitor);
            }
            ++i;
        }
        return true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        Composite selectExecutableGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        selectExecutableGroup.setLayout((Layout)layout);
        selectExecutableGroup.setLayoutData((Object)new GridData(768));
        this.createSelectExecutable(selectExecutableGroup);
        this.createExecutablesRoot(selectExecutableGroup);
        this.createExecutablesList(workArea);
        Dialog.applyDialogFont((Control)workArea);
        this.selectSingleButton.setSelection(true);
        this.checkControlState();
    }

    private void createExecutablesList(Composite workArea) {
        this.selectMultipleTitle = new Label(workArea, 0);
        this.selectMultipleTitle.setText(this.wizard.getExecutableListLabel());
        Composite listComposite = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(1808));
        this.executablesViewer = new CheckboxTreeViewer(listComposite, 2048);
        GridData listData = new GridData(1808);
        this.executablesViewer.getControl().setLayoutData((Object)listData);
        this.executablesViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return ImportExecutablePageOne.this.executables;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.executablesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((File)element).getName();
            }
        });
        this.executablesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ImportExecutablePageOne.this.setPageComplete(ImportExecutablePageOne.this.executablesViewer.getCheckedElements().length > 0);
            }
        });
        this.executablesViewer.setInput((Object)this);
        this.createSelectionButtons(listComposite);
    }

    private void createExecutablesRoot(Composite workArea) {
        this.selectMultipleButton = new Button(workArea, 16);
        this.selectMultipleButton.setText(Messages.ImportExecutablePageOne_SearchDirectory);
        this.selectMultipleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExecutablePageOne.this.checkControlState();
                if (!ImportExecutablePageOne.this.selectSingleFile) {
                    ImportExecutablePageOne.this.singleExecutablePathField.setText("");
                    ImportExecutablePageOne.this.noFilesSelected();
                }
            }
        });
        this.multipleExecutablePathField = new Text(workArea, 2048);
        this.multipleExecutablePathField.setLayoutData((Object)new GridData(768));
        this.selectMultipleBrowseButton = new Button(workArea, 8);
        this.selectMultipleBrowseButton.setText(Messages.ImportExecutablePageOne_Browse);
        this.setButtonLayoutData(this.selectMultipleBrowseButton);
        this.selectMultipleBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExecutablePageOne.this.handleLocationBrowseButtonPressed();
            }
        });
        this.multipleExecutablePathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ImportExecutablePageOne.this.updateExecutablesList(ImportExecutablePageOne.this.multipleExecutablePathField.getText().trim());
            }
        });
    }

    private void createSelectExecutable(Composite workArea) {
        this.selectSingleButton = new Button(workArea, 16);
        this.selectSingleButton.setText(Messages.ImportExecutablePageOne_SelectExecutable);
        this.selectSingleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExecutablePageOne.this.checkControlState();
                if (ImportExecutablePageOne.this.selectSingleFile) {
                    ImportExecutablePageOne.this.multipleExecutablePathField.setText("");
                    ImportExecutablePageOne.this.noFilesSelected();
                }
            }
        });
        this.singleExecutablePathField = new Text(workArea, 2048);
        this.singleExecutablePathField.setData("name", (Object)"singleExecutablePathField");
        this.singleExecutablePathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportExecutablePageOne.this.setErrorMessage(null);
                ImportExecutablePageOne.this.setPageComplete(false);
                String path = ImportExecutablePageOne.this.singleExecutablePathField.getText();
                if (path.length() > 0) {
                    File testFile = new File(path);
                    if (testFile.exists()) {
                        if (ImportExecutablePageOne.this.wizard.isExecutableFile(testFile)) {
                            ImportExecutablePageOne.this.executables = new File[1];
                            ((ImportExecutablePageOne)ImportExecutablePageOne.this).executables[0] = testFile;
                            ImportExecutablePageOne.this.setPageComplete(true);
                        } else {
                            ImportExecutablePageOne.this.setErrorMessage(Messages.ImportExecutablePageOne_NoteAnEXE);
                        }
                    } else {
                        ImportExecutablePageOne.this.setErrorMessage(Messages.ImportExecutablePageOne_NoSuchFile);
                    }
                }
            }
        });
        this.singleExecutablePathField.setLayoutData((Object)new GridData(768));
        this.selectSingleBrowseButton = new Button(workArea, 8);
        this.selectSingleBrowseButton.setText(Messages.ImportExecutablePageOne_Browse);
        this.setButtonLayoutData(this.selectSingleBrowseButton);
        this.selectSingleBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ImportExecutablePageOne.this.getShell(), 0);
                ImportExecutablePageOne.this.wizard.setupFileDialog(dialog);
                String res = dialog.open();
                if (res != null) {
                    if (Platform.getOS().equals("macosx") && res.endsWith(".app")) {
                        Path macPath = new Path(res);
                        res = String.valueOf(res) + "/Contents/MacOS/" + macPath.lastSegment();
                        res = res.substring(0, res.length() - 4);
                    }
                    ImportExecutablePageOne.this.singleExecutablePathField.setText(res);
                }
            }
        });
    }

    private void createSelectionButtons(Composite listComposite) {
        Composite buttonsComposite = new Composite(listComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(2));
        this.selectAll = new Button(buttonsComposite, 8);
        this.selectAll.setText(Messages.ImportExecutablePageOne_SelectAll);
        this.selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExecutablePageOne.this.executablesViewer.setCheckedElements((Object[])ImportExecutablePageOne.this.executables);
                ImportExecutablePageOne.this.setPageComplete(ImportExecutablePageOne.this.executables.length > 0);
            }
        });
        this.setButtonLayoutData(this.selectAll);
        this.deselectAll = new Button(buttonsComposite, 8);
        this.deselectAll.setText(Messages.ImportExecutablePageOne_DeselectAll);
        this.deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExecutablePageOne.this.executablesViewer.setCheckedElements(new Object[0]);
                ImportExecutablePageOne.this.setPageComplete(false);
            }
        });
        this.setButtonLayoutData(this.deselectAll);
    }

    public String[] getSelectedExecutables() {
        String[] selectedExecutablePaths = new String[]{};
        if (this.selectSingleFile) {
            if (this.executables.length > 0) {
                selectedExecutablePaths = new String[]{this.executables[0].getAbsolutePath()};
            }
        } else {
            Object[] checkedFiles = this.executablesViewer.getCheckedElements();
            selectedExecutablePaths = new String[checkedFiles.length];
            int i = 0;
            while (i < checkedFiles.length) {
                selectedExecutablePaths[i] = ((File)checkedFiles[i]).getAbsolutePath();
                ++i;
            }
        }
        return selectedExecutablePaths;
    }

    protected void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.multipleExecutablePathField.getShell());
        dialog.setMessage(Messages.ImportExecutablePageOne_SelectADirectory);
        String dirName = this.multipleExecutablePathField.getText().trim();
        if (dirName.length() == 0) {
            dirName = previouslyBrowsedDirectory;
        }
        if (dirName.length() > 0 && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            previouslyBrowsedDirectory = selectedDirectory;
            this.multipleExecutablePathField.setText(previouslyBrowsedDirectory);
            this.updateExecutablesList(selectedDirectory);
        }
    }

    protected void noFilesSelected() {
        this.executables = new File[0];
        this.executablesViewer.refresh(true);
        this.executablesViewer.setCheckedElements((Object[])this.executables);
        this.previouslySearchedDirectory = "";
        this.setPageComplete(false);
    }

    protected void updateExecutablesList(final String path) {
        if (path == null || path.length() == 0) {
            return;
        }
        if (this.previouslySearchedDirectory != null && this.previouslySearchedDirectory.equals(path)) {
            return;
        }
        this.previouslySearchedDirectory = path;
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.ImportExecutablePageOne_Searching, 100);
                    File directory = new File(path);
                    ImportExecutablePageOne.this.executables = new File[0];
                    monitor.worked(10);
                    if (directory.isDirectory()) {
                        ArrayList files = new ArrayList();
                        if (!ImportExecutablePageOne.this.collectExecutableFiles(files, directory, monitor)) {
                            return;
                        }
                        Iterator filesIterator = files.iterator();
                        ImportExecutablePageOne.this.executables = new File[files.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask(Messages.ImportExecutablePageOne_ProcessingResults);
                        while (filesIterator.hasNext()) {
                            File file;
                            ((ImportExecutablePageOne)ImportExecutablePageOne.this).executables[index] = file = (File)filesIterator.next();
                            ++index;
                        }
                    } else {
                        monitor.worked(60);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        this.executablesViewer.refresh(true);
        this.executablesViewer.setCheckedElements((Object[])this.executables);
        this.setPageComplete(this.executables.length > 0);
    }
}

