/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.internal.envvar.DefaultContextInfo;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.envvar.IContextInfo;
import org.eclipse.cdt.managedbuilder.internal.ui.EnvironmentBlock;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildPropertyPage;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.ui.dialogs.ICOptionPage;
import org.eclipse.cdt.ui.dialogs.TabFolderOptionBlock;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class EnvironmentSetBlock
extends AbstractCOptionPage {
    private static final String PREFIX = "EnvironmentSetBlock";
    private static final String LABEL = "EnvironmentSetBlock.label";
    private static final String ENVIRONMENT_LABEL = "EnvironmentSetBlock.label.environment";
    private static final String ENVIRONMENT_GROUP_LABEL = "EnvironmentSetBlock.label.environment.group";
    private static final String TAB = "EnvironmentSetBlock.label.tab";
    private static final String TAB_CONFIGURATION = "EnvironmentSetBlock.label.tab.configuration";
    private static final String TAB_PROJECT = "EnvironmentSetBlock.label.tab.project";
    private static final String TAB_WORKSPACE = "EnvironmentSetBlock.label.tab.workspace";
    private static final String TAB_ECLIPSE = "EnvironmentSetBlock.label.tab.eclipse";
    private EnvironmentTabFolder fEnvTabs;
    private EnvironmentBlock fEnvBlock;
    private ICOptionContainer fParentContainer;
    private UIEnvVarProvider fEnvProvider = null;

    public EnvironmentSetBlock(ICOptionContainer parent) {
        super(ManagedBuilderUIMessages.getResourceString(ENVIRONMENT_LABEL));
        super.setContainer(parent);
        this.fParentContainer = parent;
        if (this.fParentContainer instanceof BuildPropertyPage) {
            this.fEnvTabs = new EnvironmentTabFolder();
        } else {
            this.fEnvBlock = new EnvironmentBlock(this.fParentContainer, ManagedBuilderUIMessages.getResourceString(TAB_WORKSPACE), true, false);
            this.fEnvBlock.displayParentVariables(true);
        }
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        EnvironmentBlock[] tabs = this.getAllBlocks();
        if (tabs != null) {
            int i = 0;
            while (i < tabs.length) {
                tabs[i].performApply(monitor);
                ++i;
            }
        }
    }

    public void performDefaults() {
        EnvironmentBlock tab = this.getSelectedBlock();
        if (tab != null) {
            tab.performDefaults();
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updateValues();
        }
        if (this.fEnvTabs != null) {
            this.fEnvTabs.setVisible(visible);
        }
        super.setVisible(visible);
    }

    public void createControl(Composite parent) {
        Control ctrl = null;
        if (this.fEnvTabs != null) {
            Group group = new Group(parent, 0);
            group.setFont(parent.getFont());
            group.setText(ManagedBuilderUIMessages.getResourceString(ENVIRONMENT_GROUP_LABEL));
            group.setLayoutData((Object)new GridData(1808));
            GridLayout gl = new GridLayout();
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            group.setLayout((Layout)gl);
            Control tabs = this.fEnvTabs.createContents((Composite)group);
            GridData gd = new GridData(1808);
            tabs.setLayoutData((Object)gd);
            ctrl = group;
        } else if (this.fEnvBlock != null) {
            this.fEnvBlock.createControl(parent);
            ctrl = this.fEnvBlock.getControl();
            ctrl.setLayoutData((Object)new GridData(1808));
        }
        this.setControl(ctrl);
    }

    public void updateValues() {
        EnvironmentBlock tab = this.getSelectedBlock();
        this.updateContexts();
        if (tab != null) {
            tab.updateValues();
        }
    }

    public boolean isConfigSelectionAllowed() {
        EnvironmentBlock block = this.getSelectedBlock();
        if (block != null) {
            return block.getContext() instanceof IConfiguration;
        }
        return false;
    }

    public boolean isModified() {
        EnvironmentBlock[] tabs = this.getAllBlocks();
        int i = 0;
        while (i < tabs.length) {
            if (tabs[i].isModified()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setModified(boolean modified) {
        EnvironmentBlock[] tabs = this.getAllBlocks();
        int i = 0;
        while (i < tabs.length) {
            tabs[i].setModified(modified);
            ++i;
        }
    }

    protected EnvironmentBlock getSelectedBlock() {
        if (this.fEnvTabs != null) {
            return (EnvironmentBlock)this.fEnvTabs.getCurrentPage();
        }
        return this.fEnvBlock;
    }

    protected EnvironmentBlock[] getAllBlocks() {
        if (this.fEnvTabs != null) {
            return this.fEnvTabs.getTabs();
        }
        if (this.fEnvBlock != null) {
            return new EnvironmentBlock[]{this.fEnvBlock};
        }
        return new EnvironmentBlock[0];
    }

    protected void updateContexts() {
        if (this.fEnvTabs != null) {
            this.fEnvTabs.updateContexts();
        } else if (this.fEnvBlock != null) {
            this.fEnvBlock.setContext(ResourcesPlugin.getWorkspace());
        }
    }

    public EnvironmentVariableProvider getEnvironmentVariableProvider() {
        if (this.fEnvProvider == null) {
            this.fEnvProvider = new UIEnvVarProvider();
        }
        return this.fEnvProvider;
    }

    private class UIEnvVarContextInfo
    extends DefaultContextInfo {
        public UIEnvVarContextInfo(Object context) {
            super(context);
        }

        public IContextInfo getNext() {
            IContextInfo info = super.getNext();
            if (info != null) {
                EnvironmentBlock[] blocks = EnvironmentSetBlock.this.getAllBlocks();
                int i = 0;
                while (i < blocks.length) {
                    if (blocks[i].getContext() == info.getContext()) {
                        return blocks[i].getContextInfo();
                    }
                    ++i;
                }
                return new UIEnvVarContextInfo(info.getContext());
            }
            return null;
        }
    }

    private class UIEnvVarProvider
    extends EnvironmentVariableProvider {
        private UIEnvVarProvider() {
        }

        public IContextInfo getContextInfo(Object context) {
            EnvironmentBlock[] blocks = EnvironmentSetBlock.this.getAllBlocks();
            int i = 0;
            while (i < blocks.length) {
                if (blocks[i].getContext() == context) {
                    return blocks[i].getContextInfo();
                }
                ++i;
            }
            return new UIEnvVarContextInfo(context);
        }
    }

    private class EnvironmentTabFolder
    extends TabFolderOptionBlock {
        private EnvironmentBlock[] fFolderTabs;

        public EnvironmentTabFolder() {
            super(EnvironmentSetBlock.this.fParentContainer, false);
        }

        public EnvironmentBlock[] getTabs() {
            return this.fFolderTabs;
        }

        protected void addTabs() {
            if (EnvironmentSetBlock.this.fParentContainer instanceof BuildPropertyPage) {
                this.fFolderTabs = new EnvironmentBlock[2];
                this.fFolderTabs[0] = new EnvironmentBlock(EnvironmentSetBlock.this.fParentContainer, ManagedBuilderUIMessages.getResourceString(EnvironmentSetBlock.TAB_CONFIGURATION), true, true);
                this.addTab((ICOptionPage)this.fFolderTabs[0]);
                this.fFolderTabs[1] = new EnvironmentBlock(EnvironmentSetBlock.this.fParentContainer, ManagedBuilderUIMessages.getResourceString(EnvironmentSetBlock.TAB_PROJECT), true, true);
                this.addTab((ICOptionPage)this.fFolderTabs[1]);
            } else {
                this.fFolderTabs = new EnvironmentBlock[2];
                this.fFolderTabs[0] = new EnvironmentBlock(EnvironmentSetBlock.this.fParentContainer, ManagedBuilderUIMessages.getResourceString(EnvironmentSetBlock.TAB_WORKSPACE), true, true);
                this.addTab((ICOptionPage)this.fFolderTabs[0]);
                this.fFolderTabs[1] = new EnvironmentBlock(EnvironmentSetBlock.this.fParentContainer, ManagedBuilderUIMessages.getResourceString(EnvironmentSetBlock.TAB_ECLIPSE), false, false);
                this.addTab((ICOptionPage)this.fFolderTabs[1]);
            }
        }

        public void updateContexts() {
            if (this.fFolderTabs == null) {
                return;
            }
            if (EnvironmentSetBlock.this.fParentContainer instanceof BuildPropertyPage) {
                BuildPropertyPage page = (BuildPropertyPage)EnvironmentSetBlock.this.fParentContainer;
                if (page.getSelectedConfigurationClone() != null) {
                    this.fFolderTabs[1].setContext(page.getSelectedConfigurationClone().getManagedProject());
                }
                this.fFolderTabs[0].setContext(page.getSelectedConfigurationClone());
                this.fFolderTabs[0].setParentContextInfo(this.fFolderTabs[1].getContextInfo());
            } else {
                this.fFolderTabs[1].setContext(null);
                this.fFolderTabs[0].setContext(ResourcesPlugin.getWorkspace());
                this.fFolderTabs[0].setParentContextInfo(this.fFolderTabs[1].getContextInfo());
            }
        }

        public void setCurrentPage(ICOptionPage page) {
            ((EnvironmentBlock)page).updateValues();
            super.setCurrentPage(page);
        }
    }
}

