/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.resources.IPathEntryStore;
import org.eclipse.cdt.core.resources.IPathEntryStoreListener;
import org.eclipse.cdt.core.resources.PathEntryStoreChangedEvent;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.NewIncludesSymbolsTabBlock;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.PropertyPage;

public class IncludesSymbolsPropertyPage
extends PropertyPage
implements IStatusChangeListener,
IPathEntryStoreListener {
    private static final String PAGE_SETTINGS = "IncludeSysmbolsPropertyPage";
    private static final String INDEX = "pageIndex";
    NewIncludesSymbolsTabBlock fIncludesSymbolsBlock;
    IPathEntryStore fStore;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected Control createContents(Composite parent) {
        Control result;
        IProject project = this.getProject();
        if (project == null || !this.isCProject(project)) {
            result = this.createWithoutCProject(parent);
        } else if (!project.isOpen()) {
            result = this.createForClosedProject(parent);
        } else {
            try {
                this.fStore = CoreModel.getPathEntryStore((IProject)this.getProject());
                this.fStore.addPathEntryStoreListener((IPathEntryStoreListener)this);
            }
            catch (CoreException coreException) {}
            result = this.createWithCProject(parent, project);
        }
        Dialog.applyDialogFont((Control)result);
        this.noDefaultAndApplyButton();
        return result;
    }

    private IDialogSettings getSettings() {
        IDialogSettings cSettings = CUIPlugin.getDefault().getDialogSettings();
        IDialogSettings pageSettings = cSettings.getSection(PAGE_SETTINGS);
        if (pageSettings == null) {
            pageSettings = cSettings.addNewSection(PAGE_SETTINGS);
            pageSettings.put(INDEX, 3);
        }
        return pageSettings;
    }

    private Control createWithCProject(Composite parent, IProject project) {
        this.fIncludesSymbolsBlock = new NewIncludesSymbolsTabBlock(this, this.getSettings().getInt(INDEX));
        this.fIncludesSymbolsBlock.init(this.getCElement(), null);
        return this.fIncludesSymbolsBlock.createContents(parent);
    }

    private Control createWithoutCProject(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(CPathEntryMessages.getString("CPathsPropertyPage.no_C_project.message"));
        this.fIncludesSymbolsBlock = null;
        this.setValid(true);
        return label;
    }

    private Control createForClosedProject(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(CPathEntryMessages.getString("CPathsPropertyPage.closed_project.message"));
        this.fIncludesSymbolsBlock = null;
        this.setValid(true);
        return label;
    }

    public void dispose() {
        if (this.fStore != null) {
            this.fStore.removePathEntryStoreListener((IPathEntryStoreListener)this);
        }
    }

    public void setVisible(boolean visible) {
        if (this.fIncludesSymbolsBlock != null) {
            if (!visible) {
                if (this.fIncludesSymbolsBlock.hasChangesInDialog()) {
                    String title = CPathEntryMessages.getString("CPathsPropertyPage.unsavedchanges.title");
                    String message = CPathEntryMessages.getString("CPathsPropertyPage.unsavedchanges.message");
                    String[] buttonLabels = new String[]{CPathEntryMessages.getString("CPathsPropertyPage.unsavedchanges.button.save"), CPathEntryMessages.getString("CPathsPropertyPage.unsavedchanges.button.discard")};
                    MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 3, buttonLabels, 0);
                    int res = dialog.open();
                    if (res == 0) {
                        this.performOk();
                    } else if (res == 1) {
                        this.fIncludesSymbolsBlock.init(this.getCElement(), null);
                    }
                }
            } else if (!this.fIncludesSymbolsBlock.hasChangesInDialog() && this.fIncludesSymbolsBlock.hasChangesInCPathFile()) {
                this.fIncludesSymbolsBlock.init(this.getCElement(), null);
            }
        }
        super.setVisible(visible);
    }

    private IProject getProject() {
        IAdaptable adaptable = this.getElement();
        if (adaptable != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IResource resource = (IResource)adaptable.getAdapter((Class)clazz);
            return resource.getProject();
        }
        return null;
    }

    protected ICElement getCElement() {
        IAdaptable adaptable = this.getElement();
        if (adaptable != null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ICElement elem = (ICElement)adaptable.getAdapter((Class)clazz);
            return elem;
        }
        return null;
    }

    private boolean isCProject(IProject proj) {
        try {
            return proj.hasNature("org.eclipse.cdt.core.cnature");
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
            return false;
        }
    }

    public boolean performOk() {
        if (this.fIncludesSymbolsBlock != null) {
            this.getSettings().put(INDEX, this.fIncludesSymbolsBlock.getPageIndex());
            Shell shell = this.getControl().getShell();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IncludesSymbolsPropertyPage.this.fIncludesSymbolsBlock.configureCProject(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
            try {
                new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)op);
            }
            catch (InvocationTargetException e) {
                String title = CPathEntryMessages.getString("CPathsPropertyPage.error.title");
                String message = CPathEntryMessages.getString("CPathsPropertyPage.error.message");
                ExceptionHandler.handle(e, shell, title, message);
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    public boolean performCancel() {
        if (this.fIncludesSymbolsBlock != null) {
            this.getSettings().put(INDEX, this.fIncludesSymbolsBlock.getPageIndex());
        }
        return super.performCancel();
    }

    public void pathEntryStoreChanged(PathEntryStoreChangedEvent event) {
        Control control;
        if (event.hasContentChanged() && (control = this.getControl()) != null && !control.isDisposed()) {
            control.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Control control = IncludesSymbolsPropertyPage.this.getControl();
                    if (control != null && !control.isDisposed()) {
                        try {
                            IncludesSymbolsPropertyPage.this.fIncludesSymbolsBlock.init(IncludesSymbolsPropertyPage.this.getCElement(), IncludesSymbolsPropertyPage.this.fIncludesSymbolsBlock.getRawCPath());
                        }
                        catch (CModelException e) {
                            CUIPlugin.getDefault().log(e);
                        }
                    }
                }
            });
        }
    }
}

