/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.clangd;

import java.io.IOException;
import java.util.Optional;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.lsp.LspPlugin;
import org.eclipse.cdt.lsp.LspUtils;
import org.eclipse.cdt.lsp.internal.clangd.ClangdConfigurationManager;
import org.eclipse.cdt.lsp.internal.clangd.editor.LspEditorUiMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.yaml.snakeyaml.scanner.ScannerException;

public class CProjectChangeMonitor {
    private final ICProjectDescriptionListener listener = new ICProjectDescriptionListener(){

        public void handleEvent(CProjectDescriptionEvent event) {
            ICProjectDescription newCProjectDecription = event.getNewCProjectDescription();
            if (newCProjectDecription != null) {
                ICConfigurationDescription newConfig;
                IPath cwdBuilder;
                IProject project = event.getProject();
                boolean isEnabled = Optional.ofNullable(LspPlugin.getDefault()).map(LspPlugin::getCLanguageServerProvider).map(provider -> provider.isEnabledFor(project)).orElse(Boolean.FALSE);
                if (project != null && isEnabled && (cwdBuilder = (newConfig = newCProjectDecription.getDefaultSettingConfiguration()).getBuildSetting().getBuilderCWD()) != null) {
                    try {
                        String cwdString = CCorePlugin.getDefault().getCdtVariableManager().resolveValue(cwdBuilder.toOSString(), "", null, newConfig);
                        String projectLocation = project.getLocation().addTrailingSeparator().toOSString();
                        String databasePath = cwdString.replace(projectLocation, "");
                        try {
                            ClangdConfigurationManager.setCompilationDatabase(project, databasePath);
                        }
                        catch (ScannerException e) {
                            Status status = new Status(4, "org.eclipse.cdt.lsp.clangd", e.getMessage());
                            String configFile = ".clangd";
                            LspUtils.showErrorMessage((String)LspEditorUiMessages.CProjectChangeMonitor_yaml_scanner_error, (String)(String.valueOf(LspEditorUiMessages.CProjectChangeMonitor_yaml_scanner_error_message) + projectLocation + configFile), (Status)status);
                        }
                    }
                    catch (CoreException e) {
                        Platform.getLog(this.getClass()).log(e.getStatus());
                    }
                    catch (IOException e) {
                        Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    };

    public CProjectChangeMonitor start() {
        CCorePlugin.getDefault().getProjectDescriptionManager().addCProjectDescriptionListener(this.listener, 4);
        return this;
    }

    public void stop() {
        CCorePlugin.getDefault().getProjectDescriptionManager().removeCProjectDescriptionListener(this.listener);
    }
}

