/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.clangd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.yaml.snakeyaml.Yaml;

public class ClangdConfigurationManager {
    public static final String CLANGD_CONFIG_FILE_NAME = ".clangd";
    private static final String COMPILE_FLAGS = "CompileFlags";
    private static final String COMPILATTION_DATABASE = "CompilationDatabase";
    private static final String SET_COMPILATION_DB = "CompileFlags: {CompilationDatabase: %s}";

    public static void setCompilationDatabase(IProject project, String databasePath) throws IOException, CoreException {
        IFile configFile = project.getFile(CLANGD_CONFIG_FILE_NAME);
        if (ClangdConfigurationManager.createClangdConfigFile(configFile, project.getDefaultCharset(), databasePath, false)) {
            return;
        }
        Map data = null;
        Yaml yaml = new Yaml();
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream inputStream = configFile.getContents();){
            data = (Map)yaml.load(inputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (data == null) {
            ClangdConfigurationManager.createClangdConfigFile(configFile, project.getDefaultCharset(), databasePath, true);
            return;
        }
        Map map = (Map)data.get(COMPILE_FLAGS);
        if (map != null) {
            Object cdb = map.get(COMPILATTION_DATABASE);
            if (cdb != null && cdb instanceof String && cdb.equals(databasePath)) {
                return;
            }
            map.put(COMPILATTION_DATABASE, databasePath);
            data.put(COMPILE_FLAGS, map);
            Throwable throwable3 = null;
            Object var8_11 = null;
            try (PrintWriter yamlWriter = new PrintWriter(configFile.getLocation().toFile());){
                yaml.dump((Object)data, (Writer)yamlWriter);
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
        }
    }

    private static boolean createClangdConfigFile(IFile configFile, String charset, String databasePath, boolean overwriteContent) throws IOException, CoreException {
        if (!configFile.exists() || overwriteContent) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (ByteArrayInputStream data = new ByteArrayInputStream(String.format(SET_COMPILATION_DB, databasePath).getBytes(charset));){
                if (overwriteContent) {
                    configFile.setContents((InputStream)data, 2, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    configFile.create((InputStream)data, false, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return true;
        }
        return false;
    }
}

