/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.PreferenceMetadata;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public abstract class ConfigurationArea {
    protected final Map<PreferenceMetadata<Boolean>, Button> buttons = new HashMap<PreferenceMetadata<Boolean>, Button>();
    protected final List<Consumer<TypedEvent>> listeners = new ArrayList<Consumer<TypedEvent>>();
    protected final int columns;

    public ConfigurationArea(int columns) {
        this.columns = columns;
    }

    protected Group createGroup(Composite parent, String label, int numColumns) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        group.setText(label);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        return group;
    }

    protected Button createButton(PreferenceMetadata<Boolean> meta, Composite composite, int style, int horizontalIndent) {
        Button button = new Button(composite, style);
        button.setLayoutData((Object)GridDataFactory.fillDefaults().span(this.columns, 1).indent(horizontalIndent, 0).create());
        button.setData(meta);
        button.setText(meta.name());
        button.setToolTipText(meta.description());
        this.buttons.put(meta, button);
        return button;
    }

    public void addChangeListener(Consumer<TypedEvent> listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(Consumer<TypedEvent> listener) {
        this.listeners.add(listener);
    }

    public void changed(TypedEvent event) {
        this.listeners.forEach(c -> c.accept(event));
    }

    public void dispose() {
        this.listeners.clear();
        this.buttons.clear();
    }

    public abstract void load(Object var1, boolean var2);

    public abstract void store(IEclipsePreferences var1);
}

