/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.editor;

import java.net.URL;
import java.util.HashMap;
import org.eclipse.cdt.lsp.LspPlugin;
import org.eclipse.cdt.lsp.server.ICLanguageServerProvider;
import org.eclipse.cdt.ui.lsp.ICFileImageDescriptor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class LspEditorFileImageDescriptor
implements ICFileImageDescriptor {
    private final ICLanguageServerProvider cLanguageServerProvider = LspPlugin.getDefault().getCLanguageServerProvider();
    private static HashMap<String, ImageDescriptor> imageRegistry = new HashMap(2);
    private static final String ICONS_PATH = "$nl$/icons/";
    public static final String IMG_CFILE = "IMG_CFILE";
    public static final String IMG_CXXFILE = "IMG_CXXFILE";

    public LspEditorFileImageDescriptor() {
        this.declareRegistryImage(IMG_CFILE, "$nl$/icons/c.png");
        this.declareRegistryImage(IMG_CXXFILE, "$nl$/icons/cpp.png");
    }

    public ImageDescriptor getCImageDescriptor() {
        return imageRegistry.get(IMG_CFILE);
    }

    public ImageDescriptor getCXXImageDescriptor() {
        return imageRegistry.get(IMG_CXXFILE);
    }

    public ImageDescriptor getHeaderImageDescriptor() {
        return imageRegistry.get(IMG_CFILE);
    }

    public boolean isEnabled(IProject project) {
        return this.cLanguageServerProvider.isEnabledFor(project);
    }

    private final void declareRegistryImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.cdt.lsp");
        URL url = null;
        if (bundle != null && (url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null)) != null) {
            desc = ImageDescriptor.createFromURL((URL)url);
        }
        imageRegistry.put(key, desc);
    }
}

