/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.clangd;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.cdt.lsp.clangd.ClangdConfiguration;
import org.eclipse.cdt.lsp.clangd.ClangdFallbackFlags;
import org.eclipse.cdt.lsp.editor.Configuration;
import org.eclipse.cdt.lsp.editor.LanguageServerEnable;
import org.eclipse.cdt.lsp.server.ICLanguageServerProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ServiceCaller;

public final class ClangdLanguageServerProvider
implements ICLanguageServerProvider {
    private final ServiceCaller<ClangdConfiguration> configuration = new ServiceCaller(this.getClass(), ClangdConfiguration.class);
    private final ServiceCaller<Configuration> editorConfiguration = new ServiceCaller(this.getClass(), Configuration.class);

    public Object getInitializationOptions(URI rootUri) {
        ArrayList result = new ArrayList();
        ServiceCaller.callOnce(this.getClass(), ClangdFallbackFlags.class, f -> {
            boolean bl = result.add(f.getFallbackFlagsFromInitialUri(rootUri));
        });
        return result.stream().filter(Objects::nonNull).findFirst().orElse(null);
    }

    public List<String> getCommands(URI rootUri) {
        ArrayList<String> result = new ArrayList<String>();
        this.configuration.call(c -> {
            boolean bl = result.addAll(c.commands(rootUri));
        });
        return result;
    }

    public boolean isEnabledFor(IProject project) {
        boolean[] enabled = new boolean[1];
        this.editorConfiguration.call(c -> {
            boolean bl = ((LanguageServerEnable)c.options((Object)project)).isEnabledFor(project);
        });
        return enabled[0];
    }
}

