/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.clangd.editor;

import org.eclipse.cdt.lsp.LspUtils;
import org.eclipse.cdt.lsp.clangd.ClangdConfiguration;
import org.eclipse.cdt.lsp.clangd.ClangdMetadata;
import org.eclipse.cdt.lsp.clangd.ClangdOptions;
import org.eclipse.cdt.lsp.editor.Configuration;
import org.eclipse.cdt.lsp.editor.ConfigurationArea;
import org.eclipse.cdt.lsp.editor.EditorConfigurationPage;
import org.eclipse.cdt.lsp.internal.clangd.editor.ClangdConfigurationArea;
import org.eclipse.cdt.lsp.internal.clangd.editor.LspEditorUiMessages;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public final class ClangdConfigurationPage
extends EditorConfigurationPage {
    private final String id = "org.eclipse.cdt.lsp.clangd.editor.preferencePage";

    public void init(IWorkbench workbench) {
        this.configuration = (Configuration)workbench.getService(ClangdConfiguration.class);
        this.workspace = (IWorkspace)workbench.getService(IWorkspace.class);
    }

    protected Configuration getConfiguration() {
        return (Configuration)PlatformUI.getWorkbench().getService(ClangdConfiguration.class);
    }

    protected ConfigurationArea getConfigurationArea(Composite composite, boolean isProjectScope) {
        return new ClangdConfigurationArea(composite, (ClangdMetadata)this.configuration.metadata(), isProjectScope);
    }

    protected String getPreferenceId() {
        return "org.eclipse.cdt.lsp.clangd.editor.preferencePage";
    }

    public boolean performOk() {
        boolean configSettingsChanged = this.configurationSettingsChanged();
        boolean projectOptionsDifferFromWorkspace = this.projectOptionsDifferFromWorkspace();
        boolean done = super.performOk();
        if (done && this.isLsActive() && ((!this.projectScope().isPresent() || this.useProjectSettings()) && configSettingsChanged || projectOptionsDifferFromWorkspace)) {
            this.openRestartDialog();
        }
        return done;
    }

    private boolean configurationSettingsChanged() {
        return ((ClangdConfigurationArea)this.area).optionsChanged((ClangdOptions)this.configuration.options((Object)this.getElement()));
    }

    private boolean projectOptionsDifferFromWorkspace() {
        return this.hasProjectSpecificOptions() != this.useProjectSettings() && ((ClangdConfigurationArea)this.area).optionsChanged((ClangdOptions)this.configuration.options(null));
    }

    private boolean isLsActive() {
        return LspUtils.getLanguageServers().findAny().isPresent();
    }

    private void openRestartDialog() {
        MessageDialog dialog = new MessageDialog(this.getShell(), LspEditorUiMessages.LspEditorPreferencePage_restart_dialog_title, null, LspEditorUiMessages.LspEditorPreferencePage_restart_dialog_message, 2, new String[]{IDialogConstants.NO_LABEL, LspEditorUiMessages.LspEditorPreferencePage_restart_button}, 1);
        if (dialog.open() == 1) {
            LspUtils.getLanguageServers().forEach(w -> w.stop());
        }
    }

    protected boolean hasProjectSpecificOptions() {
        return this.projectScope().map(p -> p.getNode(this.configuration.qualifier())).map(n -> n.get(((ClangdMetadata)this.configuration.metadata()).clangdPath().identifer(), null)).isPresent();
    }
}

