/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.clangd.editor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.cdt.lsp.LspUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;

public class CompileCommandsMonitor {
    private static final String CDBF_SPECIFICATION_JSON_FILE = "compile_commands.json";
    private final IResourceChangeListener listener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            Set<IProject> projects = this.collectAffectedProjects(event);
            if (!projects.isEmpty()) {
                Arrays.stream(PlatformUI.getWorkbench().getWorkbenchWindows()).map(IWorkbenchWindow::getPages).flatMap(Arrays::stream).map(IWorkbenchPage::getEditorReferences).flatMap(Arrays::stream).flatMap(ref -> Stream.ofNullable(ref.getEditor(false))).forEach(editor -> {
                    IFile file = (IFile)Adapters.adapt((Object)editor.getEditorInput(), IFile.class);
                    if (this.isCppFile((IResource)file) && projects.contains(file.getProject())) {
                        CompileCommandsMonitor.refreshEditor(editor, file);
                    }
                });
            }
        }

        private boolean isCppFile(IResource resource) {
            if (resource instanceof IFile) {
                IContentType[] contentTypes = Platform.getContentTypeManager().findContentTypesFor(((IFile)resource).getName());
                return Arrays.stream(contentTypes).anyMatch(contentType -> LspUtils.isCContentType((String)contentType.getId()));
            }
            return false;
        }

        private Set<IProject> collectAffectedProjects(IResourceChangeEvent event) {
            HashSet<IProject> projects = new HashSet<IProject>();
            if (event.getDelta() != null && event.getType() == 1) {
                try {
                    event.getDelta().accept(delta -> {
                        if ((delta.getKind() == 1 || delta.getKind() == 2 || (delta.getFlags() & 0x100) != 0) && CompileCommandsMonitor.CDBF_SPECIFICATION_JSON_FILE.equals(delta.getResource().getName())) {
                            projects.add(delta.getResource().getProject());
                        }
                        return true;
                    });
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(e, "org.eclipse.cdt.lsp.clangd");
                }
            }
            return projects;
        }
    };
    private final IWorkspace workspace;

    public CompileCommandsMonitor(IWorkspace workspace) {
        this.workspace = workspace;
    }

    public CompileCommandsMonitor start() {
        this.workspace.addResourceChangeListener(this.listener);
        return this;
    }

    public void stop() {
        this.workspace.removeResourceChangeListener(this.listener);
    }

    private static void refreshEditor(IEditorPart editor, IFile file) {
        ITextViewer textViewer = (ITextViewer)Adapters.adapt((Object)editor, ITextViewer.class);
        UIJob.create((String)"Refresh Editors", monitor -> {
            if (textViewer.getDocument() == null) {
                return;
            }
            int rangeOffset = textViewer.getTopIndexStartOffset();
            int rangeLength = textViewer.getBottomIndexEndOffset() - rangeOffset;
            editor.getSite().getPage().reuseEditor((IReusableEditor)editor, editor.getEditorInput());
            textViewer.revealRange(rangeOffset, rangeLength);
        }).schedule(5000L);
    }
}

