/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.clangd.editor.handlers;

import java.net.URI;
import java.util.Optional;
import org.eclipse.cdt.lsp.services.ClangdLanguageServer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleSourceAndHeaderCommandHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        return this.execute(HandlerUtil.getActiveEditor((ExecutionEvent)event));
    }

    private Object execute(IEditorPart activeEditor) {
        IEditorPart innerEditor = Optional.ofNullable((IEditorPart)Adapters.adapt((Object)activeEditor, ITextEditor.class)).orElse(activeEditor);
        ToggleSourceAndHeaderCommandHandler.getUri(innerEditor).ifPresent(fileUri -> {
            IDocument document = LSPEclipseUtils.getDocument((IEditorInput)innerEditor.getEditorInput());
            LanguageServers.forDocument((IDocument)document).computeFirst(server -> server instanceof ClangdLanguageServer ? ((ClangdLanguageServer)server).switchSourceHeader(new TextDocumentIdentifier(fileUri.toString())) : null).thenAccept(otherFileUri -> otherFileUri.ifPresent(uri -> ToggleSourceAndHeaderCommandHandler.openEditor(innerEditor.getEditorSite().getPage(), URI.create(uri))));
        });
        return null;
    }

    private static Optional<URI> getUri(IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            return Optional.of(((IFileEditorInput)editor.getEditorInput()).getFile().getLocationURI());
        }
        if (editorInput instanceof IURIEditorInput) {
            return Optional.of(((IURIEditorInput)editorInput).getURI());
        }
        return Optional.empty();
    }

    private static void openEditor(IWorkbenchPage page, URI fileUri) {
        page.getWorkbenchWindow().getShell().getDisplay().asyncExec(() -> {
            try {
                IDE.openEditor((IWorkbenchPage)page, (URI)fileUri, (String)"org.eclipse.cdt.lsp.CEditor", (boolean)true);
            }
            catch (PartInitException e) {
                StatusManager.getManager().handle((CoreException)e, "org.eclipse.cdt.lsp.clangd");
            }
        });
    }
}

