/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.clangd.editor;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.eclipse.cdt.lsp.LspUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class CompileCommandsMonitor {
    private static final String CDBF_SPECIFICATION_JSON_FILE = "compile_commands.json";
    private static final long DEBOUNCE_DELAY = 2000L;
    private final IWorkspace workspace;
    private final Debouncer debouncer;
    private final IResourceChangeListener listener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            Set<IProject> affectedProjects = this.collectAffectedProjects(event);
            if (!affectedProjects.isEmpty() && this.getEditors().map(editor -> (IFile)Adapters.adapt((Object)editor.getEditorInput(), IFile.class)).anyMatch(file -> this.isCppFile((IResource)file) && affectedProjects.contains(file.getProject()))) {
                CompileCommandsMonitor.this.debouncer.run(() -> CompileCommandsMonitor.this.restartLanguageServers());
            }
        }

        private Stream<IEditorPart> getEditors() {
            return Arrays.stream(PlatformUI.getWorkbench().getWorkbenchWindows()).map(IWorkbenchWindow::getPages).flatMap(Arrays::stream).map(IWorkbenchPage::getEditorReferences).flatMap(Arrays::stream).flatMap(ref -> Stream.ofNullable(ref.getEditor(false)));
        }

        private boolean isCppFile(IResource resource) {
            if (resource instanceof IFile) {
                IContentType[] contentTypes = Platform.getContentTypeManager().findContentTypesFor(((IFile)resource).getName());
                return Arrays.stream(contentTypes).anyMatch(contentType -> LspUtils.isCContentType((String)contentType.getId()));
            }
            return false;
        }

        private Set<IProject> collectAffectedProjects(IResourceChangeEvent event) {
            HashSet<IProject> projects = new HashSet<IProject>();
            if (event.getDelta() != null && event.getType() == 1) {
                try {
                    event.getDelta().accept(delta -> {
                        if ((delta.getKind() == 1 || delta.getKind() == 2 || (delta.getFlags() & 0x100) != 0) && CompileCommandsMonitor.CDBF_SPECIFICATION_JSON_FILE.equals(delta.getResource().getName())) {
                            projects.add(delta.getResource().getProject());
                        }
                        return true;
                    });
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(e, "org.eclipse.cdt.lsp.clangd");
                }
            }
            return projects;
        }
    };

    public CompileCommandsMonitor(IWorkspace workspace) {
        this.workspace = workspace;
        this.debouncer = new Debouncer(2000L);
    }

    protected void restartLanguageServers() {
        LspUtils.getLanguageServers().forEach(w -> {
            try {
                w.restart();
            }
            catch (IOException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.cdt.lsp.clangd", "Could not restart language servers"), 1);
            }
        });
    }

    public CompileCommandsMonitor start() {
        this.workspace.addResourceChangeListener(this.listener);
        this.debouncer.start();
        return this;
    }

    public void stop() {
        this.workspace.removeResourceChangeListener(this.listener);
        this.debouncer.stop();
    }

    private static final class Debouncer {
        private long debounceDelay;
        private ScheduledExecutorService scheduler;
        private ScheduledFuture<?> debounceTimer;

        public Debouncer(long debounceDelay) {
            this.debounceDelay = debounceDelay;
        }

        public void run(Runnable runnable) {
            if (this.debounceTimer != null && !this.debounceTimer.isDone()) {
                this.debounceTimer.cancel(true);
            }
            this.debounceTimer = this.scheduler.schedule(runnable, this.debounceDelay, TimeUnit.MILLISECONDS);
        }

        public void start() {
            this.scheduler = Executors.newScheduledThreadPool(1);
        }

        public void stop() {
            this.scheduler.shutdown();
        }
    }
}

