/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.editor;

import java.util.Optional;
import org.eclipse.cdt.lsp.editor.Configuration;
import org.eclipse.cdt.lsp.editor.ConfigurationArea;
import org.eclipse.cdt.lsp.editor.EditorConfigurationArea;
import org.eclipse.cdt.lsp.editor.EditorMetadata;
import org.eclipse.cdt.lsp.editor.ResolveProjectScope;
import org.eclipse.cdt.lsp.internal.messages.LspUiMessages;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public class EditorConfigurationPage
extends PropertyPage
implements IWorkbenchPreferencePage {
    private final String id = "org.eclipse.cdt.lsp.editor.preferencePage";
    protected Configuration configuration;
    protected IWorkspace workspace;
    protected IWorkingCopyManager manager;
    private Link link;
    private Button specific;
    private Control control;
    protected ConfigurationArea area;

    public void init(IWorkbench workbench) {
        this.configuration = (Configuration)workbench.getService(Configuration.class);
        this.workspace = (IWorkspace)workbench.getService(IWorkspace.class);
    }

    public void setContainer(IPreferencePageContainer container) {
        super.setContainer(container);
        if (this.manager == null) {
            this.manager = Optional.ofNullable(container).filter(IWorkbenchPreferenceContainer.class::isInstance).map(IWorkbenchPreferenceContainer.class::cast).map(IWorkbenchPreferenceContainer::getWorkingCopyManager).orElseGet(WorkingCopyManager::new);
        }
        if (this.configuration == null) {
            this.configuration = this.getConfiguration();
        }
        if (this.workspace == null) {
            this.workspace = (IWorkspace)PlatformUI.getWorkbench().getService(IWorkspace.class);
        }
    }

    protected Configuration getConfiguration() {
        return (Configuration)PlatformUI.getWorkbench().getService(Configuration.class);
    }

    protected Label createDescriptionLabel(Composite parent) {
        if (this.projectScope().isPresent()) {
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
            composite.setLayoutData((Object)new GridData(768));
            this.specific = new Button(composite, 32);
            this.specific.setLayoutData((Object)new GridData(1, 128, true, false));
            this.specific.setText(LspUiMessages.LspEditorConfigurationPage_enable_project_specific);
            this.specific.setFont(JFaceResources.getDialogFont());
            this.specific.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.specificSelected()));
            this.link = this.createLink(composite, LspUiMessages.LspEditorConfigurationPage_configure_ws_specific);
            this.link.setLayoutData((Object)new GridData(0x1000008, 128, false, false));
            Label line = new Label(composite, 258);
            line.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            line.setFont(composite.getFont());
        }
        return super.createDescriptionLabel(parent);
    }

    private void specificSelected() {
        this.enableProjectSpecificSettings(this.specific.getSelection());
        this.refreshWidgets(this.configuration.options(this.getElement()));
    }

    private Link createLink(Composite composite, String text) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setText("<A>" + text + "</A>");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PreferencesUtil.createPreferenceDialogOn((Shell)EditorConfigurationPage.this.getShell(), (String)EditorConfigurationPage.this.getPreferenceId(), (String[])new String[]{"org.eclipse.cdt.lsp.editor.preferencePage", EditorConfigurationPage.this.getPreferenceId()}, null).open() == 0) {
                    EditorConfigurationPage.this.refreshWidgets(EditorConfigurationPage.this.configuration.options(EditorConfigurationPage.this.getElement()));
                }
            }
        });
        return link;
    }

    protected String getPreferenceId() {
        return "org.eclipse.cdt.lsp.editor.preferencePage";
    }

    protected Control createContents(Composite parent) {
        boolean isProjectScope = this.projectScope().isPresent();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        composite.setFont(parent.getFont());
        this.control = this.createPreferenceContent(composite, isProjectScope);
        this.control.setLayoutData((Object)new GridData(1808));
        if (isProjectScope) {
            this.enableProjectSpecificSettings(this.hasProjectSpecificOptions());
        }
        this.refreshWidgets(this.configuration.options(this.getElement()));
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected ConfigurationArea getConfigurationArea(Composite composite, boolean isProjectScope) {
        return new EditorConfigurationArea(composite, (EditorMetadata)this.configuration.metadata(), isProjectScope);
    }

    private Control createPreferenceContent(Composite parent, boolean isProjectScope) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        composite.setFont(parent.getFont());
        if (!isProjectScope) {
            this.createSpellingPreferencesLink(composite);
            Label line = new Label(composite, 258);
            line.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        }
        this.area = this.getConfigurationArea(composite, isProjectScope);
        return composite;
    }

    private Control createSpellingPreferencesLink(Composite parent) {
        Link link = new Link(parent, 0);
        link.setText(LspUiMessages.LspEditorConfigurationPage_spelling_link);
        link.addListener(13, event -> {
            PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)event.text, null, null);
        });
        link.setToolTipText(LspUiMessages.LspEditorConfigurationPage_spelling_link_tooltip);
        link.setLayoutData((Object)new GridData(4, 1, true, false));
        return link;
    }

    protected void refreshWidgets(Object options) {
        this.setErrorMessage(null);
        this.area.load(options, this.useProjectSettings() || !this.projectScope().isPresent());
    }

    protected Optional<ProjectScope> projectScope() {
        return new ResolveProjectScope(this.workspace).apply(this.getElement());
    }

    protected void performDefaults() {
        if (this.useProjectSettings()) {
            this.enableProjectSpecificSettings(false);
        }
        IEclipsePreferences prefs = this.manager.getWorkingCopy(this.scope().getNode(this.configuration.qualifier()));
        try {
            String[] stringArray = prefs.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                prefs.remove(key);
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            Platform.getLog(((Object)((Object)this)).getClass()).error("Unable to restore default values.", (Throwable)e);
        }
        this.refreshWidgets(this.configuration.defaults());
        super.performDefaults();
    }

    public boolean performOk() {
        IEclipsePreferences prefs;
        if (this.projectScope().isPresent()) {
            prefs = this.manager.getWorkingCopy(this.projectScope().get().getNode(this.configuration.qualifier()));
            if (!this.useProjectSettings()) {
                try {
                    String[] stringArray = prefs.keys();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String key = stringArray[n2];
                        prefs.remove(key);
                        ++n2;
                    }
                }
                catch (BackingStoreException e) {
                    Platform.getLog(((Object)((Object)this)).getClass()).error("Unable to reset project preferences.", (Throwable)e);
                }
                prefs = null;
            }
        } else {
            prefs = this.manager.getWorkingCopy(InstanceScope.INSTANCE.getNode(this.configuration.qualifier()));
        }
        if (prefs != null) {
            this.area.store(prefs);
        }
        try {
            this.manager.applyChanges();
        }
        catch (BackingStoreException e) {
            Platform.getLog(((Object)((Object)this)).getClass()).error("Unable to save preferences.", (Throwable)e);
            return false;
        }
        return true;
    }

    private IScopeContext scope() {
        return this.projectScope().map(IScopeContext.class::cast).orElse(InstanceScope.INSTANCE);
    }

    protected boolean hasProjectSpecificOptions() {
        return this.projectScope().map(p -> p.getNode(this.configuration.qualifier())).map(n -> n.get(((EditorMetadata)this.configuration.metadata()).preferLspEditor().identifer(), null)).isPresent();
    }

    protected boolean useProjectSettings() {
        return Optional.ofNullable(this.specific).map(s -> s.getSelection()).orElse(Boolean.FALSE);
    }

    protected void enableProjectSpecificSettings(boolean use) {
        this.specific.setSelection(use);
        this.updateLinkVisibility();
    }

    private void updateLinkVisibility() {
        Optional.ofNullable(this.link).filter(l -> !l.isDisposed()).ifPresent(l -> l.setEnabled(!this.useProjectSettings()));
    }

    public void dispose() {
        Optional.ofNullable(this.area).ifPresent(ConfigurationArea::dispose);
        super.dispose();
    }
}

