/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.clangd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.cdt.lsp.clangd.ClangdMetadata;
import org.eclipse.cdt.lsp.clangd.ClangdOptions;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.PreferenceMetadata;

final class ClangdPreferredOptions
implements ClangdOptions {
    private final String qualifier;
    private final IScopeContext[] scopes;
    private final ClangdMetadata metadata;

    ClangdPreferredOptions(String qualifier, IScopeContext[] scopes, ClangdMetadata metadata) {
        this.qualifier = Objects.requireNonNull(qualifier);
        this.scopes = Objects.requireNonNull(scopes);
        this.metadata = Objects.requireNonNull(metadata);
    }

    @Override
    public String clangdPath() {
        return this.stringValue(this.metadata.clangdPath());
    }

    @Override
    public boolean useTidy() {
        return this.booleanValue(this.metadata.useTidy());
    }

    @Override
    public boolean useBackgroundIndex() {
        return this.booleanValue(this.metadata.useBackgroundIndex());
    }

    @Override
    public String completionStyle() {
        return this.stringValue(this.metadata.completionStyle());
    }

    @Override
    public boolean prettyPrint() {
        return this.booleanValue(this.metadata.prettyPrint());
    }

    @Override
    public String queryDriver() {
        return this.stringValue(this.metadata.queryDriver());
    }

    @Override
    public List<String> additionalOptions() {
        String options = this.stringValue(this.metadata.additionalOptions());
        if (options.isBlank()) {
            return new ArrayList<String>();
        }
        return Arrays.asList(options.split("\\s+"));
    }

    private String stringValue(PreferenceMetadata<?> meta) {
        String actual = String.valueOf(meta.defaultValue());
        int i = this.scopes.length - 1;
        while (i >= 0) {
            IScopeContext scope = this.scopes[i];
            String previous = actual;
            actual = scope.getNode(this.qualifier).get(meta.identifer(), previous);
            --i;
        }
        return actual;
    }

    private boolean booleanValue(PreferenceMetadata<Boolean> meta) {
        return Optional.of(meta).map(this::stringValue).map(Boolean::valueOf).orElseGet(() -> meta.defaultValue());
    }
}

