/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ServiceCaller;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class LspUtils {
    public static boolean isCContentType(String id) {
        return id.startsWith("org.eclipse.cdt.core.c") && (id.endsWith("Source") || id.endsWith("Header"));
    }

    public static boolean isFileOpenedInLspEditor(URI uri) {
        if (uri == null) {
            return false;
        }
        List<IEditorReference> editors = LspUtils.getEditors();
        if (!editors.isEmpty()) {
            for (IEditorReference editor : editors) {
                IEditorInput editorInput = null;
                URI editorUnputURI = null;
                try {
                    editorInput = editor.getEditorInput();
                }
                catch (PartInitException e) {
                    Platform.getLog(LspUtils.class).error(e.getMessage(), (Throwable)e);
                    continue;
                }
                if (editorInput instanceof IURIEditorInput) {
                    editorUnputURI = ((IURIEditorInput)editorInput).getURI();
                } else if (editorInput instanceof FileEditorInput) {
                    editorUnputURI = ((FileEditorInput)editorInput).getFile().getLocationURI();
                }
                if (!uri.equals(editorUnputURI)) continue;
                return "org.eclipse.cdt.lsp.CEditor".equals(editor.getId()) && LspUtils.isLspEditorActive();
            }
            return LspUtils.isLspEditorActive();
        }
        return false;
    }

    public static boolean isFileOpenedInLspEditor(IEditorInput editorInput) {
        if (editorInput == null) {
            return false;
        }
        List<IEditorReference> editors = LspUtils.getEditors();
        if (!editors.isEmpty()) {
            for (IEditorReference editor : editors) {
                IEditorInput editorInputFromEditor = null;
                try {
                    editorInputFromEditor = editor.getEditorInput();
                }
                catch (PartInitException e) {
                    Platform.getLog(LspUtils.class).error(e.getMessage(), (Throwable)e);
                    continue;
                }
                if (!editorInput.equals(editorInputFromEditor)) continue;
                return "org.eclipse.cdt.lsp.CEditor".equals(editor.getEditor(true).getEditorSite().getId());
            }
            return LspUtils.isLspEditorActive();
        }
        return false;
    }

    public static List<IEditorReference> getEditors() {
        ArrayList<IEditorReference> editorsList = new ArrayList<IEditorReference>();
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference editor = iEditorReferenceArray[n6];
                    editorsList.add(editor);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return editorsList;
    }

    private static boolean isLspEditorActive() {
        IEditorPart activeEditor;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && activeWorkbenchWindow.getActivePage() != null && (activeEditor = activeWorkbenchWindow.getActivePage().getActiveEditor()) != null) {
            return "org.eclipse.cdt.lsp.CEditor".equals(activeEditor.getEditorSite().getId());
        }
        return false;
    }

    public static Optional<IProject> getProject(URI uri) {
        return LspUtils.getFile(uri).map(file -> file.getProject());
    }

    public static Optional<IFile> getFile(URI uri) {
        ArrayList found = new ArrayList();
        ServiceCaller.callOnce(LspUtils.class, IWorkspace.class, w -> Arrays.stream(w.getRoot().findFilesForLocationURI(uri)).forEach(found::add));
        return found.stream().findFirst();
    }

    public static Stream<LanguageServerWrapper> getLanguageServers() {
        return LanguageServiceAccessor.getStartedWrappers(null, null, (boolean)true).stream().filter(w -> "org.eclipse.cdt.lsp.server".equals(w.serverDefinition.id));
    }
}

