/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.editor;

import org.eclipse.cdt.lsp.editor.ConfigurationArea;
import org.eclipse.cdt.lsp.editor.EditorMetadata;
import org.eclipse.cdt.lsp.editor.EditorOptions;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.OsgiPreferenceMetadataStore;
import org.eclipse.core.runtime.preferences.PreferenceMetadata;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class SaveActionsConfigurationArea
extends ConfigurationArea {
    private final Button format;
    private final Button formatAll;
    private final Button formatEdited;

    public SaveActionsConfigurationArea(Composite parent, EditorMetadata metadata, boolean isProjectScope) {
        super(1);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(this.columns).create());
        this.format = this.createButton(metadata.formatOnSave(), composite, 32, 0);
        this.formatAll = this.createButton(metadata.formatAllLines(), composite, 16, 15);
        this.formatEdited = this.createButton(metadata.formatEditedLines(), composite, 16, 15);
        SelectionAdapter formatListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = SaveActionsConfigurationArea.this.format.getSelection();
                SaveActionsConfigurationArea.this.formatAll.setEnabled(selection);
                SaveActionsConfigurationArea.this.formatEdited.setEnabled(selection);
            }
        };
        this.format.addSelectionListener((SelectionListener)formatListener);
    }

    @Override
    public void load(Object options, boolean enable) {
        if (options instanceof EditorOptions var3_4) {
            this.format.setSelection(editorOptions.formatOnSave());
            this.formatAll.setSelection(editorOptions.formatAllLines());
            this.formatEdited.setSelection(editorOptions.formatEditedLines());
            this.format.setEnabled(enable);
            this.formatAll.setEnabled(enable && this.format.getSelection());
            this.formatEdited.setEnabled(enable && this.format.getSelection());
        }
    }

    @Override
    public void store(IEclipsePreferences prefs) {
        OsgiPreferenceMetadataStore store = new OsgiPreferenceMetadataStore(prefs);
        this.buttons.entrySet().forEach(e -> store.save((Object)((Button)e.getValue()).getSelection(), (PreferenceMetadata)e.getKey()));
    }
}

