/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.eclipse.cdt.lsp.ExistingResource;
import org.eclipse.cdt.lsp.InitialUri;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public final class InitialFileManager
implements InitialUri {
    private static final QualifiedName INITIAL_URI = new QualifiedName("org.eclipse.cdt.lsp", "initialUri");
    private URI uri;
    @Reference
    private IWorkspace workspace;

    @Override
    public synchronized void register(URI uri) {
        if (this.uri == null && new ExistingResource(this.workspace).apply(uri).isPresent()) {
            try {
                this.workspace.getRoot().setPersistentProperty(INITIAL_URI, uri.toString());
                this.uri = uri;
            }
            catch (CoreException e) {
                Platform.getLog(InitialFileManager.class).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public Optional<URI> find(URI root) {
        if (this.uri == null) {
            String initialUriString = null;
            try {
                initialUriString = this.workspace.getRoot().getPersistentProperty(INITIAL_URI);
                if (initialUriString != null) {
                    this.uri = new URI(initialUriString);
                }
            }
            catch (URISyntaxException | CoreException e) {
                Platform.getLog(InitialFileManager.class).error(e.getMessage(), e);
            }
        }
        return Optional.ofNullable(this.uri);
    }
}

