/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.server.enable;

import java.io.File;
import java.net.URI;
import java.util.Optional;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.lsp.ExistingResource;
import org.eclipse.cdt.lsp.InitialUri;
import org.eclipse.cdt.lsp.LspPlugin;
import org.eclipse.cdt.lsp.LspUtils;
import org.eclipse.cdt.lsp.server.ICLanguageServerProvider;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ServiceCaller;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.lsp4e.outline.SymbolsModel;

public class HasLanguageServerPropertyTester
extends PropertyTester {
    private final ICLanguageServerProvider cLanguageServerProvider = LspPlugin.getDefault().getCLanguageServerProvider();
    private final ServiceCaller<InitialUri> initial = new ServiceCaller(((Object)((Object)this)).getClass(), InitialUri.class);
    private final ServiceCaller<IWorkspace> workspace = new ServiceCaller(((Object)((Object)this)).getClass(), IWorkspace.class);

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (this.cLanguageServerProvider != null) {
            if (receiver instanceof URI) {
                URI uri = (URI)receiver;
                if (!this.validContentType(uri)) {
                    return false;
                }
                boolean isEnabled = this.enabledFor(uri);
                if (isEnabled) {
                    this.initial.call(iu -> iu.register(uri));
                }
                return isEnabled;
            }
            if (receiver instanceof ITranslationUnit) {
                return Optional.of((ITranslationUnit)receiver).map(ICElement::getCProject).map(ICProject::getProject).map(this.cLanguageServerProvider::isEnabledFor).orElse(Boolean.FALSE);
            }
            return receiver instanceof SymbolsModel.DocumentSymbolWithURI;
        }
        return false;
    }

    private boolean validContentType(URI uri) {
        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(new File(uri.getPath()).getName());
        if (contentType != null) {
            return LspUtils.isCContentType(contentType.getId());
        }
        return false;
    }

    private boolean enabledFor(URI uri) {
        boolean[] provider = new boolean[1];
        this.workspace.call(w -> {
            boolean bl = new ExistingResource((IWorkspace)w).apply(uri).map(IResource::getProject).map(this.cLanguageServerProvider::isEnabledFor).orElseGet(() -> LspUtils.isFileOpenedInLspEditor(uri));
        });
        return provider[0];
    }
}

