/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.ui.navigator;

import java.net.URI;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.lsp.LspUtils;
import org.eclipse.cdt.lsp.ui.navigator.FileBufferListenerAdapter;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class SymbolsManager
implements IDeferredWorkbenchAdapter {
    protected static final Object[] EMPTY = new Object[0];
    private final IFileBufferListener fileBufferListener = new FileBufferListenerAdapter(){

        @Override
        public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
            try {
                CompileUnit cachedCompileUnit;
                URI uri;
                if (isDirty && this.resourceExists(buffer) && this.isCElement(buffer.getContentType()) && (uri = LSPEclipseUtils.toUri((IFileBuffer)buffer)) != null && (cachedCompileUnit = SymbolsManager.this.getCompileUnit(uri)) != null) {
                    cachedCompileUnit.isDirty = true;
                }
            }
            catch (CoreException e) {
                Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
            }
        }

        private boolean resourceExists(IFileBuffer buffer) {
            return Optional.ofNullable(LSPEclipseUtils.getFile((IPath)buffer.getLocation())).map(file -> file.exists()).orElse(false);
        }

        private boolean isCElement(IContentType contentType) {
            if (contentType == null) {
                return false;
            }
            return LspUtils.isCContentType(contentType.getId());
        }
    };
    private volatile HashMap<URI, CompileUnit> cachedSymbols = new HashMap();
    public static final SymbolsManager INSTANCE = new SymbolsManager();

    public SymbolsManager() {
        FileBuffers.getTextFileBufferManager().addFileBufferListener(this.fileBufferListener);
    }

    public void dispose() {
        this.cachedSymbols.clear();
        FileBuffers.getTextFileBufferManager().removeFileBufferListener(this.fileBufferListener);
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        Object[] children = this.getCompileUnitElements(object);
        if (monitor.isCanceled() || children.length == 0) {
            return;
        }
        collector.add(children, monitor);
        collector.done();
    }

    public boolean isContainer() {
        return true;
    }

    public ISchedulingRule getRule(Object object) {
        Object object2 = object;
        if (object2 instanceof ITranslationUnit && (var2_3 = (ITranslationUnit)object2) == (ITranslationUnit)var3_2) {
            return unit.getFile();
        }
        if (object instanceof IFile var4_5) {
            return file;
        }
        return null;
    }

    public Object[] getTranslationUnitElements(ITranslationUnit translationUnit) {
        CompileUnit compileUnit;
        if (translationUnit.getFile() != null && (compileUnit = this.getCompileUnit(translationUnit.getFile().getLocationURI())) != null) {
            return compileUnit.getElements();
        }
        return null;
    }

    public boolean isDirty(ITranslationUnit translationUnit) {
        CompileUnit compileUnit;
        if (translationUnit.getFile() != null && (compileUnit = this.getCompileUnit(translationUnit.getFile().getLocationURI())) != null) {
            return compileUnit.isDirty;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Object[] getChildren(Object parentElement) {
        void documentSymbolWithUri;
        CompileUnit unit;
        void var3_2;
        SymbolsModel.DocumentSymbolWithURI documentSymbolWithURI;
        Object object = parentElement;
        if (object instanceof SymbolsModel.DocumentSymbolWithURI && (documentSymbolWithURI = (SymbolsModel.DocumentSymbolWithURI)object) == (SymbolsModel.DocumentSymbolWithURI)var3_2 && (unit = this.getCompileUnit(documentSymbolWithUri.uri)) != null) {
            return unit.getChildren(parentElement);
        }
        return EMPTY;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String getLabel(Object o) {
        void var3_2;
        ITranslationUnit iTranslationUnit;
        Object object = o;
        if (object instanceof ITranslationUnit && (iTranslationUnit = (ITranslationUnit)object) == (ITranslationUnit)var3_2) {
            void unit;
            return unit.getElementName();
        }
        return "unkown";
    }

    public Object getParent(Object o) {
        return null;
    }

    private CompileUnit getCompileUnit(URI key) {
        return this.getCompileUnit(key, null);
    }

    private synchronized CompileUnit getCompileUnit(URI key, IFile file) {
        if (file != null) {
            return this.cachedSymbols.computeIfAbsent(key, uri -> new CompileUnit(file));
        }
        return this.cachedSymbols.get(key);
    }

    /*
     * WARNING - void declaration
     */
    private Object[] getCompileUnitElements(Object object) {
        void var3_2;
        ITranslationUnit iTranslationUnit;
        Object object2 = object;
        if (object2 instanceof ITranslationUnit && (iTranslationUnit = (ITranslationUnit)object2) == (ITranslationUnit)var3_2) {
            void unit;
            CompileUnit compileUnit = null;
            if (unit.getFile() != null) {
                compileUnit = this.getCompileUnit(unit.getFile().getLocationURI(), unit.getFile());
            } else {
                Platform.getLog(this.getClass()).error("Cannot fetch elements of translation unit " + unit.getElementName());
            }
            if (compileUnit == null) {
                return EMPTY;
            }
            this.refreshTreeContentFromLS(compileUnit);
            return compileUnit.getElements();
        }
        return EMPTY;
    }

    private synchronized void refreshTreeContentFromLS(CompileUnit compileUnit) {
        block18: {
            if (compileUnit == null || !compileUnit.isDirty) {
                return;
            }
            boolean temporaryLoadedDocument = false;
            try {
                try {
                    IDocument document = LSPEclipseUtils.getExistingDocument((IResource)compileUnit.file);
                    if (document == null) {
                        document = LSPEclipseUtils.getDocument((IResource)compileUnit.file);
                        temporaryLoadedDocument = true;
                    }
                    if (document != null) {
                        CompletableFuture<Object> symbols;
                        block17: {
                            DocumentSymbolParams params = new DocumentSymbolParams(LSPEclipseUtils.toTextDocumentIdentifier((IDocument)document));
                            CompletableFuture languageServer = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)document).withCapability(ServerCapabilities::getDocumentSymbolProvider)).computeFirst((w, ls) -> CompletableFuture.completedFuture(w));
                            try {
                                symbols = ((Optional)languageServer.get(500L, TimeUnit.MILLISECONDS)).filter(Objects::nonNull).filter(LanguageServerWrapper::isActive).map(s -> s.execute(ls -> ls.getTextDocumentService().documentSymbol(params))).orElse(CompletableFuture.completedFuture(null));
                            }
                            catch (InterruptedException | ExecutionException | TimeoutException e) {
                                Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
                                symbols = CompletableFuture.completedFuture(null);
                                if (!(e instanceof InterruptedException)) break block17;
                                Thread.currentThread().interrupt();
                            }
                        }
                        ((CompletableFuture)symbols.thenAcceptAsync(response -> {
                            compileUnit.symbolsModel.update(response);
                            compileUnit.isDirty = false;
                        })).join();
                        break block18;
                    }
                    temporaryLoadedDocument = false;
                    compileUnit.symbolsModel.update(null);
                }
                catch (Exception e) {
                    Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
                    if (!temporaryLoadedDocument) break block18;
                    try {
                        FileBuffers.getTextFileBufferManager().disconnect(compileUnit.file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e2) {
                        Platform.getLog(this.getClass()).error(e2.getMessage(), (Throwable)e2);
                    }
                }
            }
            finally {
                if (temporaryLoadedDocument) {
                    try {
                        FileBuffers.getTextFileBufferManager().disconnect(compileUnit.file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    class CompileUnit {
        public final IFile file;
        public final SymbolsModel symbolsModel;
        public volatile boolean isDirty = true;

        public CompileUnit(IFile file) {
            this.file = file;
            this.symbolsModel = new SymbolsModel();
            this.symbolsModel.setUri(file.getLocationURI());
        }

        public Object[] getElements() {
            return this.symbolsModel.getElements();
        }

        public Object[] getChildren(Object parentElement) {
            return this.symbolsModel.getChildren(parentElement);
        }
    }
}

