/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.index.ICDTIndexer;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexer;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.ui.index.AbstractIndexerPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class DOMSourceIndexerBlock
extends AbstractIndexerPage {
    public static final String PREF_INDEX_MARKERS = "org.eclipse.cdt.ui.indexmarkers";
    private static final String ENABLE_PREPROCESSOR_PROBLEMS = CUIMessages.getString("IndexerOptions.enablePreprocessor");
    private static final String ENABLE_SEMANTIC_PROBLEMS = CUIMessages.getString("IndexerOptions.enableSemantic");
    private static final String ENABLE_SYNTACTIC_PROBLEMS = CUIMessages.getString("IndexerOptions.enableSyntactic");
    private static final String INDEXER_PROBLEMS = CUIMessages.getString("IndexerOptions.problemReporting");
    private Button preprocessorProblemsEnabled;
    private Button syntacticProblemsEnabled;
    private Button semanticProblemsEnabled;
    private int oldIndexerProblemsValue = 0;

    public void performApply(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(CUIMessages.getString("IndexerOptiosn.task.savingAttributes "), 1);
        ICOptionContainer container = this.getContainer();
        IProject proj = null;
        String indexMarkers = this.getIndexerProblemsValuesString();
        proj = container != null ? container.getProject() : this.currentProject;
        if (proj != null) {
            ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(proj, false);
            ICExtensionReference[] cext = cdesc.get("org.eclipse.cdt.core.CIndexer");
            if (cext.length > 0) {
                int i = 0;
                while (i < cext.length) {
                    cext[i].getID();
                    String orig = cext[i].getExtensionData("indexmarkers");
                    String indexProblems = this.getIndexerProblemsValuesString();
                    if (orig == null || !orig.equals(indexProblems)) {
                        cext[i].setExtensionData("indexmarkers", indexProblems);
                    }
                    ++i;
                }
            }
        } else if (this.prefStore != null) {
            this.prefStore.setValue(PREF_INDEX_MARKERS, indexMarkers);
        }
        if (this.currentProject == null) {
            return;
        }
        ICDTIndexer indexer = CCorePlugin.getDefault().getCoreModel().getIndexManager().getIndexerForProject(this.currentProject);
        int indexMarkersInt = Integer.parseInt(indexMarkers);
        if (indexMarkersInt != this.oldIndexerProblemsValue && indexMarkersInt == 0 && indexer instanceof DOMSourceIndexer) {
            ((DOMSourceIndexer)indexer).removeIndexerProblems((IResource)this.currentProject);
        }
    }

    public void performDefaults() {
    }

    public void createControl(Composite parent) {
        Composite page = ControlFactory.createComposite(parent, 1);
        Group problemsGroup = ControlFactory.createGroup(page, INDEXER_PROBLEMS, 1);
        GridData gd2 = (GridData)problemsGroup.getLayoutData();
        gd2.grabExcessHorizontalSpace = true;
        gd2.horizontalAlignment = 4;
        this.preprocessorProblemsEnabled = ControlFactory.createCheckBox((Composite)problemsGroup, ENABLE_PREPROCESSOR_PROBLEMS);
        this.semanticProblemsEnabled = ControlFactory.createCheckBox((Composite)problemsGroup, ENABLE_SEMANTIC_PROBLEMS);
        this.syntacticProblemsEnabled = ControlFactory.createCheckBox((Composite)problemsGroup, ENABLE_SYNTACTIC_PROBLEMS);
        this.setControl((Control)page);
    }

    public String getIndexerProblemsValuesString() {
        int result = 0;
        result |= this.preprocessorProblemsEnabled.getSelection() ? 1 : 0;
        if (this.syntacticProblemsEnabled != null) {
            result |= this.syntacticProblemsEnabled.getSelection() ? 4 : 0;
        }
        Integer tempInt = new Integer(result |= this.semanticProblemsEnabled.getSelection() ? 2 : 0);
        return tempInt.toString();
    }

    public void initialize(IProject project) {
        try {
            this.loadPersistedValues(project);
            this.currentProject = project;
        }
        catch (CoreException coreException) {}
        this.setIndexerProblemValues(this.oldIndexerProblemsValue);
    }

    public void loadPersistedValues(IProject project) throws CoreException {
        ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(project, false);
        ICExtensionReference[] cext = cdesc.get("org.eclipse.cdt.core.CIndexer");
        if (cext.length > 0) {
            int i = 0;
            while (i < cext.length) {
                cext[i].getID();
                String orig = cext[i].getExtensionData("indexmarkers");
                if (orig != null) {
                    Integer tempInt = new Integer(orig);
                    this.oldIndexerProblemsValue = tempInt;
                }
                ++i;
            }
        }
    }

    public void setIndexerProblemValues(int value) {
        this.preprocessorProblemsEnabled.setSelection((value & 1) != 0);
        if (this.syntacticProblemsEnabled != null) {
            this.syntacticProblemsEnabled.setSelection((value & 4) != 0);
        }
        this.semanticProblemsEnabled.setSelection((value & 2) != 0);
    }

    public void loadPreferences() {
        String indexerId = this.prefStore.getString(PREF_INDEX_MARKERS);
        if (!indexerId.equals("")) {
            this.oldIndexerProblemsValue = new Integer(indexerId);
            this.setIndexerProblemValues(this.oldIndexerProblemsValue);
        }
    }

    public void removePreferences() {
        this.prefStore.setToDefault(PREF_INDEX_MARKERS);
    }
}

