/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SymbolEntry {
    private static final String UNSPECIFIED_VALUE = "1";
    private String name;
    private Map values;

    public SymbolEntry(String name, String value) {
        this(name, value, true);
    }

    public SymbolEntry(String name, String value, boolean active) {
        this.name = name;
        if (this.values == null) {
            this.values = new LinkedHashMap(1);
        }
        this.values.put(value, active);
    }

    public SymbolEntry(SymbolEntry se) {
        this.name = se.name;
        this.values = new LinkedHashMap(se.values.size());
        Iterator i = se.values.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Boolean value = (Boolean)se.values.get(key);
            this.values.put(key, Boolean.valueOf(value));
        }
    }

    public boolean add(String value) {
        return this.add(value, true);
    }

    public boolean add(String value, boolean active) {
        boolean rc = false;
        if (!this.values.containsKey(value)) {
            this.values.put(value, active);
            rc = true;
        }
        return rc;
    }

    public void replace(String value, boolean active) {
        this.values.put(value, active);
    }

    private void addAll(SymbolEntry se) {
        this.values.putAll(se.values);
    }

    public void remove(String value) {
        this.values.remove(value);
    }

    public void removeAll() {
        this.values = null;
    }

    public List getActive() {
        return this.get(true, true, true);
    }

    public List getActiveRaw() {
        return this.get(false, true, true);
    }

    public List getRemoved() {
        return this.get(true, true, false);
    }

    public List getRemovedRaw() {
        return this.get(false, true, false);
    }

    public List getAll() {
        return this.get(true, false, true);
    }

    public List getAllRaw() {
        return this.get(false, false, true);
    }

    private List get(boolean format, boolean subset, boolean active) {
        ArrayList<String> rv = new ArrayList<String>(this.values.size());
        Iterator i = this.values.keySet().iterator();
        while (i.hasNext()) {
            String val = (String)i.next();
            if (subset && (Boolean)this.values.get(val) != active) continue;
            if (format) {
                rv.add(String.valueOf(this.name) + "=" + (val == null ? UNSPECIFIED_VALUE : val));
                continue;
            }
            rv.add(String.valueOf(this.name) + (val == null ? "" : "=" + val));
        }
        return rv;
    }

    public List getValuesOnly(boolean active) {
        ArrayList<String> rv = new ArrayList<String>(this.values.size());
        Iterator i = this.values.keySet().iterator();
        while (i.hasNext()) {
            String val = (String)i.next();
            if ((Boolean)this.values.get(val) != active) continue;
            rv.add(val == null ? UNSPECIFIED_VALUE : val);
        }
        return rv;
    }

    public int numberOfValues() {
        return this.values.size();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.name);
        buffer.append(':');
        Iterator i = this.values.keySet().iterator();
        while (i.hasNext()) {
            String val = (String)i.next();
            buffer.append('\t');
            buffer.append(val == null ? "null" : val);
            if (((Boolean)this.values.get(val)).booleanValue()) {
                buffer.append("(active)");
            }
            buffer.append('\n');
        }
        return buffer.toString();
    }
}

