/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.editor;

import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.IInferenceRule;
import org.eclipse.cdt.make.core.makefile.IMacroDefinition;
import org.eclipse.cdt.make.core.makefile.ISpecialRule;
import org.eclipse.cdt.make.internal.ui.MakeUIImages;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class LexicalSortingAction
extends Action {
    private static final String ACTION_NAME = "LexicalSortingAction";
    private static final String DIALOG_STORE_KEY = "LexicalSortingAction.sort";
    private LexicalMakefileSorter fSorter;
    private TreeViewer fTreeViewer;

    public LexicalSortingAction(TreeViewer treeViewer) {
        super(MakeUIPlugin.getResourceString("LexicalSortingAction.label"));
        this.setDescription(MakeUIPlugin.getResourceString("LexicalSortingAction.description"));
        this.setToolTipText(MakeUIPlugin.getResourceString("LexicalSortingAction.tooltip"));
        MakeUIImages.setImageDescriptors((IAction)this, "tool16/", MakeUIImages.IMG_TOOLS_ALPHA_SORTING);
        this.fTreeViewer = treeViewer;
        this.fSorter = new LexicalMakefileSorter();
        boolean checked = MakeUIPlugin.getDefault().getDialogSettings().getBoolean(DIALOG_STORE_KEY);
        this.valueChanged(checked, false);
    }

    public void run() {
        this.valueChanged(this.isChecked(), true);
    }

    private void valueChanged(boolean on, boolean store) {
        this.setChecked(on);
        this.fTreeViewer.setSorter((ViewerSorter)(on ? this.fSorter : null));
        String key = "LexicalSortingAction.tooltip" + (on ? ".on" : ".off");
        this.setToolTipText(MakeUIPlugin.getResourceString(key));
        if (store) {
            MakeUIPlugin.getDefault().getDialogSettings().put(DIALOG_STORE_KEY, on);
        }
    }

    private class LexicalMakefileSorter
    extends ViewerSorter {
        LexicalMakefileSorter() {
        }

        public boolean isSorterProperty(Object element, Object property) {
            return true;
        }

        public int category(Object obj) {
            if (obj instanceof IDirective) {
                IDirective directive = (IDirective)obj;
                if (directive instanceof IMacroDefinition) {
                    return 0;
                }
                if (directive instanceof ISpecialRule) {
                    return 1;
                }
                if (directive instanceof IInferenceRule) {
                    return 2;
                }
            }
            return 3;
        }
    }
}

