/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLinkageSpecification;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDelegate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPNamespaceScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;

public class CPPNamespace
implements ICPPNamespace,
ICPPInternalBinding {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    IASTName[] namespaceDefinitions = null;
    ICPPNamespaceScope scope = null;
    ICPPASTTranslationUnit tu = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CPPNamespace(ICPPASTNamespaceDefinition nsDef) {
        this.findAllDefinitions(nsDef);
        if (this.namespaceDefinitions.length == 0) {
            this.namespaceDefinitions = new IASTName[]{nsDef.getName()};
        }
    }

    public IASTNode[] getDeclarations() {
        return this.namespaceDefinitions;
    }

    public IASTNode getDefinition() {
        return this.tu != null ? this.tu : this.namespaceDefinitions[0];
    }

    private void findAllDefinitions(ICPPASTNamespaceDefinition namespaceDef) {
        NamespaceCollector collector = new NamespaceCollector(namespaceDef);
        namespaceDef.getTranslationUnit().accept(collector);
        this.namespaceDefinitions = collector.getNamespaces();
        int i = 0;
        while (i < this.namespaceDefinitions.length) {
            this.namespaceDefinitions[i].setBinding(this);
            ++i;
        }
    }

    public IASTName[] getNamespaceDefinitions() {
        return this.namespaceDefinitions;
    }

    public CPPNamespace(CPPASTTranslationUnit unit) {
        this.tu = unit;
    }

    public ICPPNamespaceScope getNamespaceScope() {
        if (this.scope == null) {
            this.scope = this.tu != null ? (ICPPNamespaceScope)this.tu.getScope() : new CPPNamespaceScope(this.namespaceDefinitions[0].getParent());
        }
        return this.scope;
    }

    public String getName() {
        return this.tu != null ? null : this.namespaceDefinitions[0].toString();
    }

    public char[] getNameCharArray() {
        return this.tu != null ? EMPTY_CHAR_ARRAY : this.namespaceDefinitions[0].toCharArray();
    }

    public IScope getScope() {
        return this.tu != null ? null : CPPVisitor.getContainingScope(this.namespaceDefinitions[0]);
    }

    public IASTNode getPhysicalNode() {
        return this.tu != null ? this.tu : this.namespaceDefinitions[0];
    }

    public String[] getFullyQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    public char[][] getFullyQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    public boolean isGloballyQualified() {
        return true;
    }

    public ICPPDelegate createDelegate(IASTName name) {
        return new CPPNamespaceDelegate(name, this);
    }

    public void addDefinition(IASTNode node) {
        if (!(node instanceof IASTName)) {
            return;
        }
        IASTName name = (IASTName)node;
        if (this.namespaceDefinitions == null) {
            this.namespaceDefinitions = new IASTName[]{name};
            return;
        }
        if (this.namespaceDefinitions.length > 0 && ((ASTNode)((Object)name)).getOffset() < ((ASTNode)((Object)this.namespaceDefinitions[0])).getOffset()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.namespaceDefinitions = (IASTName[])ArrayUtil.prepend(clazz, this.namespaceDefinitions, name);
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.namespaceDefinitions = (IASTName[])ArrayUtil.append(clazz, this.namespaceDefinitions, name);
        }
    }

    public void addDeclaration(IASTNode node) {
        this.addDefinition(node);
    }

    public void removeDeclaration(IASTNode node) {
        if (this.namespaceDefinitions != null) {
            int i = 0;
            while (i < this.namespaceDefinitions.length) {
                if (node == this.namespaceDefinitions[i]) {
                    if (i == this.namespaceDefinitions.length - 1) {
                        this.namespaceDefinitions[i] = null;
                    } else {
                        System.arraycopy(this.namespaceDefinitions, i + 1, this.namespaceDefinitions, i, this.namespaceDefinitions.length - 1 - i);
                    }
                    return;
                }
                ++i;
            }
        }
    }

    public IBinding[] getMemberBindings() {
        if (this.namespaceDefinitions != null) {
            NamespaceMemberCollector collector = new NamespaceMemberCollector();
            int i = 0;
            while (i < this.namespaceDefinitions.length) {
                IASTNode parent = this.namespaceDefinitions[i].getParent();
                if (parent instanceof ICPPASTNamespaceDefinition) {
                    IASTDeclaration[] decls = ((ICPPASTNamespaceDefinition)parent).getDeclarations();
                    int j = 0;
                    while (j < decls.length) {
                        decls[j].accept(collector);
                        ++j;
                    }
                }
                ++i;
            }
            ObjectSet objectSet = collector.members;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IBinding[])objectSet.keyArray(clazz);
        }
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    public static class CPPNamespaceDelegate
    extends CPPDelegate
    implements ICPPNamespace {
        public CPPNamespaceDelegate(IASTName name, ICPPNamespace binding) {
            super(name, binding);
        }

        public ICPPNamespaceScope getNamespaceScope() throws DOMException {
            return ((ICPPNamespace)this.getBinding()).getNamespaceScope();
        }

        public IBinding[] getMemberBindings() throws DOMException {
            return ((ICPPNamespace)this.getBinding()).getMemberBindings();
        }
    }

    private static class NamespaceCollector
    extends CPPASTVisitor {
        private ICPPASTNamespaceDefinition namespaceDef = null;
        private IASTName[] namespaces = null;
        static /* synthetic */ Class class$0;

        public NamespaceCollector(ICPPASTNamespaceDefinition ns) {
            this.shouldVisitNamespaces = true;
            this.shouldVisitDeclarations = true;
            this.namespaceDef = ns;
        }

        public int visit(ICPPASTNamespaceDefinition namespace) {
            Class<?> clazz;
            ICPPASTNamespaceDefinition orig = this.namespaceDef;
            for (ICPPASTNamespaceDefinition candidate = namespace; candidate != null; candidate = (ICPPASTNamespaceDefinition)candidate.getParent()) {
                if (!CharArrayUtils.equals(orig.getName().toCharArray(), candidate.getName().toCharArray())) {
                    return 3;
                }
                if (orig.getParent() instanceof ICPPASTNamespaceDefinition) {
                    if (!(candidate.getParent() instanceof ICPPASTNamespaceDefinition)) {
                        return 3;
                    }
                    orig = (ICPPASTNamespaceDefinition)orig.getParent();
                    continue;
                }
                if (!(candidate.getParent() instanceof ICPPASTNamespaceDefinition)) break;
                return 3;
            }
            if ((clazz = class$0) == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.namespaces = (IASTName[])ArrayUtil.append(clazz, this.namespaces, namespace.getName());
            return 1;
        }

        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof ICPPASTLinkageSpecification) {
                return 3;
            }
            return 1;
        }

        public IASTName[] getNamespaces() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IASTName[])ArrayUtil.trim(clazz, this.namespaces);
        }
    }

    private static class NamespaceMemberCollector
    extends CPPASTVisitor {
        public ObjectSet members = new ObjectSet(8);

        public NamespaceMemberCollector() {
            this.shouldVisitNamespaces = true;
            this.shouldVisitDeclarators = true;
            this.shouldVisitDeclSpecifiers = true;
            this.shouldVisitDeclarations = true;
        }

        public int visit(IASTDeclarator declarator) {
            while (declarator.getNestedDeclarator() != null) {
                declarator = declarator.getNestedDeclarator();
            }
            IBinding binding = declarator.getName().resolveBinding();
            if (binding != null && !(binding instanceof IProblemBinding)) {
                this.members.put(binding);
            }
            return 1;
        }

        public int visit(IASTDeclSpecifier declSpec) {
            IASTNode parent;
            if (declSpec instanceof ICPPASTCompositeTypeSpecifier) {
                IBinding binding = ((ICPPASTCompositeTypeSpecifier)declSpec).getName().resolveBinding();
                if (binding != null && !(binding instanceof IProblemBinding)) {
                    this.members.put(binding);
                }
                return 1;
            }
            if (declSpec instanceof ICPPASTElaboratedTypeSpecifier && (parent = declSpec.getParent()) instanceof IASTSimpleDeclaration) {
                if (((IASTSimpleDeclaration)parent).getDeclarators().length > 0) {
                    return 1;
                }
                IBinding binding = ((ICPPASTElaboratedTypeSpecifier)declSpec).getName().resolveBinding();
                if (binding != null && !(binding instanceof IProblemBinding)) {
                    this.members.put(binding);
                }
                return 1;
            }
            return 1;
        }

        public int visit(ICPPASTNamespaceDefinition namespace) {
            IBinding binding = namespace.getName().resolveBinding();
            if (binding != null && !(binding instanceof IProblemBinding)) {
                this.members.put(binding);
            }
            return 1;
        }

        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof ICPPASTUsingDeclaration) {
                IBinding binding = ((ICPPASTUsingDeclaration)declaration).getName().resolveBinding();
                if (binding != null && !(binding instanceof IProblemBinding)) {
                    this.members.put(binding);
                }
                return 1;
            }
            if (declaration instanceof IASTFunctionDefinition) {
                return this.visit(((IASTFunctionDefinition)declaration).getDeclarator());
            }
            return 3;
        }
    }
}

