/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.c.ICArrayType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;

public class CArrayType
implements ICArrayType,
ITypeContainer {
    IType type = null;
    ICASTArrayModifier mod = null;

    public CArrayType(IType type) {
        this.type = type;
    }

    public boolean isSameType(IType obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ITypedef) {
            return obj.isSameType(this);
        }
        if (obj instanceof ICArrayType) {
            ICArrayType at = (ICArrayType)obj;
            try {
                if (this.isConst() != at.isConst()) {
                    return false;
                }
                if (this.isRestrict() != at.isRestrict()) {
                    return false;
                }
                if (this.isStatic() != at.isStatic()) {
                    return false;
                }
                if (this.isVolatile() != at.isVolatile()) {
                    return false;
                }
                if (this.isVariableLength() != at.isVariableLength()) {
                    return false;
                }
                return at.getType().isSameType(this.type);
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        return false;
    }

    public IType getType() {
        return this.type;
    }

    public void setType(IType t) {
        this.type = t;
    }

    public void setModifiedArrayModifier(ICASTArrayModifier mod) {
        this.mod = mod;
    }

    public boolean isConst() {
        if (this.mod == null) {
            return false;
        }
        return this.mod.isConst();
    }

    public boolean isRestrict() {
        if (this.mod == null) {
            return false;
        }
        return this.mod.isRestrict();
    }

    public boolean isVolatile() {
        if (this.mod == null) {
            return false;
        }
        return this.mod.isVolatile();
    }

    public boolean isStatic() {
        if (this.mod == null) {
            return false;
        }
        return this.mod.isStatic();
    }

    public boolean isVariableLength() {
        if (this.mod == null) {
            return false;
        }
        return this.mod.isVariableSized();
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public ICASTArrayModifier getModifier() {
        return this.mod;
    }

    public IASTExpression getArraySizeExpression() {
        if (this.mod != null) {
            return this.mod.getConstantExpression();
        }
        return null;
    }
}

