/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IIncludeFileEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IMacroFileEntry;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.resources.ScannerInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class ScannerProvider
extends AbstractCExtension
implements IScannerInfoProvider,
IElementChangedListener {
    private static Map listeners;
    private static ScannerProvider fProvider;

    public static synchronized IScannerInfoProvider getInstance() {
        if (fProvider == null) {
            fProvider = new ScannerProvider();
            CoreModel.getDefault().addElementChangedListener(fProvider);
        }
        return fProvider;
    }

    private static Map getListeners() {
        if (listeners == null) {
            listeners = new HashMap();
        }
        return listeners;
    }

    protected static void notifyInfoListeners(IProject project, IScannerInfo info) {
        List listeners = (List)ScannerProvider.getListeners().get(project);
        if (listeners == null) {
            return;
        }
        IScannerInfoChangeListener[] observers = new IScannerInfoChangeListener[listeners.size()];
        listeners.toArray(observers);
        int i = 0;
        while (i < observers.length) {
            observers[i].changeNotification((IResource)project, info);
            ++i;
        }
    }

    public IScannerInfo getScannerInformation(IResource resource) {
        IPath resPath = resource.getFullPath();
        try {
            IIncludeEntry[] includeEntries = CoreModel.getIncludeEntries(resPath);
            int localCount = 0;
            int systemCount = 0;
            int i = 0;
            while (i < includeEntries.length) {
                if (includeEntries[i].isSystemInclude()) {
                    ++systemCount;
                } else {
                    ++localCount;
                }
                ++i;
            }
            String[] localIncludes = new String[localCount];
            String[] systemIncludes = new String[systemCount];
            int i2 = 0;
            int j = 0;
            int k = 0;
            while (i2 < includeEntries.length) {
                if (includeEntries[i2].isSystemInclude()) {
                    systemIncludes[j++] = includeEntries[i2].getFullIncludePath().toOSString();
                } else {
                    localIncludes[k++] = includeEntries[i2].getFullIncludePath().toOSString();
                }
                ++i2;
            }
            IIncludeFileEntry[] includeFileEntries = CoreModel.getIncludeFileEntries(resPath);
            String[] includeFiles = new String[includeFileEntries.length];
            int i3 = 0;
            while (i3 < includeFiles.length) {
                includeFiles[i3] = includeFileEntries[i3].getFullIncludeFilePath().toOSString();
                ++i3;
            }
            IMacroEntry[] macros = CoreModel.getMacroEntries(resPath);
            HashMap<String, String> symbolMap = new HashMap<String, String>();
            int i4 = 0;
            while (i4 < macros.length) {
                symbolMap.put(macros[i4].getMacroName(), macros[i4].getMacroValue());
                ++i4;
            }
            IMacroFileEntry[] macroFileEntries = CoreModel.getMacroFileEntries(resPath);
            String[] macroFiles = new String[macroFileEntries.length];
            int i5 = 0;
            while (i5 < macroFiles.length) {
                macroFiles[i5] = macroFileEntries[i5].getFullMacroFilePath().toOSString();
                ++i5;
            }
            return new ScannerInfo(systemIncludes, localIncludes, includeFiles, symbolMap, macroFiles);
        }
        catch (CModelException cModelException) {
            return new ScannerInfo(null, null, null, null, null);
        }
    }

    public synchronized void subscribe(IResource resource, IScannerInfoChangeListener listener) {
        if (resource == null || listener == null) {
            return;
        }
        IProject project = resource.getProject();
        Map map = ScannerProvider.getListeners();
        ArrayList<IScannerInfoChangeListener> list = (ArrayList<IScannerInfoChangeListener>)map.get(project);
        if (list == null) {
            list = new ArrayList<IScannerInfoChangeListener>();
            map.put(project, list);
        }
        if (!list.contains(listener)) {
            list.add(listener);
        }
    }

    public synchronized void unsubscribe(IResource resource, IScannerInfoChangeListener listener) {
        if (resource == null || listener == null) {
            return;
        }
        IProject project = resource.getProject();
        Map map = ScannerProvider.getListeners();
        List list = (List)map.get(project);
        if (list != null && !list.isEmpty()) {
            list.remove(listener);
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            this.processDelta(event.getDelta());
        }
        catch (CModelException cModelException) {}
    }

    protected boolean isPathEntryChange(ICElementDelta delta) {
        int flags = delta.getFlags();
        return delta.getKind() == 4 && ((flags & 0x800) != 0 || (flags & 0x400) != 0 || (flags & 0x40000) != 0);
    }

    protected void processDelta(ICElementDelta delta) throws CModelException {
        ICElement element = delta.getElement();
        if (this.isPathEntryChange(delta)) {
            IResource res = element.getResource();
            IProject project = element.getCProject().getProject();
            if (res == null) {
                res = project;
            }
            IScannerInfo info = this.getScannerInformation(res);
            ScannerProvider.notifyInfoListeners(project, info);
        }
        ICElementDelta[] affectedChildren = delta.getAffectedChildren();
        int i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i]);
            ++i;
        }
    }
}

