/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.domsourceindexer;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMIndexRequest;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexer;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class DOMAddFolderToIndex
extends DOMIndexRequest {
    IPath folderPath;
    IProject project;
    char[][] exclusionPattern;
    ArrayList sourceFilesToIndex;
    ArrayList headerFilesToIndex;

    public DOMAddFolderToIndex(IPath folderPath, IProject project, char[][] exclusionPattern, DOMSourceIndexer indexer) {
        super(project.getFullPath(), indexer);
        this.folderPath = folderPath;
        this.project = project;
        this.exclusionPattern = exclusionPattern;
        this.sourceFilesToIndex = new ArrayList();
        this.headerFilesToIndex = new ArrayList();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        if (!this.project.isAccessible()) {
            return true;
        }
        IResource folder = this.project.getParent().findMember(this.folderPath);
        if (folder == null) return true;
        if (folder.getType() == 1) {
            return true;
        }
        IIndex index = this.indexer.getIndex(this.indexPath, true, true);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = this.indexer.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterRead();
                final char[][] pattern = this.exclusionPattern;
                folder.accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        switch (proxy.getType()) {
                            case 1: {
                                IResource resource = proxy.requestResource();
                                if (CoreModel.isValidTranslationUnitName(resource.getProject(), resource.getName()) && (pattern == null || !Util.isExcluded(resource, pattern))) {
                                    DOMAddFolderToIndex.this.sortFiles((IFile)resource);
                                }
                                return false;
                            }
                            case 2: {
                                if (pattern == null || !Util.isExcluded(proxy.requestResource(), pattern)) break;
                                return false;
                            }
                        }
                        return true;
                    }
                }, 0);
                this.scheduleJobs();
            }
            catch (CoreException e) {
                if (IndexManager.VERBOSE) {
                    JobManager.verbose("-> failed to add " + this.folderPath + " to index because of the following exception:");
                    e.printStackTrace();
                }
                Object var6_7 = null;
                monitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            monitor.exitRead();
            throw throwable;
        }
        {
            Object var6_9 = null;
            monitor.exitRead();
            return true;
        }
    }

    private void scheduleJobs() {
        int i = 0;
        while (i < this.sourceFilesToIndex.size()) {
            this.indexer.addSource((IFile)this.sourceFilesToIndex.get(i), this.indexPath, false);
            ++i;
        }
        i = 0;
        while (i < this.headerFilesToIndex.size()) {
            this.indexer.addSource((IFile)this.headerFilesToIndex.get(i), this.indexPath, true);
            ++i;
        }
    }

    public String toString() {
        return "adding " + this.folderPath + " to index " + this.indexPath;
    }

    protected void sortFiles(IFile file) {
        boolean isSource;
        boolean isHeader = CoreModel.isValidHeaderUnitName(file.getProject(), file.getName());
        if (isHeader) {
            this.headerFilesToIndex.add(file);
        }
        if (isSource = CoreModel.isValidSourceUnitName(file.getProject(), file.getName())) {
            this.sourceFilesToIndex.add(file);
        }
    }
}

