/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryModule;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IDeclaration;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.core.model.ILibraryReference;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITemplate;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.ui.CElementImageDescriptor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class CElementImageProvider {
    public static final int OVERLAY_ICONS = 1;
    public static final int SMALL_ICONS = 2;
    public static final int LIGHT_TYPE_ICONS = 4;
    public static final int OVERLAY_ERROR = 8;
    public static final int OVERLAY_WARNING = 16;
    public static final int OVERLAY_OVERRIDE = 32;
    public static final int OVERLAY_IMPLEMENTS = 64;
    public static final Point SMALL_SIZE = new Point(16, 16);
    public static final Point BIG_SIZE = new Point(22, 16);
    private static ImageDescriptor DESC_OBJ_PROJECT_CLOSED;
    private static ImageDescriptor DESC_OBJ_PROJECT;
    static /* synthetic */ Class class$0;

    public CElementImageProvider() {
        ISharedImages images = CUIPlugin.getDefault().getWorkbench().getSharedImages();
        DESC_OBJ_PROJECT_CLOSED = images.getImageDescriptor("IMG_OBJ_PROJECT_CLOSED");
        DESC_OBJ_PROJECT = images.getImageDescriptor("IMG_OBJ_PROJECT");
    }

    public Image getImageLabel(Object element, int flags) {
        IFile file;
        Object descriptor = null;
        if (element instanceof ICElement) {
            descriptor = this.getCImageDescriptor((ICElement)element, flags);
        } else if (element instanceof IFile && (CoreModel.isValidTranslationUnitName((IProject)(file = (IFile)element).getProject(), (String)file.getName()) || CoreModel.isValidTranslationUnitName(null, (String)file.getName()))) {
            descriptor = CPluginImages.DESC_OBJS_TUNIT_RESOURCE;
            Point size = this.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
            descriptor = new CElementImageDescriptor((ImageDescriptor)descriptor, 0, size);
        }
        if (descriptor == null && element instanceof IAdaptable) {
            descriptor = this.getWorkbenchImageDescriptor((IAdaptable)element, flags);
        }
        if (descriptor != null) {
            return CUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)descriptor);
        }
        return null;
    }

    public static ImageDescriptor getImageDescriptor(int type) {
        switch (type) {
            case 30: {
                return CPluginImages.DESC_OBJS_CONTAINER;
            }
            case 14: {
                return CPluginImages.DESC_OBJS_BINARY;
            }
            case 18: {
                return CPluginImages.DESC_OBJS_ARCHIVE;
            }
            case 60: {
                return CPluginImages.DESC_OBJS_TUNIT;
            }
            case 12: {
                return CPluginImages.DESC_OBJS_CFOLDER;
            }
            case 11: {
                return DESC_OBJ_PROJECT;
            }
            case 67: 
            case 85: {
                return CPluginImages.DESC_OBJS_STRUCT;
            }
            case 65: 
            case 83: {
                return CPluginImages.DESC_OBJS_CLASS;
            }
            case 69: 
            case 87: {
                return CPluginImages.DESC_OBJS_UNION;
            }
            case 80: {
                return CPluginImages.DESC_OBJS_TYPEDEF;
            }
            case 63: {
                return CPluginImages.DESC_OBJS_ENUMERATION;
            }
            case 81: {
                return CPluginImages.DESC_OBJS_ENUMERATOR;
            }
            case 72: {
                return CPluginImages.DESC_OBJS_PUBLIC_FIELD;
            }
            case 76: 
            case 92: {
                return CPluginImages.DESC_OBJS_VARIABLE;
            }
            case 70: 
            case 71: 
            case 90: 
            case 91: {
                return CPluginImages.DESC_OBJS_PUBLIC_METHOD;
            }
            case 74: 
            case 89: {
                return CPluginImages.DESC_OBJS_FUNCTION;
            }
            case 64: 
            case 66: 
            case 68: 
            case 77: 
            case 82: 
            case 84: 
            case 86: {
                return CPluginImages.DESC_OBJS_VAR_DECLARARION;
            }
            case 73: 
            case 88: {
                return CPluginImages.DESC_OBJS_DECLARARION;
            }
            case 75: {
                return CPluginImages.DESC_OBJS_INCLUDE;
            }
            case 79: {
                return CPluginImages.DESC_OBJS_MACRO;
            }
            case 61: {
                return CPluginImages.DESC_OBJS_NAMESPACE;
            }
            case 62: {
                return CPluginImages.DESC_OBJS_USING;
            }
        }
        return null;
    }

    private boolean showOverlayIcons(int flags) {
        return (flags & 1) != 0;
    }

    private boolean useSmallSize(int flags) {
        return (flags & 2) != 0;
    }

    public ImageDescriptor getCImageDescriptor(ICElement element, int flags) {
        int adornmentFlags = this.computeCAdornmentFlags(element, flags);
        Point size = this.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        ImageDescriptor desc = this.getBaseImageDescriptor(element, flags);
        if (desc != null) {
            return new CElementImageDescriptor(desc, adornmentFlags, size);
        }
        return null;
    }

    public ImageDescriptor getWorkbenchImageDescriptor(IAdaptable adaptable, int flags) {
        IWorkbenchAdapter wbAdapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((wbAdapter = (IWorkbenchAdapter)adaptable.getAdapter((Class)clazz)) == null) {
            return null;
        }
        ImageDescriptor descriptor = wbAdapter.getImageDescriptor((Object)adaptable);
        if (descriptor == null) {
            return null;
        }
        int adornmentFlags = this.computeBasicAdornmentFlags(adaptable, flags);
        Point size = this.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new CElementImageDescriptor(descriptor, adornmentFlags, size);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImageDescriptor getBaseImageDescriptor(ICElement celement, int renderFlags) {
        int type = celement.getElementType();
        switch (type) {
            case 30: {
                if (celement instanceof IBinaryModule) {
                    return CPluginImages.DESC_OBJS_BINARY;
                }
                if (celement instanceof ILibraryReference) {
                    return CPluginImages.DESC_OBJS_UNKNOWN;
                }
                if (!(celement instanceof IIncludeReference)) return CPluginImages.DESC_OBJS_CONTAINER;
                return CPluginImages.DESC_OBJS_INCLUDES_FOLDER;
            }
            case 14: {
                IBinary bin = (IBinary)celement;
                if (bin.isExecutable()) {
                    if (!bin.hasDebug()) return CPluginImages.DESC_OBJS_CEXEC;
                    return CPluginImages.DESC_OBJS_CEXEC_DEBUG;
                }
                if (bin.isSharedLib()) {
                    return CPluginImages.DESC_OBJS_SHLIB;
                }
                if (!bin.isCore()) return CPluginImages.DESC_OBJS_BINARY;
                return CPluginImages.DESC_OBJS_CORE;
            }
            case 18: {
                return CPluginImages.DESC_OBJS_ARCHIVE;
            }
            case 60: {
                ITranslationUnit unit = (ITranslationUnit)celement;
                if (unit.isHeaderUnit()) {
                    return CPluginImages.DESC_OBJS_TUNIT_HEADER;
                }
                if (!unit.isSourceUnit() || !unit.isASMLanguage()) return CPluginImages.DESC_OBJS_TUNIT;
                return CPluginImages.DESC_OBJS_TUNIT_ASM;
            }
            case 12: {
                if (!(celement instanceof ISourceRoot)) return CPluginImages.DESC_OBJS_CFOLDER;
                return CPluginImages.DESC_OBJS_SOURCE_ROOT;
            }
            case 11: {
                ImageDescriptor result;
                IWorkbenchAdapter adapter;
                ICProject cp = (ICProject)celement;
                if (!cp.getProject().isOpen()) return DESC_OBJ_PROJECT_CLOSED;
                IProject project = cp.getProject();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = (IWorkbenchAdapter)project.getAdapter((Class)clazz)) == null || (result = adapter.getImageDescriptor((Object)project)) == null) return DESC_OBJ_PROJECT;
                return result;
            }
            case 67: 
            case 85: {
                return CElementImageProvider.getStructImageDescriptor();
            }
            case 65: 
            case 83: {
                return CElementImageProvider.getClassImageDescriptor();
            }
            case 69: 
            case 87: {
                return CElementImageProvider.getUnionImageDescriptor();
            }
            case 80: {
                return CElementImageProvider.getTypedefImageDescriptor();
            }
            case 63: {
                return CElementImageProvider.getEnumerationImageDescriptor();
            }
            case 81: {
                return CElementImageProvider.getEnumeratorImageDescriptor();
            }
            case 72: {
                try {
                    IField field = (IField)celement;
                    ASTAccessVisibility visibility = field.getVisibility();
                    return CElementImageProvider.getFieldImageDescriptor(visibility);
                }
                catch (CModelException cModelException) {
                    return null;
                }
            }
            case 70: 
            case 71: 
            case 90: 
            case 91: {
                try {
                    IMethodDeclaration md = (IMethodDeclaration)celement;
                    ASTAccessVisibility visibility = md.getVisibility();
                    return CElementImageProvider.getMethodImageDescriptor(visibility);
                }
                catch (CModelException cModelException) {
                    return null;
                }
            }
            case 76: 
            case 92: {
                return CElementImageProvider.getVariableImageDescriptor();
            }
            case 74: 
            case 89: {
                return CElementImageProvider.getFunctionImageDescriptor();
            }
            case 64: 
            case 66: 
            case 68: 
            case 77: 
            case 82: 
            case 84: 
            case 86: {
                return CElementImageProvider.getVariableDeclarationImageDescriptor();
            }
            case 73: 
            case 88: {
                return CElementImageProvider.getFunctionDeclarationImageDescriptor();
            }
            case 75: {
                return CElementImageProvider.getIncludeImageDescriptor();
            }
            case 79: {
                return CElementImageProvider.getMacroImageDescriptor();
            }
            case 61: {
                return CElementImageProvider.getNamespaceImageDescriptor();
            }
            case 62: {
                return CElementImageProvider.getUsingImageDescriptor();
            }
        }
        return null;
    }

    private int computeCAdornmentFlags(ICElement element, int renderFlags) {
        int flags = this.computeBasicAdornmentFlags(element, renderFlags);
        try {
            if (this.showOverlayIcons(renderFlags) && element instanceof IDeclaration) {
                IDeclaration decl = (IDeclaration)element;
                if (decl.isStatic()) {
                    flags |= 8;
                }
                if (decl.isConst()) {
                    flags |= 2;
                }
                if (decl.isVolatile()) {
                    flags |= 4;
                }
                if (element instanceof ITemplate) {
                    flags |= 1;
                }
            }
        }
        catch (CModelException cModelException) {}
        return flags;
    }

    private int computeBasicAdornmentFlags(Object element, int renderFlags) {
        int flags = 0;
        if ((renderFlags & 8) != 0) {
            flags |= 0x40;
        }
        if ((renderFlags & 0x10) != 0) {
            flags |= 0x20;
        }
        if ((renderFlags & 0x20) != 0) {
            flags |= 0x80;
        }
        if ((renderFlags & 0x40) != 0) {
            flags |= 0x100;
        }
        return flags;
    }

    public void dispose() {
    }

    public static ImageDescriptor getStructImageDescriptor() {
        return CPluginImages.DESC_OBJS_STRUCT;
    }

    public static ImageDescriptor getClassImageDescriptor() {
        return CPluginImages.DESC_OBJS_CLASS;
    }

    public static ImageDescriptor getUnionImageDescriptor() {
        return CPluginImages.DESC_OBJS_UNION;
    }

    public static ImageDescriptor getTypedefImageDescriptor() {
        return CPluginImages.DESC_OBJS_TYPEDEF;
    }

    public static ImageDescriptor getEnumerationImageDescriptor() {
        return CPluginImages.DESC_OBJS_ENUMERATION;
    }

    public static ImageDescriptor getEnumeratorImageDescriptor() {
        return CPluginImages.DESC_OBJS_ENUMERATOR;
    }

    public static ImageDescriptor getFieldImageDescriptor(ASTAccessVisibility visibility) {
        if (visibility == ASTAccessVisibility.PUBLIC) {
            return CPluginImages.DESC_OBJS_PUBLIC_FIELD;
        }
        if (visibility == ASTAccessVisibility.PROTECTED) {
            return CPluginImages.DESC_OBJS_PROTECTED_FIELD;
        }
        return CPluginImages.DESC_OBJS_PRIVATE_FIELD;
    }

    public static ImageDescriptor getMethodImageDescriptor(ASTAccessVisibility visibility) {
        if (visibility == ASTAccessVisibility.PUBLIC) {
            return CPluginImages.DESC_OBJS_PUBLIC_METHOD;
        }
        if (visibility == ASTAccessVisibility.PROTECTED) {
            return CPluginImages.DESC_OBJS_PROTECTED_METHOD;
        }
        return CPluginImages.DESC_OBJS_PRIVATE_METHOD;
    }

    public static ImageDescriptor getVariableImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(76);
    }

    public static ImageDescriptor getLocalVariableImageDescriptor() {
        return CPluginImages.DESC_OBJS_LOCAL_VARIABLE;
    }

    public static ImageDescriptor getFunctionImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(74);
    }

    public static ImageDescriptor getVariableDeclarationImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(77);
    }

    public static ImageDescriptor getFunctionDeclarationImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(73);
    }

    public static ImageDescriptor getIncludeImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(75);
    }

    public static ImageDescriptor getMacroImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(79);
    }

    public static ImageDescriptor getNamespaceImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(61);
    }

    public static ImageDescriptor getUsingImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(62);
    }

    public static ImageDescriptor getKeywordImageDescriptor() {
        return CPluginImages.DESC_OBJS_KEYWORD;
    }
}

