/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedOptionValueHandler;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedOptionValueHandler;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Option
extends BuildObject
implements IOption {
    private static final String EMPTY_STRING = new String();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private IOption superClass;
    private String superClassId;
    private IHoldsOptions holder;
    private String unusedChildren;
    private Integer browseType;
    private List builtIns;
    private IOptionCategory category;
    private String categoryId;
    private String command;
    private String commandFalse;
    private List enumList;
    private Map enumCommands;
    private Map enumNames;
    private Object value;
    private Object defaultValue;
    private Integer valueType;
    private Boolean isAbstract;
    private Integer resourceFilter;
    private IConfigurationElement valueHandlerElement = null;
    private IManagedOptionValueHandler valueHandler = null;
    private String valueHandlerExtraArgument;
    private IConfigurationElement applicabilityCalculatorElement = null;
    private IOptionApplicability applicabilityCalculator = null;
    private boolean isExtensionOption = false;
    private boolean isDirty = false;
    private boolean resolved = true;
    private boolean verified = false;
    private boolean isValid = true;

    public Option(IHoldsOptions parent, IManagedConfigElement element) {
        this.holder = parent;
        this.isExtensionOption = true;
        this.resolved = false;
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionOption(this);
    }

    public Option(IHoldsOptions parent, IOption superClass, String Id, String name, boolean isExtensionElement) {
        this.holder = parent;
        this.superClass = superClass;
        if (this.superClass != null) {
            this.superClassId = this.superClass.getId();
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionOption = isExtensionElement;
        if (isExtensionElement) {
            ManagedBuildManager.addExtensionOption(this);
        } else {
            this.setDirty(true);
        }
    }

    public Option(IHoldsOptions parent, Element element) {
        this.holder = parent;
        this.isExtensionOption = false;
        this.loadFromProject(element);
    }

    public Option(IHoldsOptions parent, String Id, String name, Option option) {
        this.holder = parent;
        this.superClass = option.superClass;
        if (this.superClass != null) {
            this.superClassId = option.superClass.getId();
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionOption = false;
        if (option.unusedChildren != null) {
            this.unusedChildren = new String(option.unusedChildren);
        }
        if (option.isAbstract != null) {
            this.isAbstract = new Boolean(option.isAbstract);
        }
        if (option.command != null) {
            this.command = new String(option.command);
        }
        if (option.commandFalse != null) {
            this.commandFalse = new String(option.commandFalse);
        }
        if (option.categoryId != null) {
            this.categoryId = new String(option.categoryId);
        }
        if (option.builtIns != null) {
            this.builtIns = new ArrayList(option.builtIns);
        }
        if (option.browseType != null) {
            this.browseType = new Integer(option.browseType);
        }
        if (option.resourceFilter != null) {
            this.resourceFilter = new Integer(option.resourceFilter);
        }
        if (option.enumList != null) {
            this.enumList = new ArrayList(option.enumList);
            this.enumCommands = new HashMap(option.enumCommands);
            this.enumNames = new HashMap(option.enumNames);
        }
        if (option.valueType != null) {
            this.valueType = new Integer(option.valueType);
        }
        Integer vType = null;
        try {
            vType = new Integer(option.getValueType());
            if (vType != null) {
                switch (vType) {
                    case 0: {
                        if (option.value != null) {
                            this.value = new Boolean((Boolean)option.value);
                        }
                        if (option.defaultValue == null) break;
                        this.defaultValue = new Boolean((Boolean)option.defaultValue);
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (option.value != null) {
                            this.value = new String((String)option.value);
                        }
                        if (option.defaultValue == null) break;
                        this.defaultValue = new String((String)option.defaultValue);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        if (option.value != null) {
                            this.value = new ArrayList((ArrayList)option.value);
                        }
                        if (option.defaultValue == null) break;
                        this.defaultValue = new ArrayList((ArrayList)option.defaultValue);
                    }
                }
            }
        }
        catch (BuildException buildException) {}
        this.category = option.category;
        this.applicabilityCalculatorElement = option.applicabilityCalculatorElement;
        this.applicabilityCalculator = option.applicabilityCalculator;
        if (option.valueHandlerElement != null) {
            this.valueHandlerElement = option.valueHandlerElement;
            this.valueHandler = option.valueHandler;
        }
        if (option.valueHandlerExtraArgument != null) {
            this.valueHandlerExtraArgument = new String(option.valueHandlerExtraArgument);
        }
        this.setDirty(true);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        String valueHandler;
        String browseTypeStr;
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(element.getAttribute("id"));
        this.setName(element.getAttribute("name"));
        this.superClassId = element.getAttribute("superClass");
        this.unusedChildren = element.getAttribute("unusedChildren");
        String isAbs = element.getAttribute("isAbstract");
        if (isAbs != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        this.command = element.getAttribute("command");
        this.commandFalse = element.getAttribute("commandFalse");
        String valueTypeStr = element.getAttribute("valueType");
        if (valueTypeStr != null) {
            this.valueType = new Integer(this.ValueTypeStrToInt(valueTypeStr));
        }
        if ((browseTypeStr = element.getAttribute("browseType")) == null || browseTypeStr.equals("none")) {
            this.browseType = new Integer(0);
        } else if (browseTypeStr.equals("file")) {
            this.browseType = new Integer(1);
        } else if (browseTypeStr.equals("directory")) {
            this.browseType = new Integer(2);
        }
        this.categoryId = element.getAttribute("category");
        String resFilterStr = element.getAttribute("resourceFilter");
        if (resFilterStr == null || resFilterStr.equals("all")) {
            this.resourceFilter = new Integer(0);
        } else if (resFilterStr.equals("file")) {
            this.resourceFilter = new Integer(1);
        } else if (resFilterStr.equals("project")) {
            this.resourceFilter = new Integer(2);
        }
        String applicabilityCalculatorStr = element.getAttribute("applicabilityCalculator");
        if (applicabilityCalculatorStr != null && element instanceof DefaultManagedConfigElement) {
            this.applicabilityCalculatorElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        if ((valueHandler = element.getAttribute("valueHandler")) != null && element instanceof DefaultManagedConfigElement) {
            this.valueHandlerElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        this.valueHandlerExtraArgument = element.getAttribute("valueHandlerExtraArgument");
    }

    protected void loadFromProject(Element element) {
        String isAbs;
        this.setId(element.getAttribute("id"));
        if (element.hasAttribute("name")) {
            this.setName(element.getAttribute("name"));
        }
        this.superClassId = element.getAttribute("superClass");
        if (this.superClassId != null && this.superClassId.length() > 0) {
            this.superClass = ManagedBuildManager.getExtensionOption(this.superClassId);
        }
        if (element.hasAttribute("unusedChildren")) {
            this.unusedChildren = element.getAttribute("unusedChildren");
        }
        if (element.hasAttribute("isAbstract") && (isAbs = element.getAttribute("isAbstract")) != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        if (element.hasAttribute("command")) {
            this.command = element.getAttribute("command");
        }
        if (element.hasAttribute("commandFalse")) {
            this.commandFalse = element.getAttribute("commandFalse");
        }
        if (element.hasAttribute("valueType")) {
            String valueTypeStr = element.getAttribute("valueType");
            this.valueType = new Integer(this.ValueTypeStrToInt(valueTypeStr));
        }
        try {
            int valType = this.getValueType();
            switch (valType) {
                case 0: {
                    if (element.hasAttribute("value")) {
                        this.value = new Boolean(element.getAttribute("value"));
                    }
                    if (element.hasAttribute("defaultValue")) {
                        this.defaultValue = new Boolean(element.getAttribute("defaultValue"));
                    }
                    break;
                }
                case 2: {
                    if (element.hasAttribute("value")) {
                        this.value = element.getAttribute("value");
                    }
                    if (element.hasAttribute("defaultValue")) {
                        this.defaultValue = element.getAttribute("defaultValue");
                    }
                    break;
                }
                case 1: {
                    if (element.hasAttribute("value")) {
                        this.value = element.getAttribute("value");
                    }
                    if (element.hasAttribute("defaultValue")) {
                        this.defaultValue = element.getAttribute("defaultValue");
                    }
                    NodeList configElements = element.getChildNodes();
                    int i = 0;
                    while (i < configElements.getLength()) {
                        Node configNode = configElements.item(i);
                        if (configNode.getNodeName().equals("enumeratedOptionValue")) {
                            Boolean isDefault;
                            Element configElement = (Element)configNode;
                            String optId = configElement.getAttribute("id");
                            if (i == 0) {
                                this.enumList = new ArrayList();
                                if (this.defaultValue == null) {
                                    this.defaultValue = optId;
                                }
                            }
                            this.enumList.add(optId);
                            if (configElement.hasAttribute("command")) {
                                this.getEnumCommandMap().put(optId, configElement.getAttribute("command"));
                            } else {
                                this.getEnumCommandMap().put(optId, EMPTY_STRING);
                            }
                            this.getEnumNameMap().put(optId, configElement.getAttribute("name"));
                            if (configElement.hasAttribute("isDefault") && (isDefault = new Boolean(configElement.getAttribute("isDefault"))).booleanValue()) {
                                this.defaultValue = optId;
                            }
                        }
                        ++i;
                    }
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ArrayList<String> valueList = null;
                    NodeList configElements = element.getChildNodes();
                    int i = 0;
                    while (i < configElements.getLength()) {
                        Node configNode;
                        if (i == 0) {
                            valueList = new ArrayList<String>();
                            this.builtIns = new ArrayList();
                        }
                        if ((configNode = configElements.item(i)).getNodeName().equals("listOptionValue")) {
                            Element valueElement = (Element)configNode;
                            Boolean isBuiltIn = valueElement.hasAttribute("isDefault") ? new Boolean(valueElement.getAttribute("builtIn")) : new Boolean(false);
                            if (isBuiltIn.booleanValue()) {
                                this.builtIns.add(valueElement.getAttribute("value"));
                            } else {
                                valueList.add(valueElement.getAttribute("value"));
                            }
                        }
                        ++i;
                    }
                    this.value = valueList;
                    break;
                }
            }
        }
        catch (BuildException buildException) {}
        if (element.hasAttribute("browseType")) {
            String browseTypeStr = element.getAttribute("browseType");
            if (browseTypeStr == null || browseTypeStr.equals("none")) {
                this.browseType = new Integer(0);
            } else if (browseTypeStr.equals("file")) {
                this.browseType = new Integer(1);
            } else if (browseTypeStr.equals("directory")) {
                this.browseType = new Integer(2);
            }
        }
        if (element.hasAttribute("category")) {
            this.categoryId = element.getAttribute("category");
            if (this.categoryId != null) {
                this.category = this.holder.getOptionCategory(this.categoryId);
            }
        }
        if (element.hasAttribute("resourceFilter")) {
            String resFilterStr = element.getAttribute("resourceFilter");
            if (resFilterStr == null || resFilterStr.equals("all")) {
                this.resourceFilter = new Integer(0);
            } else if (resFilterStr.equals("file")) {
                this.resourceFilter = new Integer(1);
            } else if (resFilterStr.equals("project")) {
                this.resourceFilter = new Integer(2);
            }
        }
        if (element.hasAttribute("valueHandlerExtraArgument")) {
            this.valueHandlerExtraArgument = element.getAttribute("valueHandlerExtraArgument");
        }
    }

    private int ValueTypeStrToInt(String valueTypeStr) {
        if (valueTypeStr == null) {
            return -1;
        }
        if (valueTypeStr.equals("string")) {
            return 2;
        }
        if (valueTypeStr.equals("stringList")) {
            return 3;
        }
        if (valueTypeStr.equals("boolean")) {
            return 0;
        }
        if (valueTypeStr.equals("enumerated")) {
            return 1;
        }
        if (valueTypeStr.equals("includePath")) {
            return 4;
        }
        if (valueTypeStr.equals("libs")) {
            return 6;
        }
        if (valueTypeStr.equals("userObjs")) {
            return 7;
        }
        if (valueTypeStr.equals("definedSymbols")) {
            return 5;
        }
        return 5;
    }

    public void serialize(Document doc, Element element) throws BuildException {
        String str;
        if (this.superClass != null) {
            element.setAttribute("superClass", this.superClass.getId());
        }
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.unusedChildren != null) {
            element.setAttribute("unusedChildren", this.unusedChildren);
        }
        if (this.isAbstract != null) {
            element.setAttribute("isAbstract", this.isAbstract.toString());
        }
        if (this.command != null) {
            element.setAttribute("command", this.command);
        }
        if (this.commandFalse != null) {
            element.setAttribute("commandFalse", this.commandFalse);
        }
        boolean storeValueType = false;
        if (this.value != null) {
            storeValueType = true;
            switch (this.getValueType()) {
                case 0: {
                    element.setAttribute("value", ((Boolean)this.value).toString());
                    break;
                }
                case 1: 
                case 2: {
                    element.setAttribute("value", (String)this.value);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (this.value != null) {
                        ArrayList stringList = (ArrayList)this.value;
                        ListIterator iter = stringList.listIterator();
                        while (iter.hasNext()) {
                            Element valueElement = doc.createElement("listOptionValue");
                            valueElement.setAttribute("value", (String)iter.next());
                            valueElement.setAttribute("builtIn", "false");
                            element.appendChild(valueElement);
                        }
                    }
                    if (this.builtIns == null) break;
                    ListIterator iter = this.builtIns.listIterator();
                    while (iter.hasNext()) {
                        Element valueElement = doc.createElement("listOptionValue");
                        valueElement.setAttribute("value", (String)iter.next());
                        valueElement.setAttribute("builtIn", "true");
                        element.appendChild(valueElement);
                    }
                    break;
                }
            }
        }
        if (this.defaultValue != null) {
            storeValueType = true;
            switch (this.getValueType()) {
                case 0: {
                    element.setAttribute("defaultValue", ((Boolean)this.defaultValue).toString());
                    break;
                }
                case 1: 
                case 2: {
                    element.setAttribute("defaultValue", (String)this.defaultValue);
                    break;
                }
            }
        }
        if (storeValueType) {
            switch (this.getValueType()) {
                case 0: {
                    str = "boolean";
                    break;
                }
                case 2: {
                    str = "string";
                    break;
                }
                case 1: {
                    str = "enumerated";
                    break;
                }
                case 3: {
                    str = "stringList";
                    break;
                }
                case 4: {
                    str = "includePath";
                    break;
                }
                case 6: {
                    str = "libs";
                    break;
                }
                case 7: {
                    str = "userObjs";
                    break;
                }
                case 5: {
                    str = "definedSymbols";
                    break;
                }
                default: {
                    str = EMPTY_STRING;
                }
            }
            element.setAttribute("valueType", str);
        }
        if (this.browseType != null) {
            switch (this.getBrowseType()) {
                case 0: {
                    str = "none";
                    break;
                }
                case 1: {
                    str = "file";
                    break;
                }
                case 2: {
                    str = "directory";
                    break;
                }
                default: {
                    str = EMPTY_STRING;
                }
            }
            element.setAttribute("browseType", str);
        }
        if (this.categoryId != null) {
            element.setAttribute("category", this.categoryId);
        }
        if (this.resourceFilter != null) {
            switch (this.getResourceFilter()) {
                case 0: {
                    str = "all";
                    break;
                }
                case 1: {
                    str = "file";
                    break;
                }
                case 2: {
                    str = "project";
                    break;
                }
                default: {
                    str = EMPTY_STRING;
                }
            }
            element.setAttribute("resourceFilter", str);
        }
        if (this.valueHandlerExtraArgument != null) {
            element.setAttribute("valueHandlerExtraArgument", this.valueHandlerExtraArgument);
        }
        this.isDirty = false;
    }

    public IBuildObject getParent() {
        return this.holder;
    }

    public IHoldsOptions getOptionHolder() {
        return this.holder;
    }

    public IOption getSuperClass() {
        return this.superClass;
    }

    public String getName() {
        return this.name == null && this.superClass != null ? this.superClass.getName() : this.name;
    }

    public String[] getApplicableValues() {
        if (this.enumList == null) {
            if (this.superClass != null) {
                return this.superClass.getApplicableValues();
            }
            return EMPTY_STRING_ARRAY;
        }
        if (this.enumList.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] enumNames = new String[this.enumList.size()];
        int index = 0;
        while (index < this.enumList.size()) {
            enumNames[index] = (String)this.getEnumNameMap().get(this.enumList.get(index));
            ++index;
        }
        return enumNames;
    }

    public boolean getBooleanValue() {
        return (Boolean)this.getValue();
    }

    public int getBrowseType() {
        if (this.browseType == null) {
            if (this.superClass != null) {
                return this.superClass.getBrowseType();
            }
            return 0;
        }
        return this.browseType;
    }

    public int getResourceFilter() {
        if (this.resourceFilter == null) {
            if (this.superClass != null) {
                return this.superClass.getResourceFilter();
            }
            return 0;
        }
        return this.resourceFilter;
    }

    public IConfigurationElement getApplicabilityCalculatorElement() {
        if (this.applicabilityCalculatorElement == null && this.superClass != null) {
            return ((Option)this.superClass).getApplicabilityCalculatorElement();
        }
        return this.applicabilityCalculatorElement;
    }

    public IOptionApplicability getApplicabilityCalculator() {
        if (this.applicabilityCalculator != null) {
            return this.applicabilityCalculator;
        }
        IConfigurationElement element = this.getApplicabilityCalculatorElement();
        if (element != null) {
            try {
                if (element.getAttribute("applicabilityCalculator") != null) {
                    this.applicabilityCalculator = (IOptionApplicability)element.createExecutableExtension("applicabilityCalculator");
                    return this.applicabilityCalculator;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public String[] getBuiltIns() {
        if (this.builtIns == null) {
            if (this.superClass != null) {
                return this.superClass.getBuiltIns();
            }
            return EMPTY_STRING_ARRAY;
        }
        return this.builtIns.toArray(new String[this.builtIns.size()]);
    }

    public IOptionCategory getCategory() {
        if (this.category == null) {
            if (this.superClass != null) {
                return this.superClass.getCategory();
            }
            if (this.getOptionHolder() instanceof ITool) {
                return ((ITool)this.getOptionHolder()).getTopOptionCategory();
            }
            return null;
        }
        return this.category;
    }

    public String getCommand() {
        if (this.command == null) {
            if (this.superClass != null) {
                return this.superClass.getCommand();
            }
            return EMPTY_STRING;
        }
        return this.command;
    }

    public String getCommandFalse() {
        if (this.commandFalse == null) {
            if (this.superClass != null) {
                return this.superClass.getCommandFalse();
            }
            return EMPTY_STRING;
        }
        return this.commandFalse;
    }

    public String[] getDefinedSymbols() throws BuildException {
        if (this.getValueType() != 5) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.getValue();
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    public String getEnumCommand(String id) throws BuildException {
        if (id == null) {
            return EMPTY_STRING;
        }
        if (this.enumList == null) {
            if (this.superClass != null) {
                return this.superClass.getEnumCommand(id);
            }
            return EMPTY_STRING;
        }
        if (this.getValueType() != 1) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        String cmd = (String)this.getEnumCommandMap().get(id);
        if (cmd == null) {
            ListIterator iter = this.enumList.listIterator();
            while (iter.hasNext()) {
                String realID = (String)iter.next();
                String name = (String)this.getEnumNameMap().get(realID);
                if (!id.equals(name)) continue;
                cmd = (String)this.getEnumCommandMap().get(realID);
                break;
            }
        }
        return cmd == null ? EMPTY_STRING : cmd;
    }

    public String getEnumName(String id) throws BuildException {
        if (id == null) {
            return EMPTY_STRING;
        }
        if (this.enumList == null) {
            if (this.superClass != null) {
                return this.superClass.getEnumName(id);
            }
            return EMPTY_STRING;
        }
        if (this.getValueType() != 1) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        String name = (String)this.getEnumNameMap().get(id);
        if (name == null) {
            name = id;
        }
        return name;
    }

    private Map getEnumCommandMap() {
        if (this.enumCommands == null) {
            this.enumCommands = new HashMap();
        }
        return this.enumCommands;
    }

    public String getEnumeratedId(String name) throws BuildException {
        if (name == null) {
            return null;
        }
        if (this.enumList == null) {
            if (this.superClass != null) {
                return this.superClass.getEnumeratedId(name);
            }
            return EMPTY_STRING;
        }
        if (this.getValueType() != 1) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        Set idSet = this.getEnumNameMap().keySet();
        Iterator iter = idSet.iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            String enumName = (String)this.getEnumNameMap().get(id);
            if (!name.equals(enumName)) continue;
            return id;
        }
        return null;
    }

    private Map getEnumNameMap() {
        if (this.enumNames == null) {
            this.enumNames = new HashMap();
        }
        return this.enumNames;
    }

    public String[] getIncludePaths() throws BuildException {
        if (this.getValueType() != 4) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.getValue();
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    public String[] getLibraries() throws BuildException {
        if (this.getValueType() != 6) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.getValue();
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    public String getSelectedEnum() throws BuildException {
        if (this.getValueType() != 1) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        return this.getStringValue();
    }

    public String[] getStringListValue() throws BuildException {
        if (this.getValueType() != 3) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.getValue();
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    public String getStringValue() throws BuildException {
        if (this.getValueType() != 2 && this.getValueType() != 1) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        return this.getValue() == null ? EMPTY_STRING : (String)this.getValue();
    }

    public String[] getUserObjects() throws BuildException {
        if (this.getValueType() != 7) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.getValue();
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    public int getValueType() throws BuildException {
        if (this.valueType == null) {
            if (this.superClass != null) {
                return this.superClass.getValueType();
            }
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        return this.valueType;
    }

    public Object getValue() {
        Serializable val = this.getRawValue();
        if (val == null && (val = this.getDefaultValue()) == null) {
            int valType;
            try {
                valType = this.getValueType();
            }
            catch (BuildException buildException) {
                return EMPTY_STRING;
            }
            switch (valType) {
                case 0: {
                    val = new Boolean(false);
                    break;
                }
                case 2: {
                    val = EMPTY_STRING;
                    break;
                }
                case 1: {
                    val = EMPTY_STRING;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    val = new ArrayList();
                    break;
                }
                default: {
                    val = EMPTY_STRING;
                }
            }
        }
        return val;
    }

    public Object getRawValue() {
        if (this.value == null && this.superClass != null) {
            Option mySuperClass = (Option)this.superClass;
            return mySuperClass.getRawValue();
        }
        return this.value;
    }

    public Object getDefaultValue() {
        if (this.defaultValue == null && this.superClass != null) {
            return this.superClass.getDefaultValue();
        }
        return this.defaultValue;
    }

    public void setDefaultValue(Object v) {
        this.defaultValue = v;
        this.setDirty(true);
    }

    public void setCategory(IOptionCategory category) {
        if (this.category != category) {
            this.category = category;
            this.categoryId = category != null ? category.getId() : null;
            this.setDirty(true);
        }
    }

    public void setCommand(String cmd) {
        if (cmd == null && this.command == null) {
            return;
        }
        if (cmd == null || this.command == null || !cmd.equals(this.command)) {
            this.command = cmd;
            this.isDirty = true;
        }
    }

    public void setCommandFalse(String cmd) {
        if (cmd == null && this.commandFalse == null) {
            return;
        }
        if (cmd == null || this.commandFalse == null || !cmd.equals(this.commandFalse)) {
            this.commandFalse = cmd;
            this.isDirty = true;
        }
    }

    public void setResourceFilter(int filter) {
        if (this.resourceFilter == null || filter != this.resourceFilter) {
            this.resourceFilter = new Integer(filter);
            this.isDirty = true;
        }
    }

    public void setBrowseType(int type) {
        if (this.browseType == null || type != this.browseType) {
            this.browseType = new Integer(type);
            this.isDirty = true;
        }
    }

    public void setValue(boolean value) throws BuildException {
        if (this.isExtensionElement() || this.getValueType() != 0) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        this.value = new Boolean(value);
        this.setDirty(true);
    }

    public void setValue(String value) throws BuildException {
        if (this.isExtensionElement() || this.getValueType() != 2 && this.getValueType() != 1) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        this.value = value;
        this.setDirty(true);
    }

    public void setValue(String[] value) throws BuildException {
        if (this.isExtensionElement() || this.getValueType() != 3 && this.getValueType() != 4 && this.getValueType() != 5 && this.getValueType() != 6 && this.getValueType() != 7) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        this.value = new ArrayList<String>(Arrays.asList(value));
        this.setDirty(true);
    }

    public void setValue(Object v) {
        this.value = v;
        this.setDirty(true);
    }

    public void setValueType(int type) {
        if (this.valueType == null || this.valueType != type) {
            this.valueType = new Integer(type);
            this.setDirty(true);
        }
    }

    public IConfigurationElement getValueHandlerElement() {
        if (this.valueHandlerElement == null && this.superClass != null) {
            return ((Option)this.superClass).getValueHandlerElement();
        }
        return this.valueHandlerElement;
    }

    public void setValueHandlerElement(IConfigurationElement element) {
        this.valueHandlerElement = element;
        this.setDirty(true);
    }

    public IManagedOptionValueHandler getValueHandler() {
        if (this.valueHandler != null) {
            return this.valueHandler;
        }
        IConfigurationElement element = this.getValueHandlerElement();
        if (element != null) {
            try {
                if (element.getAttribute("valueHandler") != null) {
                    this.valueHandler = (IManagedOptionValueHandler)element.createExecutableExtension("valueHandler");
                    return this.valueHandler;
                }
            }
            catch (CoreException coreException) {
                ManagedBuildManager.OptionValueHandlerError(element.getAttribute("valueHandler"), this.getId());
                this.valueHandler = ManagedOptionValueHandler.getManagedOptionValueHandler();
                return this.valueHandler;
            }
        }
        return ManagedOptionValueHandler.getManagedOptionValueHandler();
    }

    public String getValueHandlerExtraArgument() {
        if (this.valueHandlerExtraArgument == null) {
            if (this.superClass != null) {
                return this.superClass.getValueHandlerExtraArgument();
            }
            return EMPTY_STRING;
        }
        return this.valueHandlerExtraArgument;
    }

    public void setValueHandlerExtraArgument(String extraArgument) {
        if (extraArgument == null && this.valueHandlerExtraArgument == null) {
            return;
        }
        if (extraArgument == null || this.valueHandlerExtraArgument == null || !extraArgument.equals(this.valueHandlerExtraArgument)) {
            this.valueHandlerExtraArgument = extraArgument;
            this.isDirty = true;
        }
    }

    public boolean isExtensionElement() {
        return this.isExtensionOption;
    }

    public boolean overridesOnlyValue() {
        return this.superClass != null && this.unusedChildren == null && this.browseType == null && (this.builtIns == null || this.builtIns.size() == 0) && this.category == null && this.categoryId == null && this.command == null && this.commandFalse == null && this.enumList == null && this.enumCommands == null && this.enumNames == null && this.defaultValue == null;
    }

    public boolean isDirty() {
        if (this.isExtensionOption) {
            return false;
        }
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.superClass = ManagedBuildManager.getExtensionOption(this.superClassId);
                if (this.superClass == null) {
                    ManagedBuildManager.OutputResolveError("superClass", this.superClassId, "option", this.getId());
                } else {
                    ((Option)this.superClass).resolveReferences();
                }
            }
            if (this.categoryId != null) {
                this.category = this.holder.getOptionCategory(this.categoryId);
                if (this.category == null) {
                    ManagedBuildManager.OutputResolveError("category", this.categoryId, "option", this.getId());
                }
            }
            try {
                IManagedConfigElement element = ManagedBuildManager.getConfigElement(this);
                switch (this.getValueType()) {
                    case 0: {
                        String val = element.getAttribute("value");
                        if (val != null) {
                            this.value = new Boolean(val);
                        }
                        if ((val = element.getAttribute("defaultValue")) != null) {
                            this.defaultValue = new Boolean(val);
                        }
                        break;
                    }
                    case 2: {
                        this.value = element.getAttribute("value");
                        this.defaultValue = element.getAttribute("defaultValue");
                        break;
                    }
                    case 1: {
                        this.value = element.getAttribute("value");
                        this.defaultValue = element.getAttribute("defaultValue");
                        IManagedConfigElement[] enumElements = element.getChildren("enumeratedOptionValue");
                        int i = 0;
                        while (i < enumElements.length) {
                            String optId = enumElements[i].getAttribute("id");
                            if (i == 0) {
                                this.enumList = new ArrayList();
                                if (this.defaultValue == null) {
                                    this.defaultValue = optId;
                                }
                            }
                            this.enumList.add(optId);
                            this.getEnumCommandMap().put(optId, enumElements[i].getAttribute("command"));
                            this.getEnumNameMap().put(optId, enumElements[i].getAttribute("name"));
                            Boolean isDefault = new Boolean(enumElements[i].getAttribute("isDefault"));
                            if (isDefault.booleanValue()) {
                                this.defaultValue = optId;
                            }
                            ++i;
                        }
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ArrayList<String> valueList = null;
                        IManagedConfigElement[] valueElements = element.getChildren("listOptionValue");
                        int i = 0;
                        while (i < valueElements.length) {
                            IManagedConfigElement valueElement;
                            Boolean isBuiltIn;
                            if (i == 0) {
                                valueList = new ArrayList<String>();
                                this.builtIns = new ArrayList();
                            }
                            if ((isBuiltIn = new Boolean((valueElement = valueElements[i]).getAttribute("builtIn"))).booleanValue()) {
                                this.builtIns.add(valueElement.getAttribute("value"));
                            } else {
                                valueList.add(valueElement.getAttribute("value"));
                            }
                            ++i;
                        }
                        this.value = valueList;
                        break;
                    }
                }
            }
            catch (BuildException buildException) {}
        }
    }

    public String getManagedBuildRevision() {
        if (this.managedBuildRevision == null && this.getParent() != null) {
            return this.getParent().getManagedBuildRevision();
        }
        return this.managedBuildRevision;
    }

    protected boolean isAbstract() {
        if (this.isAbstract != null) {
            return this.isAbstract;
        }
        return false;
    }

    private void verify() {
        if (this.verified) {
            return;
        }
        this.verified = true;
        if (this.getOptionHolder() instanceof IToolChain && !this.isAbstract()) {
            if (this.getCategory() == null) {
                ManagedBuildManager.OptionValidError(0, this.getId());
                this.isValid = false;
            }
            if (this.resourceFilter != null) {
                switch (this.getResourceFilter()) {
                    case 1: {
                        ManagedBuildManager.OptionValidError(1, this.getId());
                        this.isValid = false;
                    }
                }
            }
        }
    }

    public boolean isValid() {
        if (!this.verified && this.resolved) {
            this.verify();
        }
        return this.isValid;
    }

    public PluginVersionIdentifier getVersion() {
        if (this.version == null && this.getParent() != null) {
            return this.getParent().getVersion();
        }
        return this.version;
    }

    public void setVersion(PluginVersionIdentifier version) {
    }
}

