/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import java.io.IOException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.core.search.ILineLocatable;
import org.eclipse.cdt.core.search.IMatchLocatable;
import org.eclipse.cdt.core.search.IOffsetLocatable;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class SelectionParseAction
extends Action {
    private static final String OPERATOR = "operator";
    protected static final String CSEARCH_OPERATION_NO_NAMES_SELECTED_MESSAGE = "CSearchOperation.noNamesSelected.message";
    protected static final String CSEARCH_OPERATION_OPERATION_UNAVAILABLE_MESSAGE = "CSearchOperation.operationUnavailable.message";
    protected static final String CSEARCH_OPERATION_NO_DEFINITION_MESSAGE = "CSearchOperation.noDefinitionFound.message";
    protected static final String CSEARCH_OPERATION_NO_DECLARATION_MESSAGE = "CSearchOperation.noDeclarationFound.message";
    protected IWorkbenchSite fSite;
    protected CEditor fEditor;
    String projectName = "";

    public SelectionParseAction() {
    }

    public SelectionParseAction(CEditor editor) {
        this.fEditor = editor;
        this.fSite = editor.getSite();
    }

    public SelectionParseAction(IWorkbenchSite site) {
        this.fSite = site;
    }

    protected IParser setupParser(IFile resourceFile) {
        IWorkingCopy[] workingCopies;
        IScannerInfo buildScanInfo;
        IProject currentProject = resourceFile.getProject();
        ScannerInfo scanInfo = new ScannerInfo();
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(currentProject);
        if (provider != null && (buildScanInfo = provider.getScannerInformation((IResource)resourceFile)) != null) {
            scanInfo = new ScannerInfo(buildScanInfo.getDefinedSymbols(), buildScanInfo.getIncludePaths());
        }
        ParserLanguage language = CoreModel.hasCCNature((IProject)currentProject) ? ParserLanguage.CPP : ParserLanguage.C;
        IWorkingCopy workingCopy = null;
        if (this.fEditor.isDirty() && (workingCopies = CUIPlugin.getSharedWorkingCopies()) != null) {
            int i = 0;
            while (i < workingCopies.length) {
                if (workingCopies[i].getUnderlyingResource().equals((Object)resourceFile)) {
                    workingCopy = workingCopies[i];
                    break;
                }
                ++i;
            }
        }
        IParser parser = null;
        CodeReader reader = null;
        try {
            reader = workingCopy == null ? new CodeReader(resourceFile.getLocation().toOSString(), resourceFile.getCharset()) : new CodeReader(resourceFile.getLocation().toOSString(), workingCopy.getContents());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            parser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((CodeReader)reader, (IScannerInfo)scanInfo, (ParserMode)ParserMode.SELECTION_PARSE, (ParserLanguage)language, (ISourceElementRequestor)new NullSourceElementRequestor(), (IParserLogService)ParserUtil.getScannerLogService(), null), (ISourceElementRequestor)new NullSourceElementRequestor(), (ParserMode)ParserMode.SELECTION_PARSE, (ParserLanguage)language, (IParserLogService)ParserUtil.getParserLogService());
        }
        catch (ParserFactoryError parserFactoryError) {}
        return parser;
    }

    protected void operationNotAvailable(final String message) {
        CUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IStatusLineManager statusManager = null;
                if (SelectionParseAction.this.fSite instanceof IViewSite) {
                    statusManager = ((IViewSite)SelectionParseAction.this.fSite).getActionBars().getStatusLineManager();
                } else if (SelectionParseAction.this.fSite instanceof IEditorSite) {
                    statusManager = ((IEditorSite)SelectionParseAction.this.fSite).getActionBars().getStatusLineManager();
                }
                if (statusManager != null) {
                    statusManager.setErrorMessage(CSearchMessages.getString(message));
                }
            }
        });
    }

    protected void clearStatusLine() {
        CUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IStatusLineManager statusManager = null;
                if (SelectionParseAction.this.fSite instanceof IViewSite) {
                    statusManager = ((IViewSite)SelectionParseAction.this.fSite).getActionBars().getStatusLineManager();
                } else if (SelectionParseAction.this.fSite instanceof IEditorSite) {
                    statusManager = ((IEditorSite)SelectionParseAction.this.fSite).getActionBars().getStatusLineManager();
                }
                if (statusManager != null) {
                    statusManager.setErrorMessage("");
                }
            }
        });
    }

    public SelSearchNode getSelection(int fPos) {
        IDocument doc;
        IDocumentProvider prov = this.fEditor != null ? this.fEditor.getDocumentProvider() : null;
        IDocument iDocument = doc = prov != null ? prov.getDocument((Object)this.fEditor.getEditorInput()) : null;
        if (doc == null) {
            return null;
        }
        int pos = fPos;
        int fStartPos = 0;
        int fEndPos = 0;
        int nonJavaStart = -1;
        int nonJavaEnd = -1;
        String selectedWord = null;
        try {
            char c;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (nonJavaStart == -1 && !Character.isJavaIdentifierPart(c)) {
                    nonJavaStart = pos + 1;
                }
                if (Character.isWhitespace(c)) break;
                --pos;
            }
            fStartPos = pos + 1;
            pos = fPos;
            int length = doc.getLength();
            while (pos < length) {
                c = doc.getChar(pos);
                if (nonJavaEnd == -1 && !Character.isJavaIdentifierPart(c)) {
                    nonJavaEnd = pos;
                }
                if (Character.isWhitespace(c)) break;
                ++pos;
            }
            fEndPos = pos;
            selectedWord = doc.get(fStartPos, fEndPos - fStartPos);
        }
        catch (BadLocationException badLocationException) {}
        SelSearchNode sel = new SelSearchNode();
        boolean selectedOperator = false;
        if (selectedWord != null && selectedWord.indexOf(OPERATOR) >= 0 && fPos >= fStartPos + selectedWord.indexOf(OPERATOR) && fPos < fStartPos + selectedWord.indexOf(OPERATOR) + OPERATOR.length()) {
            selectedOperator = true;
        }
        if (selectedOperator && this.fEditor.getEditorInput() instanceof IFileEditorInput && CoreModel.hasCCNature((IProject)((IFileEditorInput)this.fEditor.getEditorInput()).getFile().getProject())) {
            int actualStart = fStartPos + selectedWord.indexOf(OPERATOR);
            int actualEnd = this.getOperatorActualEnd(doc, fStartPos + selectedWord.indexOf(OPERATOR) + OPERATOR.length());
            actualEnd = actualEnd > 0 ? actualEnd : fEndPos;
            try {
                sel.selText = doc.get(actualStart, actualEnd - actualStart);
            }
            catch (BadLocationException badLocationException) {}
            sel.selStart = actualStart;
            sel.selEnd = actualEnd;
        } else if (selectedWord != null && selectedWord.indexOf(126) >= 0 && fPos - 2 >= fStartPos + selectedWord.lastIndexOf(new String(Keywords.cpCOLONCOLON))) {
            int tildePos = selectedWord.indexOf(126);
            int actualStart = fStartPos + tildePos;
            int length = 0;
            char[] lastSegment = selectedWord.substring(tildePos).toCharArray();
            int i = 1;
            while (i < lastSegment.length) {
                char temp = lastSegment[i];
                if (!Character.isJavaIdentifierPart(temp)) {
                    length = i;
                    break;
                }
                ++i;
            }
            if (fPos >= actualStart + length) {
                try {
                    sel.selText = doc.get(nonJavaStart, nonJavaEnd - nonJavaStart);
                }
                catch (BadLocationException badLocationException) {}
                sel.selStart = nonJavaStart;
                sel.selEnd = nonJavaEnd;
            } else {
                try {
                    sel.selText = doc.get(actualStart, length);
                }
                catch (BadLocationException badLocationException) {}
                sel.selStart = actualStart;
                sel.selEnd = actualStart + length;
            }
        } else {
            try {
                sel.selText = doc.get(nonJavaStart, nonJavaEnd - nonJavaStart);
            }
            catch (BadLocationException badLocationException) {}
            sel.selStart = nonJavaStart;
            sel.selEnd = nonJavaEnd;
        }
        return sel;
    }

    private int getOperatorActualEnd(IDocument doc, int index) {
        int actualEnd = -1;
        boolean multiComment = false;
        boolean singleComment = false;
        int possibleEnd = -1;
        while (actualEnd == -1) {
            try {
                char c1 = doc.getChar(index);
                char c2 = doc.getChar(index + 1);
                if (singleComment) {
                    char c3 = doc.getChar(index - 1);
                    if (c3 != '\\' && (c1 == '\n' || c1 == '\r' && c2 == '\n')) {
                        singleComment = false;
                    }
                    ++index;
                    continue;
                }
                if (multiComment) {
                    if (c1 == '*' && c2 == '/') {
                        multiComment = false;
                        index += 2;
                        continue;
                    }
                    ++index;
                    continue;
                }
                block1 : switch (c1) {
                    case '+': {
                        switch (c2) {
                            case '+': 
                            case '=': {
                                actualEnd = index + 2;
                                break block1;
                            }
                        }
                        actualEnd = index + 1;
                        break;
                    }
                    case '-': {
                        switch (c2) {
                            case '=': {
                                actualEnd = index + 2;
                                break block1;
                            }
                            case '-': {
                                switch (doc.getChar(index + 2)) {
                                    case '>': {
                                        switch (doc.getChar(index + 3)) {
                                            case '*': {
                                                actualEnd = index + 4;
                                                break block1;
                                            }
                                        }
                                        actualEnd = index + 3;
                                        break block1;
                                    }
                                }
                                actualEnd = index + 2;
                                break block1;
                            }
                        }
                        break;
                    }
                    case '|': {
                        switch (c2) {
                            case '=': 
                            case '|': {
                                actualEnd = index + 2;
                                break block1;
                            }
                        }
                        actualEnd = index + 1;
                        break;
                    }
                    case '&': {
                        switch (c2) {
                            case '&': 
                            case '=': {
                                actualEnd = index + 2;
                                break block1;
                            }
                        }
                        actualEnd = index + 1;
                        break;
                    }
                    case '/': {
                        switch (c2) {
                            case '/': {
                                singleComment = true;
                                index += 2;
                                break block1;
                            }
                            case '*': {
                                multiComment = true;
                                index += 2;
                                break block1;
                            }
                            case '=': {
                                actualEnd = index + 2;
                                break block1;
                            }
                        }
                        actualEnd = index + 1;
                        break;
                    }
                    case '!': 
                    case '%': 
                    case '*': 
                    case '=': 
                    case '^': {
                        switch (c2) {
                            case '=': {
                                actualEnd = index + 2;
                                break block1;
                            }
                        }
                        actualEnd = index + 1;
                        break;
                    }
                    case '(': {
                        if (possibleEnd > 0) {
                            actualEnd = possibleEnd;
                        }
                        ++index;
                        break;
                    }
                    case ')': 
                    case ',': 
                    case ']': 
                    case '~': {
                        actualEnd = index + 1;
                        break;
                    }
                    case '<': {
                        switch (c2) {
                            case '<': 
                            case '=': {
                                switch (doc.getChar(index + 2)) {
                                    case '=': {
                                        actualEnd = index + 3;
                                        break block1;
                                    }
                                }
                                actualEnd = index + 2;
                                break block1;
                            }
                        }
                        actualEnd = index;
                        break;
                    }
                    case '>': {
                        switch (c2) {
                            case '=': 
                            case '>': {
                                switch (doc.getChar(index + 2)) {
                                    case '=': {
                                        actualEnd = index + 3;
                                        break block1;
                                    }
                                }
                                actualEnd = index + 2;
                                break block1;
                            }
                        }
                        actualEnd = index;
                        break;
                    }
                    case 'n': {
                        while (doc.getChar(++index) != 'w') {
                        }
                        possibleEnd = ++index;
                        break;
                    }
                    case 'd': {
                        while (doc.getChar(++index) != 't' && doc.getChar(index + 1) != 'e') {
                        }
                        possibleEnd = index += 2;
                        break;
                    }
                    default: {
                        ++index;
                        break;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
        }
        return actualEnd;
    }

    protected SelSearchNode getSelection(ITextSelection textSelection) {
        if (textSelection == null) {
            return null;
        }
        String seltext = textSelection.getText();
        SelSearchNode sel = null;
        if (seltext == null || seltext.length() == 0) {
            int selStart = textSelection.getOffset();
            sel = this.getSelection(selStart);
        } else {
            sel = new SelSearchNode();
            sel.selText = seltext;
            sel.selStart = textSelection.getOffset();
            sel.selEnd = textSelection.getOffset() + textSelection.getLength();
        }
        return sel;
    }

    protected ISelection getSelection() {
        ISelection sel = null;
        if (this.fSite != null && this.fSite.getSelectionProvider() != null) {
            sel = this.fSite.getSelectionProvider().getSelection();
        }
        return sel;
    }

    protected SelSearchNode getSelectedStringFromEditor() {
        ISelection selection = this.getSelection();
        if (selection == null || !(selection instanceof ITextSelection)) {
            return null;
        }
        return this.getSelection((ITextSelection)selection);
    }

    protected boolean open(String filename, IMatchLocatable locatable) throws PartInitException, CModelException {
        Path path = new Path(filename);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        if (file != null) {
            this.open((IResource)file, locatable);
            return true;
        }
        ICProject cproject = CoreModel.getDefault().getCModel().getCProject(this.projectName);
        ITranslationUnit unit = CoreModel.getDefault().createTranslationUnitFrom(cproject, (IPath)path);
        if (unit != null) {
            this.setSelectionAtOffset(EditorUtility.openInEditor(unit), locatable);
            return true;
        }
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path);
        int i = 0;
        while (i < files.length) {
            if (files[i] != null) {
                this.open((IResource)files[i], locatable);
                return true;
            }
            ++i;
        }
        FileStorage storage = new FileStorage(null, (IPath)path);
        IEditorPart part = EditorUtility.openInEditor(storage);
        this.setSelectionAtOffset(part, locatable);
        return true;
    }

    protected Shell getShell() {
        return this.fEditor.getSite().getShell();
    }

    protected void open(IResource resource, IMatchLocatable locatable) throws CModelException, PartInitException {
        IEditorPart part = EditorUtility.openInEditor(resource);
        this.setSelectionAtOffset(part, locatable);
    }

    protected void setSelectionAtOffset(IEditorPart part, IMatchLocatable locatable) {
        if (part instanceof AbstractTextEditor) {
            int startOffset = 0;
            int length = 0;
            if (locatable instanceof IOffsetLocatable) {
                startOffset = ((IOffsetLocatable)locatable).getNameStartOffset();
                length = ((IOffsetLocatable)locatable).getNameEndOffset() - startOffset;
            } else if (locatable instanceof ILineLocatable) {
                int tempstartOffset = ((ILineLocatable)locatable).getStartLine();
                IDocument doc = ((AbstractTextEditor)part).getDocumentProvider().getDocument((Object)part.getEditorInput());
                try {
                    startOffset = doc.getLineOffset(tempstartOffset - 1);
                    length = doc.getLineLength(tempstartOffset - 1);
                }
                catch (BadLocationException badLocationException) {}
                int tempendOffset = ((ILineLocatable)locatable).getEndLine();
                if (tempendOffset > 0 && tempendOffset > tempstartOffset) {
                    try {
                        int endOffset = doc.getLineOffset(tempendOffset - 1);
                        length = endOffset - startOffset;
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            try {
                ((AbstractTextEditor)part).selectAndReveal(startOffset, length);
            }
            catch (Exception exception) {}
        }
    }

    public void update() {
        this.setEnabled(this.getSelectedStringFromEditor() != null);
    }

    protected class SelSearchNode {
        public String selText;
        public int selStart;
        public int selEnd;

        protected SelSearchNode() {
        }
    }

    protected static class Storage {
        private IResource resource;
        private String fileName;
        private IMatchLocatable locatable;

        public final String getFileName() {
            return this.fileName;
        }

        public final IResource getResource() {
            return this.resource;
        }

        public final IMatchLocatable getLocatable() {
            return this.locatable;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setLocatable(IMatchLocatable locatable) {
            this.locatable = locatable;
        }

        public void setResource(IResource resource) {
            this.resource = resource;
        }
    }
}

