/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionSpecialization;

public class CPPMethodSpecialization
extends CPPFunctionSpecialization
implements ICPPMethod {
    public CPPMethodSpecialization(IBinding orig, ICPPScope scope, ObjectMap argMap) {
        super(orig, scope, argMap);
    }

    public boolean isVirtual() throws DOMException {
        ICPPMethod f = (ICPPMethod)this.getSpecializedBinding();
        if (f != null) {
            return f.isVirtual();
        }
        IASTNode definition = this.getDefinition();
        if (definition != null) {
            IASTNode node = definition.getParent();
            while (node instanceof IASTDeclarator) {
                node = node.getParent();
            }
            ICPPASTDeclSpecifier declSpec = null;
            if (node instanceof IASTSimpleDeclaration) {
                declSpec = (ICPPASTDeclSpecifier)((IASTSimpleDeclaration)node).getDeclSpecifier();
            } else if (node instanceof IASTFunctionDefinition) {
                declSpec = (ICPPASTDeclSpecifier)((IASTFunctionDefinition)node).getDeclSpecifier();
            }
            if (declSpec != null) {
                return declSpec.isVirtual();
            }
        }
        return false;
    }

    public int getVisibility() throws DOMException {
        ICPPMethod f = (ICPPMethod)this.getSpecializedBinding();
        if (f != null) {
            return f.getVisibility();
        }
        return 0;
    }

    public boolean isDestructor() {
        char[] name = this.getNameCharArray();
        return name.length > 1 && name[0] == '~';
    }
}

