/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.ctagsindexer;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.cindexstorage.CIndexStorage;
import org.eclipse.cdt.internal.core.index.cindexstorage.Util;
import org.eclipse.cdt.internal.core.index.ctagsindexer.CTagsFileReader;
import org.eclipse.cdt.internal.core.index.ctagsindexer.CTagsIndexRequest;
import org.eclipse.cdt.internal.core.index.ctagsindexer.CTagsIndexer;
import org.eclipse.cdt.internal.core.index.ctagsindexer.CTagsSaveIndex;
import org.eclipse.cdt.internal.core.index.domsourceindexer.AbstractIndexerRunner;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

class CTagsIndexAll
extends CTagsIndexRequest {
    IProject project;
    private String ctagsFile;
    private String ctagsFileToUse;
    private String ctagsLocation;

    public CTagsIndexAll(IProject project, CTagsIndexer indexer) {
        super(project.getFullPath(), indexer);
        this.project = project;
        this.ctagsFile = CCorePlugin.getDefault().getStateLocation().append(String.valueOf(project.getName()) + ".ctags").toOSString();
    }

    public boolean equals(Object o) {
        if (o instanceof CTagsIndexAll) {
            return this.project.equals((Object)((CTagsIndexAll)o).project);
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        if (!this.project.isAccessible()) {
            return true;
        }
        IIndex index = this.indexer.getIndex(this.indexPath, true, true);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = this.indexer.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterRead();
                this.saveIfNecessary(index, monitor);
                long startTime = 0L;
                long cTagsEndTime = 0L;
                long endTime = 0L;
                try {
                    this.project.deleteMarkers("org.eclipse.cdt.core.indexermarker", true, 0);
                }
                catch (CoreException coreException) {}
                boolean success = false;
                if (this.useInternalCTagsFile()) {
                    if (AbstractIndexerRunner.TIMING) {
                        startTime = System.currentTimeMillis();
                    }
                    success = this.runCTags(this.project.getLocation());
                    this.ctagsFileToUse = this.ctagsFile;
                    if (AbstractIndexerRunner.TIMING) {
                        cTagsEndTime = System.currentTimeMillis();
                        System.out.println("CTags Run: " + (cTagsEndTime - startTime));
                        System.out.flush();
                    }
                } else {
                    success = this.getCTagsFileLocation();
                }
                if (success) {
                    CTagsFileReader reader = new CTagsFileReader(this.project, this.ctagsFileToUse, this.indexer);
                    reader.setIndex(index);
                    reader.setRootDirectory(this.project.getLocation());
                    reader.parse();
                    this.indexer.request(new CTagsSaveIndex(this.indexPath, this.indexer));
                    if (AbstractIndexerRunner.TIMING) {
                        endTime = System.currentTimeMillis();
                        System.out.println("CTags Encoding Time: " + (endTime - cTagsEndTime));
                        System.out.println("CTagsIndexer Total Time: " + (endTime - startTime));
                        System.out.flush();
                    }
                }
                if (this.ctagIndexIncludes()) {
                    this.cTagsInclude(index);
                }
            }
            catch (IOException e) {
                if (IndexManager.VERBOSE) {
                    JobManager.verbose("-> failed to index " + this.project + " because of the following exception:");
                    e.printStackTrace();
                }
                this.indexer.removeIndex(this.indexPath);
                Object var12_10 = null;
                monitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            monitor.exitRead();
            throw throwable;
        }
        {
            Object var12_12 = null;
            monitor.exitRead();
            return true;
        }
    }

    private void cTagsInclude(IIndex index) {
        ICProject cProj = CoreModel.getDefault().create(this.project);
        IIncludeReference[] refs = new IIncludeReference[]{};
        try {
            refs = cProj.getIncludeReferences();
        }
        catch (CModelException cModelException) {}
        if (refs.length == 0) {
            return;
        }
        String[] pathString = new String[refs.length];
        int i = 0;
        while (i < refs.length) {
            pathString[i] = refs[i].getPath().toOSString();
            ++i;
        }
        Util.sort(pathString);
        HashSet<String> finalArray = new HashSet<String>();
        String currentString = null;
        int i2 = 0;
        while (i2 < refs.length) {
            if (currentString == null) {
                currentString = pathString[i2];
                finalArray.add(currentString);
            } else if (!pathString[i2].startsWith(currentString)) {
                currentString = pathString[i2];
                finalArray.add(currentString);
            }
            ++i2;
        }
        finalArray.add(currentString);
        Iterator iter = finalArray.iterator();
        while (iter.hasNext()) {
            Path newPath = new Path((String)iter.next());
            this.runCTags((IPath)newPath);
            this.ctagsFileToUse = this.ctagsFile;
            CTagsFileReader reader = new CTagsFileReader(this.project, this.ctagsFileToUse, this.indexer);
            reader.setRootDirectory((IPath)newPath);
            reader.setIndex(index);
            reader.parse();
        }
        this.indexer.request(new CTagsSaveIndex(this.indexPath, this.indexer));
    }

    private void sortPathArray(IPath[] paths) {
        if (paths.length <= 1) {
            return;
        }
        int i = 0;
        while (i < paths.length) {
            ++i;
        }
    }

    private boolean runCTags(IPath directoryToRunFrom) {
        String[] args = new String[]{"--excmd=number", "--format=2", "--sort=no", "--fields=aiKlmnsSz", "--c-types=cdefgmnpstuvx", "--c++-types=cdefgmnpstuvx", "--languages=c,c++", "-f", this.ctagsFile, "-R"};
        try {
            Process p;
            File tagsFile = new File(this.ctagsFile);
            if (tagsFile.exists()) {
                tagsFile.delete();
            }
            CommandLauncher launcher = new CommandLauncher();
            launcher.showCommand(true);
            Path ctagsExecutable = new Path("ctags");
            if (!this.useDefaultCTags() && this.getCTagsLocation()) {
                ctagsExecutable = new Path(this.ctagsLocation);
            }
            if ((p = launcher.execute((IPath)ctagsExecutable, args, null, directoryToRunFrom)) == null) {
                this.indexer.createProblemMarker(CCorePlugin.getResourceString("CTagsIndexMarker.CTagsMissing"), this.project);
                return false;
            }
            p.waitFor();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    protected Integer updatedIndexState() {
        return CIndexStorage.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing project " + this.project.getFullPath();
    }

    private boolean useInternalCTagsFile() {
        try {
            ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(this.project, false);
            if (cdesc == null) {
                return true;
            }
            ICExtensionReference[] cext = cdesc.get("org.eclipse.cdt.core.CIndexer");
            if (cext.length > 0) {
                int i = 0;
                while (i < cext.length) {
                    cext[i].getID();
                    String orig = cext[i].getExtensionData("ctagfiletype");
                    if (orig != null) {
                        if (orig.equals("ctags_internal")) {
                            return true;
                        }
                        if (orig.equals("ctags_external")) {
                            return false;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private boolean useDefaultCTags() {
        try {
            ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(this.project, false);
            if (cdesc == null) {
                return true;
            }
            ICExtensionReference[] cext = cdesc.get("org.eclipse.cdt.core.CIndexer");
            if (cext.length > 0) {
                int i = 0;
                while (i < cext.length) {
                    String orig = cext[i].getExtensionData("ctagslocationtype");
                    if (orig != null) {
                        if (orig.equals("ctags_path_default")) {
                            return true;
                        }
                        if (orig.equals("ctags_path_specified")) {
                            return false;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private boolean getCTagsLocation() {
        try {
            ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(this.project, false);
            if (cdesc == null) {
                return false;
            }
            ICExtensionReference[] cext = cdesc.get("org.eclipse.cdt.core.CIndexer");
            if (cext.length > 0) {
                int i = 0;
                while (i < cext.length) {
                    String orig = cext[i].getExtensionData("ctagslocation");
                    if (orig != null) {
                        this.ctagsLocation = orig;
                        return true;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private boolean ctagIndexIncludes() {
        try {
            ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(this.project, false);
            if (cdesc == null) {
                return true;
            }
            ICExtensionReference[] cext = cdesc.get("org.eclipse.cdt.core.CIndexer");
            if (cext.length > 0) {
                int i = 0;
                while (i < cext.length) {
                    cext[i].getID();
                    String orig = cext[i].getExtensionData("ctagsindexincludes");
                    if (orig != null) {
                        return new Boolean(orig);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private boolean getCTagsFileLocation() {
        try {
            ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(this.project, false);
            if (cdesc == null) {
                return false;
            }
            ICExtensionReference[] cext = cdesc.get("org.eclipse.cdt.core.CIndexer");
            if (cext.length > 0) {
                int i = 0;
                while (i < cext.length) {
                    cext[i].getID();
                    String orig = cext[i].getExtensionData("ctagfilelocation");
                    if (orig != null) {
                        this.ctagsFileToUse = orig;
                        return true;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return false;
    }
}

