/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.wizards.NewManagedProjectOptionPage;
import org.eclipse.cdt.managedbuilder.ui.wizards.NewManagedProjectWizard;
import org.eclipse.cdt.ui.dialogs.AbstractErrorParserBlock;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;

public class ErrorParserBlock
extends AbstractErrorParserBlock {
    protected String[] getErrorParserIDs(IConfiguration config) {
        String[] errorParsers = config.getErrorParserList();
        if (errorParsers != null) {
            return errorParsers;
        }
        return CCorePlugin.getDefault().getAllErrorParsersIDs();
    }

    protected String[] getErrorParserIDs(IProject project) {
        IConfiguration config = ManagedBuildManager.getSelectedConfiguration((IProject)project);
        if (config == null) {
            IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
            config = info.getDefaultConfiguration();
        }
        if (config != null) {
            return this.getErrorParserIDs(config);
        }
        return CCorePlugin.getDefault().getAllErrorParsersIDs();
    }

    protected String[] getErrorParserIDs() {
        ICOptionContainer container = this.getContainer();
        if (container instanceof NewManagedProjectOptionPage) {
            NewManagedProjectOptionPage parent = (NewManagedProjectOptionPage)this.getContainer();
            NewManagedProjectWizard wizard = (NewManagedProjectWizard)parent.getWizard();
            IProjectType proj = wizard.getSelectedProjectType();
            IConfiguration[] configs = proj.getConfigurations();
            if (configs.length > 0) {
                return this.getErrorParserIDs(configs[0]);
            }
            return new String[0];
        }
        return CCorePlugin.getDefault().getAllErrorParsersIDs();
    }

    public void saveErrorParsers(IProject project, String[] parsers) {
        IConfiguration config = ManagedBuildManager.getSelectedConfiguration((IProject)project);
        if (config != null) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < parsers.length) {
                if (i > 0) {
                    buf.append(';');
                }
                buf.append(parsers[i]);
                ++i;
            }
            config.setErrorParserIds(buf.toString());
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return null;
    }

    protected void setValues() {
        super.setValues();
        this.listDirty = false;
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        super.performApply(monitor);
        this.listDirty = false;
    }

    public void setDirty(boolean b) {
        this.listDirty = b;
    }

    public boolean isDirty() {
        return this.listDirty;
    }
}

