/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildToolsSettingsStore;
import org.eclipse.cdt.managedbuilder.ui.properties.FileListControl;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class FileListControlFieldEditor
extends FieldEditor {
    private FileListControl list;
    private int browseType;
    private GridLayout layout;
    private static final String DEFAULT_SEPERATOR = ";";
    private String[] values = null;

    public FileListControlFieldEditor(String name, String labelText, Composite parent, int type) {
        super(name, labelText, parent);
        this.browseType = type;
        this.list.setType(type);
    }

    public FileListControlFieldEditor(String name, String labelText, Composite parent, String value, int type) {
        this(name, labelText, parent, type);
        this.browseType = type;
        this.values = this.parseString(value);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Composite topLayout = new Composite(parent, 0);
        this.layout = new GridLayout();
        this.layout.numColumns = numColumns;
        this.layout.marginWidth = 7;
        this.layout.marginHeight = 5;
        this.layout.makeColumnsEqualWidth = false;
        topLayout.setLayout((Layout)this.layout);
        GridData gddata = new GridData(768);
        gddata.horizontalSpan = 2;
        topLayout.setLayoutData((Object)gddata);
        this.list = new FileListControl(topLayout, this.getLabelText(), this.getType());
        topLayout.setLayout((Layout)this.layout);
    }

    private int getType() {
        return this.browseType;
    }

    protected List getListControl() {
        return this.list.getListControl();
    }

    protected void doLoad() {
        IPreferenceStore store;
        if (this.list != null && (store = this.getPreferenceStore()) != null) {
            IResource project;
            IConfiguration config;
            String s = store.getString(this.getPreferenceName());
            String[] array = this.parseString(s);
            this.list.setList(array);
            this.list.setSelection(0);
            if (store instanceof BuildToolsSettingsStore && (config = ((BuildToolsSettingsStore)store).getOwner()) != null && (project = config.getOwner()) != null) {
                this.list.setPath(project.getLocation());
            }
        }
        this.list.selectionChanged();
    }

    protected void doLoadDefault() {
        if (this.list != null) {
            this.list.removeAll();
            String s = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            String[] array = this.parseString(s);
            this.list.setList(array);
            this.list.selectionChanged();
        }
    }

    protected void doStore() {
        String s = this.createList(this.list.getItems());
        if (s != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), s);
        }
    }

    public int getNumberOfControls() {
        return 1;
    }

    private String createList(String[] items) {
        StringBuffer path = new StringBuffer("");
        int i = 0;
        while (i < items.length) {
            path.append(items[i]);
            if (i < items.length - 1) {
                path.append(DEFAULT_SEPERATOR);
            }
            ++i;
        }
        return path.toString();
    }

    private String[] parseString(String stringList) {
        StringTokenizer tokenizer = new StringTokenizer(stringList, DEFAULT_SEPERATOR);
        ArrayList<Object> list = new ArrayList<Object>();
        while (tokenizer.hasMoreElements()) {
            list.add(tokenizer.nextElement());
        }
        return list.toArray(new String[list.size()]);
    }

    public void setStyle() {
        this.layout.marginWidth = 0;
    }

    protected void adjustForNumColumns(int numColumns) {
    }
}

