/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.cindexstorage;

import java.util.ArrayList;
import org.eclipse.cdt.internal.core.index.cindexstorage.IndexedFileEntry;

public final class IndexedFileEntryHashedArray {
    private IndexedFileEntry[] elements;
    private int elementSize;
    private int threshold;
    private int lastId;
    private ArrayList replacedElements;

    public IndexedFileEntryHashedArray(int size) {
        if (size < 7) {
            size = 7;
        }
        this.elements = new IndexedFileEntry[2 * size + 1];
        this.elementSize = 0;
        this.threshold = size + 1;
        this.lastId = 0;
        this.replacedElements = null;
    }

    public IndexedFileEntry add(String path) {
        return this.add(new IndexedFileEntry(path, ++this.lastId));
    }

    private IndexedFileEntry add(IndexedFileEntry file) {
        IndexedFileEntry current;
        int length = this.elements.length;
        String path = file.getPath();
        int index = (path.hashCode() & Integer.MAX_VALUE) % length;
        while ((current = this.elements[index]) != null) {
            if (current.getPath().equals(path)) {
                if (this.replacedElements == null) {
                    this.replacedElements = new ArrayList(5);
                }
                this.replacedElements.add(current);
                this.elements[index] = file;
                return this.elements[index];
            }
            if (++index != length) continue;
            index = 0;
        }
        this.elements[index] = file;
        if (++this.elementSize > this.threshold) {
            this.grow();
        }
        return file;
    }

    public IndexedFileEntry[] asArray() {
        IndexedFileEntry current;
        IndexedFileEntry[] array = new IndexedFileEntry[this.lastId];
        int i = 0;
        int length = this.elements.length;
        while (i < length) {
            current = this.elements[i];
            if (current != null) {
                array[current.getFileID() - 1] = current;
            }
            ++i;
        }
        if (this.replacedElements != null) {
            i = 0;
            length = this.replacedElements.size();
            while (i < length) {
                array[current.getFileID() - 1] = current = (IndexedFileEntry)this.replacedElements.get(i);
                ++i;
            }
        }
        return array;
    }

    public IndexedFileEntry get(String path) {
        IndexedFileEntry current;
        int length = this.elements.length;
        int index = (path.hashCode() & Integer.MAX_VALUE) % length;
        while ((current = this.elements[index]) != null) {
            if (current.getPath().equals(path)) {
                return current;
            }
            if (++index != length) continue;
            index = 0;
        }
        return null;
    }

    private void grow() {
        IndexedFileEntryHashedArray newArray = new IndexedFileEntryHashedArray(this.elementSize * 2);
        int i = 0;
        int length = this.elements.length;
        while (i < length) {
            if (this.elements[i] != null) {
                newArray.add(this.elements[i]);
            }
            ++i;
        }
        this.elements = newArray.elements;
        this.elementSize = newArray.elementSize;
        this.threshold = newArray.threshold;
    }

    public int size() {
        return this.elementSize + (this.replacedElements == null ? 0 : this.replacedElements.size());
    }

    public String toString() {
        String s = "";
        IndexedFileEntry[] files = this.asArray();
        int i = 0;
        int length = files.length;
        while (i < length) {
            s = String.valueOf(s) + files[i].toString() + "\n";
            ++i;
        }
        return s;
    }
}

