/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.ICDebugUIConstants;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionDelegate;

public class ToggleInstructionStepModeActionDelegate
extends ActionDelegate
implements IViewActionDelegate,
Preferences.IPropertyChangeListener {
    private ICDebugTarget fTarget = null;
    private IAction fAction = null;
    private IViewPart fView;

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        boolean value;
        IAction action = this.getAction();
        if (action != null && event.getNewValue() instanceof Boolean && (value = ((Boolean)event.getNewValue()).booleanValue()) != action.isChecked()) {
            action.setChecked(value);
        }
    }

    public void init(IViewPart view) {
        this.fView = view;
    }

    public void dispose() {
        ICDebugTarget target = this.getTarget();
        if (target != null) {
            target.removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        }
        this.setTarget(null);
        this.setAction(null);
    }

    public void init(IAction action) {
        this.setAction(action);
        action.setChecked(false);
        action.setEnabled(false);
    }

    public void run(IAction action) {
        boolean enabled = this.getAction().isChecked();
        ICDebugTarget target = this.getTarget();
        if (target != null) {
            target.enableInstructionStepping(enabled);
            if (enabled) {
                try {
                    this.getView().getSite().getPage().showView(ICDebugUIConstants.ID_DISASSEMBLY_VIEW);
                }
                catch (PartInitException e) {
                    CDebugUIPlugin.log(e.getStatus());
                }
            }
        }
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        ICDebugTarget oldTarget;
        ICDebugTarget newTarget = null;
        if (selection instanceof IStructuredSelection) {
            newTarget = this.getTargetFromSelection(((IStructuredSelection)selection).getFirstElement());
        }
        if ((oldTarget = this.getTarget()) != null && !oldTarget.equals(newTarget)) {
            oldTarget.removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
            this.setTarget(null);
            action.setChecked(false);
        }
        if (newTarget != null && !newTarget.isTerminated() && !newTarget.isDisconnected()) {
            this.setTarget(newTarget);
            newTarget.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
            action.setChecked(newTarget.isInstructionSteppingEnabled());
        }
        action.setEnabled(newTarget != null && newTarget.supportsInstructionStepping() && !newTarget.isTerminated() && !newTarget.isDisconnected());
    }

    private ICDebugTarget getTarget() {
        return this.fTarget;
    }

    private void setTarget(ICDebugTarget target) {
        this.fTarget = target;
    }

    private IAction getAction() {
        return this.fAction;
    }

    private void setAction(IAction action) {
        this.fAction = action;
    }

    private ICDebugTarget getTargetFromSelection(Object element) {
        if (element instanceof IDebugElement) {
            IDebugTarget target = ((IDebugElement)element).getDebugTarget();
            return target instanceof ICDebugTarget ? (ICDebugTarget)target : null;
        }
        return null;
    }

    private IViewPart getView() {
        return this.fView;
    }
}

