/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.cindexstorage;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.zip.CRC32;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.ICDTIndexer;
import org.eclipse.cdt.core.index.IIndexStorage;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.IndexRequest;
import org.eclipse.cdt.internal.core.index.cindexstorage.Index;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMIndexRequest;
import org.eclipse.cdt.internal.core.search.CWorkspaceScope;
import org.eclipse.cdt.internal.core.search.IndexSelector;
import org.eclipse.cdt.internal.core.search.SimpleLookupTable;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.IIndexJob;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class CIndexStorage
implements IIndexStorage {
    public static int MAX_FILES_IN_MEMORY = 0;
    public IWorkspace workspace;
    public SimpleLookupTable indexNames = new SimpleLookupTable();
    private IIndex index;
    private ReadWriteMonitor monitor;
    private boolean needToSave = false;
    private static final CRC32 checksumCalculator = new CRC32();
    private IPath cCorePluginLocation = null;
    private SimpleLookupTable indexStates = null;
    private File savedIndexNamesFile = new File(this.getCCorePluginWorkingLocation().append("savedIndexNames.txt").toOSString());
    private SimpleLookupTable encounteredHeaders = null;
    public static Integer SAVED_STATE = new Integer(0);
    public static Integer UPDATING_STATE = new Integer(1);
    public static Integer UNKNOWN_STATE = new Integer(2);
    public static Integer REBUILDING_STATE = new Integer(3);
    public static boolean VERBOSE = false;
    private ICDTIndexer indexer = null;
    private IndexManager indexManager = null;
    public ReadWriteMonitor indexAccessMonitor = null;

    public CIndexStorage(ICDTIndexer indexer) {
        this.indexer = indexer;
        this.indexManager = CCorePlugin.getDefault().getCoreModel().getIndexManager();
    }

    public void aboutToUpdateIndex(IPath path, Integer newIndexState) {
        Integer currentIndexState;
        String indexName = this.computeIndexName(path);
        Object state = this.getIndexStates().get(indexName);
        Integer n = currentIndexState = state == null ? UNKNOWN_STATE : (Integer)state;
        if (currentIndexState.equals(REBUILDING_STATE)) {
            return;
        }
        int compare = newIndexState.compareTo(currentIndexState);
        if (compare > 0) {
            this.updateIndexState(indexName, newIndexState);
        } else if (compare < 0 && this.index == null) {
            this.rebuildIndex(indexName, path);
        }
    }

    String computeIndexName(IPath path) {
        String name = (String)this.indexNames.get(path);
        if (name == null) {
            String pathString = path.toOSString();
            checksumCalculator.reset();
            checksumCalculator.update(pathString.getBytes());
            String fileName = String.valueOf(Long.toString(checksumCalculator.getValue())) + ".index";
            if (IndexManager.VERBOSE) {
                JobManager.verbose("-> index name for " + pathString + " is " + fileName);
            }
            name = this.getCCorePluginWorkingLocation().append(fileName).toOSString();
            this.indexNames.put(path, name);
        }
        return name;
    }

    public synchronized IIndex getIndex(IPath path, boolean reuseExistingFile, boolean createIfMissing) {
        if (this.index == null) {
            Integer currentIndexState;
            String indexName = this.computeIndexName(path);
            Object state = this.getIndexStates().get(indexName);
            Integer n = currentIndexState = state == null ? UNKNOWN_STATE : (Integer)state;
            if (currentIndexState == UNKNOWN_STATE) {
                this.rebuildIndex(indexName, path);
                return null;
            }
            if (reuseExistingFile) {
                File indexFile = new File(indexName);
                if (indexFile.exists()) {
                    try {
                        this.index = new Index(indexName, "Index for " + path.toOSString(), true, this.indexer);
                        this.monitor = new ReadWriteMonitor();
                        return this.index;
                    }
                    catch (IOException iOException) {
                        if (currentIndexState != REBUILDING_STATE) {
                            if (IndexManager.VERBOSE) {
                                JobManager.verbose("-> cannot reuse existing index: " + indexName + " path: " + path.toOSString());
                            }
                            this.rebuildIndex(indexName, path);
                            return null;
                        }
                        this.index = null;
                    }
                }
                if (currentIndexState == SAVED_STATE) {
                    this.rebuildIndex(indexName, path);
                    return null;
                }
            }
            if (createIfMissing) {
                try {
                    if (VERBOSE) {
                        JobManager.verbose("-> create empty index: " + indexName + " path: " + path.toOSString());
                    }
                    this.index = new Index(indexName, "Index for " + path.toOSString(), false, this.indexer);
                    this.monitor = new ReadWriteMonitor();
                    return this.index;
                }
                catch (IOException iOException) {
                    if (VERBOSE) {
                        JobManager.verbose("-> unable to create empty index: " + indexName + " path: " + path.toOSString());
                    }
                    return null;
                }
            }
        }
        return this.index;
    }

    private SimpleLookupTable getIndexStates() {
        if (this.indexStates != null) {
            return this.indexStates;
        }
        this.indexStates = new SimpleLookupTable();
        char[] savedIndexNames = this.readIndexState();
        if (savedIndexNames.length > 0) {
            char[][] names = CharOperation.splitOn('\n', savedIndexNames);
            int i = 0;
            int l = names.length;
            while (i < l) {
                char[] name = names[i];
                if (name.length > 0) {
                    this.indexStates.put(new String(name), SAVED_STATE);
                }
                ++i;
            }
        }
        return this.indexStates;
    }

    public SimpleLookupTable getEncounteredHeaders() {
        if (this.encounteredHeaders == null) {
            this.encounteredHeaders = new SimpleLookupTable();
        }
        return this.encounteredHeaders;
    }

    public void resetEncounteredHeaders() {
        this.encounteredHeaders = null;
    }

    private IPath getCCorePluginWorkingLocation() {
        if (this.cCorePluginLocation != null) {
            return this.cCorePluginLocation;
        }
        this.cCorePluginLocation = CCorePlugin.getDefault().getStateLocation();
        return this.cCorePluginLocation;
    }

    public ReadWriteMonitor getMonitorForIndex() {
        return this.monitor;
    }

    private void rebuildIndex(String indexName, IPath path) {
        IProject p;
        Object target = Util.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), path, true);
        if (target == null) {
            return;
        }
        if (IndexManager.VERBOSE) {
            JobManager.verbose("-> request to rebuild index: " + indexName + " path: " + path.toOSString());
        }
        this.updateIndexState(indexName, REBUILDING_STATE);
        IIndexJob request = null;
        if (target instanceof IProject && (p = (IProject)target).exists() && this.indexer.isIndexEnabled(p)) {
            this.indexer.addRequest(p, null, 1);
        }
        if (request != null) {
            this.indexManager.request(request);
        }
    }

    public synchronized IIndex recreateIndex(IPath path) {
        try {
            String indexPath = this.computeIndexName(path);
            if (IndexManager.VERBOSE) {
                JobManager.verbose("-> recreating index: " + indexPath + " for path: " + path.toOSString());
            }
            this.index = new Index(indexPath, "Index for " + path.toOSString(), false, this.indexer);
            return this.index;
        }
        catch (IOException e) {
            if (IndexManager.VERBOSE) {
                JobManager.verbose("-> failed to recreate index for path: " + path.toOSString());
                e.printStackTrace();
            }
            return null;
        }
    }

    public synchronized void removeIndex(IPath path) {
        String indexName;
        File indexFile;
        if (IndexManager.VERBOSE) {
            JobManager.verbose("removing index " + path);
        }
        if ((indexFile = new File(indexName = this.computeIndexName(path))).exists()) {
            indexFile.delete();
        }
        this.index = null;
        this.monitor = null;
        this.updateIndexState(indexName, null);
    }

    public synchronized void removeIndexFamily(IPath path) {
        this.removeIndex(path);
    }

    public void saveIndex(IIndex index) throws IOException {
        Object indexPath;
        if (index.hasChanged()) {
            if (IndexManager.VERBOSE) {
                JobManager.verbose("-> saving index " + index.getIndexFile());
            }
            index.save();
        }
        String indexName = index.getIndexFile().getPath();
        if (this.indexManager.getJobEnd() > this.indexManager.getJobStart() && (indexPath = this.indexNames.keyForValue(indexName)) != null) {
            int i = this.indexManager.getJobEnd();
            while (i > this.indexManager.getJobStart()) {
                IIndexJob job = this.indexManager.getAwaitingJobAt(i);
                if (job instanceof DOMIndexRequest && ((IndexRequest)job).getIndexPath().equals(indexPath)) {
                    return;
                }
                --i;
            }
        }
        this.updateIndexState(indexName, SAVED_STATE);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveIndexes() {
        ReadWriteMonitor monitor = this.getMonitorForIndex();
        if (monitor == null) {
            return;
        }
        try {
            monitor.enterWrite();
            try {
                this.saveIndex(this.index);
            }
            catch (IOException e) {
                if (IndexManager.VERBOSE) {
                    JobManager.verbose("-> got the following exception while saving:");
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.exitWrite();
            throw throwable;
        }
        {
            Object var3_5 = null;
            monitor.exitWrite();
            this.needToSave = false;
            return;
        }
    }

    public void shutdown() {
        File[] indexesFiles;
        File indexesDirectory;
        if (IndexManager.VERBOSE) {
            JobManager.verbose("Shutdown");
        }
        IndexSelector indexSelector = new IndexSelector(new CWorkspaceScope(), null, false, this.indexManager);
        IIndex[] selectedIndexes = indexSelector.getIndexes();
        SimpleLookupTable knownPaths = new SimpleLookupTable();
        int i = 0;
        int max = selectedIndexes.length;
        while (i < max) {
            String path = selectedIndexes[i].getIndexFile().getAbsolutePath();
            knownPaths.put(path, path);
            ++i;
        }
        if (this.indexStates != null) {
            Object[] indexNames = this.indexStates.keyTable;
            int i2 = 0;
            int l = indexNames.length;
            while (i2 < l) {
                String key = (String)indexNames[i2];
                if (key != null && !knownPaths.containsKey(key)) {
                    this.updateIndexState(key, null);
                }
                ++i2;
            }
        }
        if ((indexesDirectory = new File(this.getCCorePluginWorkingLocation().toOSString())).isDirectory() && (indexesFiles = indexesDirectory.listFiles()) != null) {
            int i3 = 0;
            int indexesFilesLength = indexesFiles.length;
            while (i3 < indexesFilesLength) {
                String fileName = indexesFiles[i3].getAbsolutePath();
                if (!knownPaths.containsKey(fileName) && fileName.toLowerCase().endsWith(".index")) {
                    if (IndexManager.VERBOSE) {
                        JobManager.verbose("Deleting index file " + indexesFiles[i3]);
                    }
                    indexesFiles[i3].delete();
                }
                ++i3;
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append(super.toString());
        buffer.append("In-memory indexes:\n");
        int count = 0;
        buffer.append(++count).append(" - ").append(this.index.toString()).append('\n');
        return buffer.toString();
    }

    private char[] readIndexState() {
        try {
            return Util.getFileCharContent(this.savedIndexNamesFile, null);
        }
        catch (IOException iOException) {
            if (IndexManager.VERBOSE) {
                JobManager.verbose("Failed to read saved index file names");
            }
            return new char[0];
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateIndexState(String indexName, Integer indexState) {
        block22: {
            this.getIndexStates();
            if (indexState != null) {
                if (indexState.equals(this.indexStates.get(indexName))) {
                    return;
                }
                this.indexStates.put(indexName, indexState);
            } else {
                if (!this.indexStates.containsKey(indexName)) {
                    return;
                }
                this.indexStates.removeKey(indexName);
            }
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(this.savedIndexNamesFile));
                    Object[] indexNames = this.indexStates.keyTable;
                    Object[] states = this.indexStates.valueTable;
                    int i = 0;
                    int l = states.length;
                    while (i < l) {
                        if (states[i] == SAVED_STATE) {
                            writer.write((String)indexNames[i]);
                            writer.write(10);
                        }
                        ++i;
                    }
                }
                catch (IOException iOException) {
                    if (IndexManager.VERBOSE) {
                        JobManager.verbose("Failed to write saved index file names");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (writer == null) throw throwable;
                try {
                    writer.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var8_10 = null;
                if (writer == null) break block22;
            }
            try {}
            catch (IOException iOException) {}
            writer.close();
        }
        if (!IndexManager.VERBOSE) return;
        String state = "?";
        if (indexState == SAVED_STATE) {
            state = "SAVED";
        } else if (indexState == UPDATING_STATE) {
            state = "UPDATING";
        } else if (indexState == UNKNOWN_STATE) {
            state = "UNKNOWN";
        } else if (indexState == REBUILDING_STATE) {
            state = "REBUILDING";
        }
        JobManager.verbose("-> index state updated to: " + state + " for: " + indexName);
    }

    public ICDTIndexer[] getIndexers() {
        return null;
    }

    public String[] getPathVariables() {
        return null;
    }

    public void resolvePathVariables() {
    }

    public void merge() {
    }

    public boolean canMergeWith(IIndexStorage storage) {
        return false;
    }

    public boolean getNeedToSave() {
        return this.needToSave;
    }

    public void setNeedToSave(boolean needToSave) {
        this.needToSave = needToSave;
    }

    public void jobWasCancelled(IPath path) {
        this.index = null;
        this.monitor = null;
        this.updateIndexState(this.computeIndexName(path), UNKNOWN_STATE);
    }

    public ReadWriteMonitor getIndexAccessMonitor() {
        return this.indexAccessMonitor;
    }
}

