/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.DebugCoreMessages;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CAddressBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CFunctionBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CLineBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CWatchpoint;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;

public class CDIDebugModel {
    public static String getPluginIdentifier() {
        return CDebugCorePlugin.getUniqueIdentifier();
    }

    public static IDebugTarget newDebugTarget(final ILaunch launch, final IProject project, final ICDITarget cdiTarget, final String name, final IProcess debuggeeProcess, final IBinaryParser.IBinaryObject file, final boolean allowTerminate, final boolean allowDisconnect, boolean stopInMain, final boolean resumeTarget) throws DebugException {
        final IDebugTarget[] target = new IDebugTarget[1];
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor m) throws CoreException {
                boolean stop = launch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
                target[0] = new CDebugTarget(launch, project, cdiTarget, name, debuggeeProcess, file, allowTerminate, allowDisconnect);
                ((CDebugTarget)target[0]).start(stop, resumeTarget);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(r, null);
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e);
            throw new DebugException(e.getStatus());
        }
        return target[0];
    }

    public static IDebugTarget newDebugTarget(ILaunch launch, IProject project, ICDITarget cdiTarget, String name, IProcess debuggeeProcess, IBinaryParser.IBinaryObject file, boolean allowTerminate, boolean allowDisconnect, boolean resumeTarget) throws DebugException {
        return CDIDebugModel.newDebugTarget(launch, project, cdiTarget, name, debuggeeProcess, file, allowTerminate, allowDisconnect, false, resumeTarget);
    }

    public static ICLineBreakpoint createLineBreakpoint(String sourceHandle, IResource resource, int lineNumber, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", CDIDebugModel.getPluginIdentifier());
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("org.eclipse.debug.core.enabled", new Boolean(enabled));
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
        attributes.put("org.eclipse.cdt.debug.core.sourceHandle", sourceHandle);
        return new CLineBreakpoint(resource, attributes, register);
    }

    public static ICAddressBreakpoint createAddressBreakpoint(String module, String sourceHandle, IResource resource, IAddress address, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        return CDIDebugModel.createAddressBreakpoint(module, sourceHandle, resource, -1, address, enabled, ignoreCount, condition, register);
    }

    public static ICAddressBreakpoint createAddressBreakpoint(String module, String sourceHandle, IResource resource, int lineNumber, IAddress address, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", CDIDebugModel.getPluginIdentifier());
        attributes.put("charStart", new Integer(-1));
        attributes.put("charEnd", new Integer(-1));
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("org.eclipse.cdt.debug.core.address", address.toHexAddressString());
        attributes.put("org.eclipse.debug.core.enabled", new Boolean(enabled));
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
        attributes.put("org.eclipse.cdt.debug.core.sourceHandle", sourceHandle);
        attributes.put("org.eclipse.cdt.debug.core.module", module);
        return new CAddressBreakpoint(resource, attributes, register);
    }

    public static ICWatchpoint createWatchpoint(String sourceHandle, IResource resource, boolean writeAccess, boolean readAccess, String expression, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", CDIDebugModel.getPluginIdentifier());
        attributes.put("org.eclipse.debug.core.enabled", new Boolean(enabled));
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
        attributes.put("org.eclipse.cdt.debug.core.sourceHandle", sourceHandle);
        attributes.put("org.eclipse.cdt.debug.core.expression", expression);
        attributes.put("org.eclipse.cdt.debug.core.read", new Boolean(readAccess));
        attributes.put("org.eclipse.cdt.debug.core.write", new Boolean(writeAccess));
        return new CWatchpoint(resource, attributes, register);
    }

    public static ICWatchpoint createWatchpoint(String sourceHandle, IResource resource, int charStart, int charEnd, int lineNumber, boolean writeAccess, boolean readAccess, String expression, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", CDIDebugModel.getPluginIdentifier());
        attributes.put("charStart", new Integer(charStart));
        attributes.put("charEnd", new Integer(charEnd));
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("org.eclipse.debug.core.enabled", new Boolean(enabled));
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
        attributes.put("org.eclipse.cdt.debug.core.sourceHandle", sourceHandle);
        attributes.put("org.eclipse.cdt.debug.core.expression", expression);
        attributes.put("org.eclipse.cdt.debug.core.read", new Boolean(readAccess));
        attributes.put("org.eclipse.cdt.debug.core.write", new Boolean(writeAccess));
        return new CWatchpoint(resource, attributes, register);
    }

    public static ICFunctionBreakpoint createFunctionBreakpoint(String sourceHandle, IResource resource, String function, int charStart, int charEnd, int lineNumber, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", CDIDebugModel.getPluginIdentifier());
        attributes.put("charStart", new Integer(charStart));
        attributes.put("charEnd", new Integer(charEnd));
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("org.eclipse.cdt.debug.core.function", function);
        attributes.put("org.eclipse.debug.core.enabled", new Boolean(enabled));
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
        attributes.put("org.eclipse.cdt.debug.core.sourceHandle", sourceHandle);
        return new CFunctionBreakpoint(resource, attributes, register);
    }

    public static ICLineBreakpoint lineBreakpointExists(String sourceHandle, IResource resource, int lineNumber) throws CoreException {
        String modelId = CDIDebugModel.getPluginIdentifier();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            ICLineBreakpoint breakpoint;
            if (breakpoints[i] instanceof ICLineBreakpoint && CDIDebugModel.sameSourceHandle(sourceHandle, (breakpoint = (ICLineBreakpoint)breakpoints[i]).getSourceHandle()) && breakpoint.getMarker().getResource().equals((Object)resource) && breakpoint.getLineNumber() == lineNumber) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    public static ICWatchpoint watchpointExists(String sourceHandle, IResource resource, String expression) throws CoreException {
        String modelId = CDIDebugModel.getPluginIdentifier();
        String markerType = CWatchpoint.getMarkerType();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            ICWatchpoint breakpoint;
            if (breakpoints[i] instanceof ICWatchpoint && (breakpoint = (ICWatchpoint)breakpoints[i]).getMarker().getType().equals(markerType) && CDIDebugModel.sameSourceHandle(sourceHandle, breakpoint.getSourceHandle()) && breakpoint.getMarker().getResource().equals((Object)resource) && breakpoint.getExpression().equals(expression)) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    public static ICFunctionBreakpoint functionBreakpointExists(String sourceHandle, IResource resource, String function) throws CoreException {
        String modelId = CDIDebugModel.getPluginIdentifier();
        String markerType = CFunctionBreakpoint.getMarkerType();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            ICFunctionBreakpoint breakpoint;
            if (breakpoints[i] instanceof ICFunctionBreakpoint && (breakpoint = (ICFunctionBreakpoint)breakpoints[i]).getMarker().getType().equals(markerType) && CDIDebugModel.sameSourceHandle(sourceHandle, breakpoint.getSourceHandle()) && breakpoint.getMarker().getResource().equals((Object)resource) && breakpoint.getFunction() != null && breakpoint.getFunction().equals(function)) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    public static IDebugTarget newDebugTarget(ILaunch launch, ICDITarget target, String name, IProcess iprocess, IProcess debuggerProcess, IFile file, boolean allowTerminate, boolean allowDisconnect, boolean stopInMain) throws CoreException {
        IBinaryParser.IBinaryExecutable exeFile = CDIDebugModel.getBinary(file);
        return CDIDebugModel.newDebugTarget(launch, file.getProject(), target, name, iprocess, (IBinaryParser.IBinaryObject)exeFile, allowTerminate, allowDisconnect, stopInMain, true);
    }

    public static IDebugTarget newAttachDebugTarget(ILaunch launch, ICDITarget target, String name, IProcess debuggerProcess, IFile file) throws CoreException {
        IBinaryParser.IBinaryExecutable exeFile = CDIDebugModel.getBinary(file);
        return CDIDebugModel.newDebugTarget(launch, file.getProject(), target, name, null, (IBinaryParser.IBinaryObject)exeFile, true, true, false);
    }

    public static IDebugTarget newCoreFileDebugTarget(ILaunch launch, ICDITarget target, String name, IProcess debuggerProcess, IFile file) throws CoreException {
        IBinaryParser.IBinaryExecutable exeFile = CDIDebugModel.getBinary(file);
        return CDIDebugModel.newDebugTarget(launch, file.getProject(), target, name, null, (IBinaryParser.IBinaryObject)exeFile, true, false, false);
    }

    private static IBinaryParser.IBinaryExecutable getBinary(IFile file) throws CoreException {
        IProject project = file.getProject();
        ICExtensionReference[] binaryParsersExt = CCorePlugin.getDefault().getBinaryParserExtensions(project);
        int i = 0;
        while (i < binaryParsersExt.length) {
            IBinaryParser parser = (IBinaryParser)binaryParsersExt[i].createExtension();
            try {
                IBinaryParser.IBinaryFile exe = parser.getBinary(file.getLocation());
                if (exe instanceof IBinaryParser.IBinaryExecutable) {
                    return (IBinaryParser.IBinaryExecutable)exe;
                }
            }
            catch (IOException iOException) {}
            ++i;
        }
        throw new CoreException((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), -1, DebugCoreMessages.getString("CDIDebugModel.0"), null));
    }

    private static boolean sameSourceHandle(String handle1, String handle2) {
        if (handle1 == null || handle2 == null) {
            return false;
        }
        Path path1 = new Path(handle1);
        Path path2 = new Path(handle2);
        if (path1.isValidPath(handle1) && path2.isValidPath(handle2)) {
            return path1.equals((Object)path2);
        }
        return handle1.equals(handle2);
    }
}

