/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.internal.ui.text.BufferedDocumentScanner;
import org.eclipse.cdt.internal.ui.text.ICPartitions;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class FastCPartitionScanner
implements IPartitionTokenScanner,
ICPartitions {
    private static final int CCODE = 0;
    private static final int SINGLE_LINE_COMMENT = 1;
    private static final int MULTI_LINE_COMMENT = 2;
    private static final int CHARACTER = 3;
    private static final int STRING = 4;
    private static final int NONE = 0;
    private static final int BACKSLASH = 1;
    private static final int SLASH = 2;
    private static final int SLASH_STAR = 3;
    private static final int STAR = 4;
    private static final int CARRIAGE_RETURN = 5;
    private final BufferedDocumentScanner fScanner = new BufferedDocumentScanner(1000);
    private int fTokenOffset;
    private int fTokenLength;
    private int fState;
    private int fLast;
    private int fPrefixLength;
    private final IToken[] fTokens = new IToken[]{new Token(null), new Token((Object)"c_single_line_comment"), new Token((Object)"c_multi_line_comment"), new Token((Object)"c_character"), new Token((Object)"c_string")};

    public IToken nextToken() {
        this.fTokenOffset += this.fTokenLength;
        this.fTokenLength = this.fPrefixLength;
        char[][] delimiters = this.fScanner.getLegalLineDelimiters();
        while (true) {
            int ch;
            if ((ch = this.fScanner.read()) == -1) {
                if (this.fTokenLength > 0) {
                    this.fLast = 0;
                    return this.preFix(this.fState, 0, 0, 0);
                }
                this.fLast = 0;
                this.fPrefixLength = 0;
                return Token.EOF;
            }
            int delim = FastCPartitionScanner.detectLineDelimiter(ch, this.fScanner, delimiters);
            if (delim != -1) {
                int len = delimiters[delim].length;
                if (len > 1) {
                    this.fTokenLength += len - 1;
                }
                switch (this.fState) {
                    case 1: 
                    case 3: {
                        if (this.fLast == 1) break;
                        return this.postFix(this.fState);
                    }
                }
                this.consume();
                continue;
            }
            block3 : switch (this.fState) {
                case 0: {
                    switch (ch) {
                        case 47: {
                            if (this.fLast == 2) {
                                if (this.fTokenLength - FastCPartitionScanner.getLastLength(this.fLast) > 0) {
                                    return this.preFix(0, 1, 0, 2);
                                }
                                this.preFix(0, 1, 0, 2);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                break block3;
                            }
                            ++this.fTokenLength;
                            this.fLast = 2;
                            break block3;
                        }
                        case 42: {
                            if (this.fLast == 2) {
                                if (this.fTokenLength - FastCPartitionScanner.getLastLength(this.fLast) > 0) {
                                    return this.preFix(0, 2, 3, 2);
                                }
                                this.preFix(0, 2, 3, 2);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                break block3;
                            }
                            this.consume();
                            break block3;
                        }
                        case 39: {
                            this.fLast = 0;
                            if (this.fTokenLength > 0) {
                                return this.preFix(0, 3, 0, 1);
                            }
                            this.preFix(0, 3, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break block3;
                        }
                        case 34: {
                            this.fLast = 0;
                            if (this.fTokenLength > 0) {
                                return this.preFix(0, 4, 0, 1);
                            }
                            this.preFix(0, 4, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            this.consume();
                            break block3;
                        }
                    }
                    this.consume();
                    break;
                }
                case 1: {
                    switch (ch) {
                        case 92: {
                            this.fLast = this.fLast == 1 ? 0 : 1;
                            ++this.fTokenLength;
                            break block3;
                        }
                    }
                    this.consume();
                    break;
                }
                case 2: {
                    switch (ch) {
                        case 42: {
                            ++this.fTokenLength;
                            this.fLast = 4;
                            break block3;
                        }
                        case 47: {
                            if (this.fLast == 4) {
                                return this.postFix(2);
                            }
                            this.consume();
                            break block3;
                        }
                    }
                    this.consume();
                    break;
                }
                case 4: {
                    switch (ch) {
                        case 92: {
                            this.fLast = this.fLast == 1 ? 0 : 1;
                            ++this.fTokenLength;
                            break block3;
                        }
                        case 34: {
                            if (this.fLast != 1) {
                                return this.postFix(4);
                            }
                            this.consume();
                            break block3;
                        }
                    }
                    this.consume();
                    break;
                }
                case 3: {
                    switch (ch) {
                        case 92: {
                            this.fLast = this.fLast == 1 ? 0 : 1;
                            ++this.fTokenLength;
                            break block3;
                        }
                        case 39: {
                            if (this.fLast != 1) {
                                return this.postFix(3);
                            }
                            this.consume();
                            break block3;
                        }
                    }
                    this.consume();
                }
            }
        }
    }

    private static final int detectLineDelimiter(int ch, ICharacterScanner scanner, char[][] delimiters) {
        int longestDelimiter = -1;
        int maxLen = 0;
        int i = 0;
        while (i < delimiters.length) {
            int len;
            char[] delim = delimiters[i];
            if (ch == delim[0] && (len = delim.length) > maxLen && (len == 1 || FastCPartitionScanner.sequenceDetected(scanner, delim, 1, len))) {
                maxLen = len;
                longestDelimiter = i;
            }
            ++i;
        }
        return longestDelimiter;
    }

    private static final boolean sequenceDetected(ICharacterScanner scanner, char[] sequence, int beginIndex, int endIndex) {
        int charsRead = 0;
        int i = beginIndex;
        while (i < endIndex) {
            int c = scanner.read();
            if (c != -1) {
                ++charsRead;
            }
            if (c != sequence[i]) {
                while (charsRead > 0) {
                    scanner.unread();
                    --charsRead;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    private static final int getLastLength(int last) {
        switch (last) {
            default: {
                return -1;
            }
            case 0: {
                return 0;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return 1;
            }
            case 3: 
        }
        return 2;
    }

    private final void consume() {
        ++this.fTokenLength;
        this.fLast = 0;
    }

    private final IToken postFix(int state) {
        ++this.fTokenLength;
        this.fLast = 0;
        this.fState = 0;
        this.fPrefixLength = 0;
        return this.fTokens[state];
    }

    private final IToken preFix(int state, int newState, int last, int prefixLength) {
        this.fTokenLength -= FastCPartitionScanner.getLastLength(this.fLast);
        this.fLast = last;
        this.fPrefixLength = prefixLength;
        IToken token = this.fTokens[state];
        this.fState = newState;
        return token;
    }

    private static int getState(String contentType) {
        if (contentType == null) {
            return 0;
        }
        if (contentType.equals("c_single_line_comment")) {
            return 1;
        }
        if (contentType.equals("c_multi_line_comment")) {
            return 2;
        }
        if (contentType.equals("c_string")) {
            return 4;
        }
        if (contentType.equals("c_character")) {
            return 3;
        }
        return 0;
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        this.fScanner.setRange(document, offset, length);
        this.fTokenOffset = partitionOffset;
        this.fTokenLength = 0;
        this.fPrefixLength = offset - partitionOffset;
        this.fLast = 0;
        this.fState = offset == partitionOffset ? 0 : FastCPartitionScanner.getState(contentType);
    }

    public void setRange(IDocument document, int offset, int length) {
        this.fScanner.setRange(document, offset, length);
        this.fTokenOffset = offset;
        this.fTokenLength = 0;
        this.fPrefixLength = 0;
        this.fLast = 0;
        this.fState = 0;
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }
}

